/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.tags.WikiTagBase;

public class PageSizeTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logger.getLogger(PageSizeTag.class);

    @Override
    public final int doWikiStartTag() throws IOException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        WikiPage page = this.m_wikiContext.getPage();
        try {
            if (page != null) {
                long size = page.getSize();
                if (size == -1L && engine.pageExists(page)) {
                    size = engine.getPureText(page.getName(), page.getVersion()).length();
                    page.setSize(size);
                }
                this.pageContext.getOut().write(Long.toString(size));
            }
        }
        catch (ProviderException e) {
            log.warn((Object)"Providers did not work: ", (Throwable)e);
            this.pageContext.getOut().write("Error determining page size: " + e.getMessage());
        }
        return 0;
    }
}

