/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tasks.auth;

import java.util.Locale;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.util.MailUtil;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Task;

public class SaveUserProfileTask
extends Task {
    private static final long serialVersionUID = 6994297086560480285L;
    private static final Logger LOG = Logger.getLogger(SaveUserProfileTask.class);
    private final WikiEngine m_engine;
    private final Locale m_loc;

    public SaveUserProfileTask(WikiEngine engine, Locale loc) {
        super("task.createUserProfile");
        this.m_engine = engine;
        this.m_loc = loc;
    }

    @Override
    public Outcome execute() throws WikiException {
        UserProfile profile = (UserProfile)this.getWorkflow().getAttribute("userProfile");
        this.m_engine.getUserManager().getUserDatabase().save(profile);
        if (profile.getEmail() != null) {
            try {
                InternationalizationManager i18n = this.m_engine.getInternationalizationManager();
                String app = this.m_engine.getApplicationName();
                String to = profile.getEmail();
                String subject = i18n.get("templates.default", this.m_loc, "notification.createUserProfile.accept.subject", app);
                String content = i18n.get("templates.default", this.m_loc, "notification.createUserProfile.accept.content", app, profile.getLoginName(), profile.getFullname(), profile.getEmail(), this.m_engine.getURL(WikiContext.LOGIN, null, null, true));
                MailUtil.sendMessage((Properties)this.m_engine.getWikiProperties(), (String)to, (String)subject, (String)content);
            }
            catch (AddressException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            catch (MessagingException me) {
                LOG.error((Object)"Could not send registration confirmation e-mail. Is the e-mail server running?", (Throwable)me);
            }
        }
        return Outcome.STEP_COMPLETE;
    }
}

