/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tasks.pages;

import java.security.Principal;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Task;
import org.apache.wiki.workflow.Workflow;

public class PreSaveWikiPageTask
extends Task {
    private static final long serialVersionUID = 6304715570092804615L;
    private final WikiContext m_context;
    private final String m_proposedText;

    public PreSaveWikiPageTask(WikiContext context, String proposedText) {
        super("task.preSaveWikiPage");
        this.m_context = context;
        this.m_proposedText = proposedText;
    }

    @Override
    public Outcome execute() throws WikiException {
        Principal wup;
        WikiEngine engine = this.m_context.getEngine();
        Workflow workflow = this.getWorkflow();
        WikiPage page = this.m_context.getPage();
        if (page.getAuthor() == null && (wup = this.m_context.getCurrentUser()) != null) {
            page.setAuthor(wup.getName());
        }
        String saveText = engine.getFilterManager().doPreSaveFiltering(this.m_context, this.m_proposedText);
        workflow.setAttribute("wikiContext", this.m_context);
        workflow.setAttribute("fact.proposedText", saveText);
        return Outcome.STEP_COMPLETE;
    }
}

