/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import org.apache.wiki.ui.Command;
import org.apache.wiki.ui.GroupCommand;
import org.apache.wiki.ui.PageCommand;
import org.apache.wiki.ui.RedirectCommand;
import org.apache.wiki.ui.WikiCommand;
import org.apache.wiki.util.TextUtil;

public abstract class AbstractCommand
implements Command {
    private static final Command[] ALL_COMMANDS = new Command[]{PageCommand.ATTACH, PageCommand.COMMENT, PageCommand.CONFLICT, PageCommand.DELETE, PageCommand.DIFF, PageCommand.EDIT, PageCommand.INFO, PageCommand.NONE, PageCommand.OTHER, PageCommand.PREVIEW, PageCommand.RENAME, PageCommand.RSS, PageCommand.UPLOAD, PageCommand.VIEW, GroupCommand.DELETE_GROUP, GroupCommand.EDIT_GROUP, GroupCommand.VIEW_GROUP, WikiCommand.CREATE_GROUP, WikiCommand.ERROR, WikiCommand.FIND, WikiCommand.INSTALL, WikiCommand.LOGIN, WikiCommand.LOGOUT, WikiCommand.MESSAGE, WikiCommand.PREFS, WikiCommand.WORKFLOW, WikiCommand.ADMIN, RedirectCommand.REDIRECT};
    private static final String HTTPS = "HTTPS://";
    private static final String HTTP = "HTTP://";
    private final String m_jsp;
    private final String m_jspFriendlyName;
    private final String m_urlPattern;
    private final String m_requestContext;
    private final String m_contentTemplate;
    private final Object m_target;

    protected AbstractCommand(String requestContext, String urlPattern, String contentTemplate, Object target) {
        if (requestContext == null || urlPattern == null) {
            throw new IllegalArgumentException("Request context, URL pattern and type must not be null.");
        }
        this.m_requestContext = requestContext;
        if (urlPattern.toUpperCase().startsWith(HTTP) || urlPattern.toUpperCase().endsWith(HTTPS)) {
            this.m_jsp = urlPattern;
            this.m_jspFriendlyName = "Special Page";
        } else {
            String jsp = urlPattern;
            int qPosition = urlPattern.indexOf(63);
            if (qPosition != -1) {
                jsp = jsp.substring(0, qPosition);
            }
            this.m_jsp = this.removeSubstitutions(jsp);
            this.m_jspFriendlyName = this.m_jsp.toUpperCase().endsWith(".JSP") ? TextUtil.beautifyString((String)this.m_jsp.substring(0, this.m_jsp.length() - 4)) : this.m_jsp;
        }
        this.m_urlPattern = urlPattern;
        this.m_contentTemplate = contentTemplate;
        this.m_target = target;
    }

    private String removeSubstitutions(String jsp) {
        StringBuilder newjsp = new StringBuilder(jsp.length());
        for (int i = 0; i < jsp.length(); ++i) {
            char c = jsp.charAt(i);
            if (c == '%' && i < jsp.length() - 1 && Character.isLetterOrDigit(jsp.charAt(i + 1))) {
                ++i;
                continue;
            }
            newjsp.append(c);
        }
        return newjsp.toString();
    }

    public static final Command[] allCommands() {
        return (Command[])ALL_COMMANDS.clone();
    }

    @Override
    public abstract Command targetedCommand(Object var1);

    @Override
    public final String getContentTemplate() {
        return this.m_contentTemplate;
    }

    @Override
    public final String getJSP() {
        return this.m_jsp;
    }

    @Override
    public abstract String getName();

    @Override
    public final String getRequestContext() {
        return this.m_requestContext;
    }

    @Override
    public final Object getTarget() {
        return this.m_target;
    }

    @Override
    public final String getURLPattern() {
        return this.m_urlPattern;
    }

    protected final String getJSPFriendlyName() {
        return this.m_jspFriendlyName;
    }

    public final String toString() {
        return "Command[context=" + this.m_requestContext + ",urlPattern=" + this.m_urlPattern + ",jsp=" + this.m_jsp + (this.m_target == null ? "" : ",target=" + this.m_target + this.m_target.toString()) + "]";
    }
}

