/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.ui.AbstractCommand;
import org.apache.wiki.ui.Command;
import org.apache.wiki.ui.GroupCommand;
import org.apache.wiki.ui.PageCommand;
import org.apache.wiki.ui.RedirectCommand;
import org.apache.wiki.ui.WikiCommand;
import org.apache.wiki.util.TextUtil;

public final class CommandResolver {
    private static final String PROP_SPECIALPAGE = "jspwiki.specialPage.";
    private static final Map<String, Command> CONTEXTS = new HashMap<String, Command>();
    private static final Map<String, Command> JSPS = new HashMap<String, Command>();
    private final Logger m_log = Logger.getLogger(CommandResolver.class);
    private final WikiEngine m_engine;
    private final boolean m_matchEnglishPlurals;
    private final Map<String, Command> m_specialPages;

    public CommandResolver(WikiEngine engine, Properties properties) {
        this.m_engine = engine;
        this.m_specialPages = new HashMap<String, Command>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith(PROP_SPECIALPAGE)) continue;
            String specialPage = key.substring(PROP_SPECIALPAGE.length());
            String jsp = properties.getProperty(key);
            if (specialPage == null || jsp == null) continue;
            specialPage = specialPage.trim();
            Command command = JSPS.get(jsp = jsp.trim());
            if (command == null) {
                Command redirect = RedirectCommand.REDIRECT;
                command = redirect.targetedCommand(jsp);
            }
            this.m_specialPages.put(specialPage, command);
        }
        this.m_matchEnglishPlurals = TextUtil.getBooleanProperty((Properties)properties, (String)"jspwiki.translatorReader.matchEnglishPlurals", (boolean)true);
    }

    public static Command findCommand(String context) {
        Command command = CONTEXTS.get(context);
        if (command == null) {
            throw new IllegalArgumentException("Unsupported wiki context: " + context + ".");
        }
        return command;
    }

    public Command findCommand(HttpServletRequest request, String defaultContext) {
        WikiPage page;
        if (request == null) {
            return CommandResolver.findCommand(defaultContext);
        }
        Command command = null;
        String pageName = this.extractPageFromParameter(defaultContext, request);
        if (pageName != null) {
            command = this.m_specialPages.get(pageName);
        }
        if (command == null && (command = this.extractCommandFromPath(request)) == null && (command = CONTEXTS.get(defaultContext)) == null) {
            throw new IllegalArgumentException("Wiki context " + defaultContext + " is illegal.");
        }
        if (PageCommand.VIEW.equals(command) && pageName == null) {
            pageName = this.m_engine.getFrontPage();
        }
        if (command instanceof PageCommand && pageName != null && (page = this.resolvePage(request, pageName)) != null) {
            return command.targetedCommand(page);
        }
        String wiki = this.m_engine.getApplicationName();
        if (WikiCommand.CREATE_GROUP.equals(command)) {
            return WikiCommand.CREATE_GROUP.targetedCommand(wiki);
        }
        if (command instanceof GroupCommand) {
            String groupName = request.getParameter("group");
            if ((groupName = TextUtil.replaceEntities((String)groupName)) != null && groupName.length() > 0) {
                GroupPrincipal group = new GroupPrincipal(groupName);
                return command.targetedCommand(group);
            }
        }
        return command;
    }

    public String getFinalPageName(String page) throws ProviderException {
        boolean isThere = this.simplePageExists(page);
        String finalName = page;
        if (!isThere && this.m_matchEnglishPlurals) {
            finalName = page.endsWith("s") ? page.substring(0, page.length() - 1) : finalName + "s";
            isThere = this.simplePageExists(finalName);
        }
        if (!isThere && !(isThere = this.simplePageExists(finalName = MarkupParser.wikifyLink(page))) && this.m_matchEnglishPlurals) {
            finalName = finalName.endsWith("s") ? finalName.substring(0, finalName.length() - 1) : finalName + "s";
            isThere = this.simplePageExists(finalName);
        }
        return isThere ? finalName : null;
    }

    public String getSpecialPageReference(String page) {
        Command command = this.m_specialPages.get(page);
        if (command != null) {
            return this.m_engine.getURLConstructor().makeURL(command.getRequestContext(), command.getURLPattern(), true, null);
        }
        return null;
    }

    protected Command extractCommandFromPath(HttpServletRequest request) {
        int questionMark;
        String jsp = request.getServletPath();
        int hashMark = jsp.indexOf(35);
        if (hashMark != -1) {
            jsp = jsp.substring(0, hashMark);
        }
        if ((questionMark = jsp.indexOf(63)) != -1) {
            jsp = jsp.substring(0, questionMark);
        }
        if (jsp.startsWith("/")) {
            jsp = jsp.substring(1);
        }
        for (Map.Entry<String, Command> entry : this.m_specialPages.entrySet()) {
            Command specialCommand = entry.getValue();
            if (!specialCommand.getJSP().equals(jsp)) continue;
            return specialCommand;
        }
        if (jsp.length() > 0 && JSPS.containsKey(jsp)) {
            return JSPS.get(jsp);
        }
        return null;
    }

    protected String extractPageFromParameter(String requestContext, HttpServletRequest request) {
        block5: {
            try {
                String page = this.m_engine.getURLConstructor().parsePage(requestContext, request, this.m_engine.getContentEncoding());
                if (page == null) break block5;
                try {
                    String finalPage = this.getFinalPageName(page);
                    if (finalPage != null) {
                        page = finalPage;
                    }
                }
                catch (ProviderException finalPage) {
                    // empty catch block
                }
                return page;
            }
            catch (IOException e) {
                this.m_log.error((Object)"Unable to create context", (Throwable)e);
                throw new InternalWikiException("Big internal booboo, please check logs.", e);
            }
        }
        return null;
    }

    protected WikiPage resolvePage(HttpServletRequest request, String page) {
        WikiPage wikipage;
        int version = -1;
        String rev = request.getParameter("version");
        if (rev != null) {
            try {
                version = Integer.parseInt(rev);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((wikipage = this.m_engine.getPage(page, version)) == null) {
            page = MarkupParser.cleanLink(page);
            wikipage = new WikiPage(this.m_engine, page);
        }
        return wikipage;
    }

    protected boolean simplePageExists(String page) throws ProviderException {
        if (this.m_specialPages.containsKey(page)) {
            return true;
        }
        return this.m_engine.getPageManager().pageExists(page);
    }

    static {
        Command[] commands = AbstractCommand.allCommands();
        for (int i = 0; i < commands.length; ++i) {
            JSPS.put(commands[i].getJSP(), commands[i]);
            CONTEXTS.put(commands[i].getRequestContext(), commands[i]);
        }
    }
}

