/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.security.Permission;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.ui.AbstractCommand;
import org.apache.wiki.ui.Command;

public final class WikiCommand
extends AbstractCommand {
    public static final Command CREATE_GROUP = new WikiCommand("createGroup", "%uNewGroup.jsp", "NewGroupContent.jsp", null, "createGroups");
    public static final Command ERROR = new WikiCommand("error", "%uError.jsp", "DisplayMessage.jsp", null, null);
    public static final Command FIND = new WikiCommand("find", "%uSearch.jsp", "FindContent.jsp", null, null);
    public static final Command INSTALL = new WikiCommand("install", "%uInstall.jsp", null, null, null);
    public static final Command LOGIN = new WikiCommand("login", "%uLogin.jsp?redirect=%n", "LoginContent.jsp", null, "login");
    public static final Command LOGOUT = new WikiCommand("logout", "%uLogout.jsp", null, null, "login");
    public static final Command MESSAGE = new WikiCommand("message", "%uMessage.jsp", "DisplayMessage.jsp", null, null);
    public static final Command PREFS = new WikiCommand("prefs", "%uUserPreferences.jsp", "PreferencesContent.jsp", null, "editProfile");
    public static final Command WORKFLOW = new WikiCommand("workflow", "%uWorkflow.jsp", "WorkflowContent.jsp", null, null);
    public static final Command ADMIN = new WikiCommand("admin", "%uadmin/Admin.jsp", "AdminContent.jsp", null);
    private final String m_action;
    private final Permission m_permission;

    private WikiCommand(String requestContext, String urlPattern, String contentTemplate, String target, String action) {
        super(requestContext, urlPattern, contentTemplate, target);
        this.m_action = action;
        this.m_permission = target == null || this.m_action == null ? null : new WikiPermission(target, action);
    }

    private WikiCommand(String requestContext, String urlPattern, String contentTemplate, String target) {
        super(requestContext, urlPattern, contentTemplate, target);
        this.m_action = null;
        this.m_permission = new AllPermission(target);
    }

    @Override
    public Command targetedCommand(Object target) {
        if (target == null || !(target instanceof String)) {
            throw new IllegalArgumentException("Target must non-null and of type String.");
        }
        return new WikiCommand(this.getRequestContext(), this.getURLPattern(), this.getContentTemplate(), (String)target, this.m_action);
    }

    @Override
    public String getName() {
        return this.getJSPFriendlyName();
    }

    @Override
    public Permission requiredPermission() {
        return this.m_permission;
    }
}

