/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.log4j.NDC;
import org.apache.wiki.WatchDog;
import org.apache.wiki.WikiContext;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.ui.TemplateManager;
import org.apache.wiki.ui.WikiServletFilter;
import org.apache.wiki.url.DefaultURLConstructor;
import org.apache.wiki.util.TextUtil;

public class WikiJSPFilter
extends WikiServletFilter {
    private String m_wiki_encoding;
    private boolean useEncoding;

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.m_wiki_encoding = this.m_engine.getWikiProperties().getProperty("jspwiki.encoding");
        this.useEncoding = new Boolean(this.m_engine.getWikiProperties().getProperty("jspwiki.nofilterencoding", "false").trim()) == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        WatchDog w = this.m_engine.getCurrentWatchDog();
        try {
            NDC.push((String)(this.m_engine.getApplicationName() + ":" + ((HttpServletRequest)request).getRequestURI()));
            w.enterState("Filtering for URL " + ((HttpServletRequest)request).getRequestURI(), 90);
            JSPWikiServletResponseWrapper responseWrapper = new JSPWikiServletResponseWrapper((HttpServletResponse)response, this.m_wiki_encoding, this.useEncoding);
            String pagename = DefaultURLConstructor.parsePageFromURL((HttpServletRequest)request, Charset.forName(response.getCharacterEncoding()));
            this.fireEvent(24, pagename);
            super.doFilter(request, (ServletResponse)responseWrapper, chain);
            try {
                w.enterState("Delivering response", 30);
                WikiContext wikiContext = this.getWikiContext(request);
                String r = this.filter(wikiContext, (HttpServletResponse)responseWrapper);
                if (this.useEncoding) {
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), response.getCharacterEncoding());
                    out.write(r);
                    out.flush();
                    out.close();
                } else {
                    response.getWriter().write(r);
                }
                if (wikiContext != null) {
                    wikiContext.getWikiSession().clearMessages();
                }
                this.fireEvent(25, pagename);
            }
            finally {
                w.exitState();
            }
        }
        finally {
            w.exitState();
            NDC.pop();
            NDC.remove();
        }
    }

    private String filter(WikiContext wikiContext, HttpServletResponse response) {
        String string = response.toString();
        if (wikiContext != null) {
            String[] resourceTypes = TemplateManager.getResourceTypes(wikiContext);
            for (int i = 0; i < resourceTypes.length; ++i) {
                string = this.insertResources(wikiContext, string, resourceTypes[i]);
            }
            String[] headers = TemplateManager.getResourceRequests(wikiContext, "httpheader");
            for (int i = 0; i < headers.length; ++i) {
                String key = headers[i];
                String value = "";
                int split = headers[i].indexOf(58);
                if (split > 0 && split < headers[i].length() - 1) {
                    key = headers[i].substring(0, split);
                    value = headers[i].substring(split + 1);
                }
                response.addHeader(key.trim(), value.trim());
            }
        }
        return string;
    }

    private String insertResources(WikiContext wikiContext, String string, String type) {
        if (wikiContext == null) {
            return string;
        }
        String marker = TemplateManager.getMarker(wikiContext, type);
        int idx = string.indexOf(marker);
        if (idx == -1) {
            return string;
        }
        log.debug((Object)"...Inserting...");
        String[] resources = TemplateManager.getResourceRequests(wikiContext, type);
        StringBuilder concat = new StringBuilder(resources.length * 40);
        for (int i = 0; i < resources.length; ++i) {
            log.debug((Object)("...:::" + resources[i]));
            concat.append(resources[i]);
        }
        string = TextUtil.replaceString((String)string, (int)idx, (int)(idx + marker.length()), (String)concat.toString());
        return string;
    }

    protected final void fireEvent(int type, String pagename) {
        if (WikiEventManager.isListening(this.m_engine)) {
            WikiEventManager.fireEvent(this.m_engine, new WikiPageEvent(this.m_engine, type, pagename));
        }
    }

    private static class JSPWikiServletResponseWrapper
    extends HttpServletResponseWrapper {
        ByteArrayOutputStream m_output = new ByteArrayOutputStream(32768);
        private ByteArrayServletOutputStream m_servletOut = new ByteArrayServletOutputStream(this.m_output);
        private PrintWriter m_writer;
        private HttpServletResponse m_response;
        private boolean useEncoding;
        private static final int INIT_BUFFER_SIZE = 32768;

        public JSPWikiServletResponseWrapper(HttpServletResponse r, String wiki_encoding, boolean useEncoding) throws UnsupportedEncodingException {
            super(r);
            this.m_writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.m_servletOut), wiki_encoding), true);
            this.useEncoding = useEncoding;
            this.m_response = r;
        }

        public PrintWriter getWriter() {
            return this.m_writer;
        }

        public ServletOutputStream getOutputStream() {
            return this.m_servletOut;
        }

        public void flushBuffer() throws IOException {
            this.m_writer.flush();
            super.flushBuffer();
        }

        public String toString() {
            try {
                this.flushBuffer();
            }
            catch (IOException e) {
                WikiServletFilter.log.error((Object)e);
                return "";
            }
            try {
                if (this.useEncoding) {
                    return this.m_output.toString(this.m_response.getCharacterEncoding());
                }
                return this.m_output.toString();
            }
            catch (UnsupportedEncodingException e) {
                WikiServletFilter.log.error((Object)e);
                return "";
            }
        }

        class ByteArrayServletOutputStream
        extends ServletOutputStream {
            ByteArrayOutputStream m_buffer;

            public ByteArrayServletOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
                this.m_buffer = byteArrayOutputStream;
            }

            public void write(int aInt) throws IOException {
                this.m_buffer.write(aInt);
            }

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }
        }
    }
}

