/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.admin.beans;

import java.util.Collection;
import javax.management.NotCompliantMBeanException;
import org.apache.wiki.Release;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.ui.admin.SimpleAdminBean;
import org.apache.wiki.util.XHTML;
import org.apache.wiki.util.XhtmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.Format;

public abstract class ModuleBean
extends SimpleAdminBean {
    private static final String VER_WARNING = "<span class='warning'>This module is not compatible with this version of JSPWiki.</span>";

    public ModuleBean(WikiEngine engine) throws NotCompliantMBeanException {
        this.m_engine = engine;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String[] getMethodNames() {
        return new String[0];
    }

    @Override
    public String doGet(WikiContext context) {
        Collection<WikiModuleInfo> filters = this.modules();
        Element root = this.title();
        Element tb = this.containerForModuleDetail(root);
        Element trHead = this.heading();
        tb.addContent((Content)trHead);
        for (WikiModuleInfo info : filters) {
            Element tr = this.rowBody(info);
            tb.addContent((Content)tr);
        }
        return XhtmlUtil.serialize((Element)root, (Format)XhtmlUtil.EXPAND_EMPTY_NODES);
    }

    protected Element title() {
        Element root = XhtmlUtil.element((XHTML)XHTML.div);
        root.addContent((Content)XhtmlUtil.element((XHTML)XHTML.h4).addContent(this.getTitle()));
        return root;
    }

    protected Element containerForModuleDetail(Element root) {
        Element tb = XhtmlUtil.element((XHTML)XHTML.table).setAttribute("border", "1");
        root.addContent((Content)tb);
        return tb;
    }

    protected abstract Collection<WikiModuleInfo> modules();

    protected abstract Element heading();

    protected abstract Element rowBody(WikiModuleInfo var1);

    protected String validModuleVersion(WikiModuleInfo info) {
        return Release.isNewerOrEqual(info.getMinVersion()) && Release.isOlderOrEqual(info.getMaxVersion()) ? "" : VER_WARNING;
    }
}

