/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.url;

import java.nio.charset.Charset;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.ui.Command;
import org.apache.wiki.ui.CommandResolver;
import org.apache.wiki.url.URLConstructor;
import org.apache.wiki.util.TextUtil;

public class DefaultURLConstructor
implements URLConstructor {
    protected WikiEngine m_engine;
    protected String m_pathPrefix = "";

    @Override
    public void initialize(WikiEngine engine, Properties properties) {
        this.m_engine = engine;
        this.m_pathPrefix = engine.getBaseURL() + "/";
    }

    protected final String doReplacement(String baseptrn, String name, boolean absolute) {
        String baseurl = this.m_pathPrefix;
        if (absolute) {
            baseurl = this.m_engine.getBaseURL() + "/";
        }
        baseptrn = TextUtil.replaceString((String)baseptrn, (String)"%u", (String)baseurl);
        baseptrn = TextUtil.replaceString((String)baseptrn, (String)"%U", (String)this.m_engine.getBaseURL());
        baseptrn = TextUtil.replaceString((String)baseptrn, (String)"%n", (String)this.encodeURI(name));
        baseptrn = TextUtil.replaceString((String)baseptrn, (String)"%p", (String)this.m_pathPrefix);
        return baseptrn;
    }

    private String encodeURI(String uri) {
        uri = this.m_engine.encodeName(uri);
        uri = StringUtils.replace((String)uri, (String)"+", (String)"%20");
        uri = StringUtils.replace((String)uri, (String)"%2F", (String)"/");
        return uri;
    }

    public static String getURLPattern(String context, String name) throws IllegalArgumentException {
        if (context.equals(WikiContext.VIEW) && name == null) {
            return "%uWiki.jsp";
        }
        Command command = CommandResolver.findCommand(context);
        return command.getURLPattern();
    }

    private String makeURL(String context, String name, boolean absolute) {
        return this.doReplacement(DefaultURLConstructor.getURLPattern(context, name), name, absolute);
    }

    @Override
    public String makeURL(String context, String name, boolean absolute, String parameters) {
        parameters = parameters != null && parameters.length() > 0 ? (context.equals(WikiContext.ATTACH) ? "?" + parameters : (context.equals(WikiContext.NONE) ? (name.indexOf(63) != -1 ? "&amp;" : "?" + parameters) : "&amp;" + parameters)) : "";
        return this.makeURL(context, name, absolute) + parameters;
    }

    @Override
    public String parsePage(String context, HttpServletRequest request, Charset encoding) {
        String pagereq = request.getParameter("page");
        if (context.equals(WikiContext.ATTACH)) {
            pagereq = DefaultURLConstructor.parsePageFromURL(request, encoding);
        }
        return pagereq;
    }

    public static String parsePageFromURL(HttpServletRequest request, Charset encoding) {
        String name = request.getPathInfo();
        if (name == null || name.length() <= 1) {
            return null;
        }
        if (name.charAt(0) == '/') {
            return name.substring(1);
        }
        return name;
    }

    @Override
    public String getForwardPage(HttpServletRequest request) {
        return "Wiki.jsp";
    }
}

