/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WorkflowEvent;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Step;
import org.apache.wiki.workflow.WorkflowManager;

public class Workflow
implements Serializable {
    private static final long serialVersionUID = 5228149040690660032L;
    public static final Date TIME_NOT_SET = new Date(0L);
    public static final int ID_NOT_SET = 0;
    public static final int COMPLETED = 50;
    public static final int ABORTED = 40;
    public static final int WAITING = 30;
    public static final int RUNNING = -1;
    public static final int CREATED = -2;
    private Map<String, Object> m_attributes = null;
    private Step m_firstStep;
    private boolean m_started;
    private final LinkedList<Step> m_history = new LinkedList();
    private int m_id = 0;
    private final String m_key;
    private final Principal m_owner;
    private final List<Serializable> m_messageArgs;
    private int m_state;
    private Step m_currentStep = null;
    private WorkflowManager m_manager;

    public Workflow(String messageKey, Principal owner) {
        this.m_key = messageKey;
        this.m_manager = null;
        this.m_messageArgs = new ArrayList<Serializable>();
        this.m_owner = owner;
        this.m_started = false;
        this.m_state = -2;
    }

    public final synchronized void abort() {
        if (this.m_state == 40) {
            throw new IllegalStateException("The workflow has already been aborted.");
        }
        if (this.m_state == 50) {
            throw new IllegalStateException("The workflow has already completed.");
        }
        if (this.m_currentStep != null) {
            if (this.m_manager != null && this.m_currentStep instanceof Decision) {
                Decision d = (Decision)this.m_currentStep;
                this.m_manager.getDecisionQueue().remove(d);
            }
            this.m_currentStep.setOutcome(Outcome.STEP_ABORT);
            this.m_history.addLast(this.m_currentStep);
        }
        this.m_state = 40;
        this.fireEvent(50);
        this.cleanup();
    }

    public final void addMessageArgument(Serializable obj) {
        if (obj instanceof String || obj instanceof Date || obj instanceof Number) {
            this.m_messageArgs.add(obj);
            return;
        }
        throw new IllegalArgumentException("Message arguments must be of type String, Date or Number.");
    }

    public final synchronized Principal getCurrentActor() {
        if (this.m_currentStep == null) {
            return null;
        }
        return this.m_currentStep.getActor();
    }

    public final int getCurrentState() {
        return this.m_state;
    }

    public final Step getCurrentStep() {
        return this.m_currentStep;
    }

    public final synchronized Object getAttribute(String attr) {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.get(attr);
    }

    public final Date getEndTime() {
        Step last;
        if (this.isCompleted() && (last = this.m_history.getLast()) != null) {
            return last.getEndTime();
        }
        return TIME_NOT_SET;
    }

    public final synchronized int getId() {
        return this.m_id;
    }

    public final Serializable[] getMessageArguments() {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.m_owner.getName());
        Principal actor = this.getCurrentActor();
        args.add(actor == null ? "-" : actor.getName());
        args.addAll(this.m_messageArgs);
        return args.toArray(new Serializable[args.size()]);
    }

    public final String getMessageKey() {
        return this.m_key;
    }

    public final Principal getOwner() {
        return this.m_owner;
    }

    public final Date getStartTime() {
        return this.isStarted() ? this.m_firstStep.getStartTime() : TIME_NOT_SET;
    }

    public final synchronized WorkflowManager getWorkflowManager() {
        return this.m_manager;
    }

    public final List<Step> getHistory() {
        return Collections.unmodifiableList(this.m_history);
    }

    public final boolean isAborted() {
        return this.m_state == 40;
    }

    public final synchronized boolean isCompleted() {
        return this.m_started && this.m_state == 50;
    }

    public final boolean isStarted() {
        return this.m_started;
    }

    public final Step getPreviousStep() {
        return this.previousStep(this.m_currentStep);
    }

    public final synchronized void restart() throws WikiException {
        if (this.m_state != 30) {
            throw new IllegalStateException("Workflow is not paused; cannot restart.");
        }
        this.m_state = -1;
        this.fireEvent(20);
        try {
            this.processCurrentStep();
        }
        catch (WikiException e) {
            this.abort();
            throw e;
        }
    }

    public final synchronized void setAttribute(String attr, Object obj) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap<String, Object>();
        }
        this.m_attributes.put(attr, obj);
    }

    public final synchronized void setFirstStep(Step step) {
        this.m_firstStep = step;
    }

    public final synchronized void setId(int id) {
        this.m_id = id;
    }

    public final synchronized void setWorkflowManager(WorkflowManager manager) {
        this.m_manager = manager;
        this.addWikiEventListener(manager);
    }

    public final synchronized void start() throws WikiException {
        if (this.m_state == 40) {
            throw new IllegalStateException("Workflow cannot be started; it has already been aborted.");
        }
        if (this.m_started) {
            throw new IllegalStateException("Workflow has already started.");
        }
        this.m_started = true;
        this.m_state = -1;
        this.fireEvent(20);
        this.m_currentStep = this.m_firstStep;
        this.m_history.add(this.m_currentStep);
        try {
            this.processCurrentStep();
        }
        catch (WikiException e) {
            this.abort();
            throw e;
        }
    }

    public final synchronized void waitstate() {
        if (this.m_state != -1) {
            throw new IllegalStateException("Workflow is not running; cannot pause.");
        }
        this.m_state = 30;
        this.fireEvent(30);
    }

    protected void cleanup() {
        this.m_currentStep = null;
        this.m_attributes = null;
    }

    protected final synchronized void complete() {
        if (!this.isCompleted()) {
            this.m_state = 50;
            this.fireEvent(40);
            this.cleanup();
        }
    }

    protected final Step previousStep(Step step) {
        int index = this.m_history.indexOf(step);
        return index < 1 ? null : this.m_history.get(index - 1);
    }

    protected final void processCurrentStep() throws WikiException {
        while (this.m_currentStep != null) {
            if (!this.m_currentStep.isStarted()) {
                this.m_currentStep.start();
            }
            Outcome result = this.m_currentStep.execute();
            if (Outcome.STEP_ABORT.equals(result)) {
                this.abort();
                break;
            }
            if (!this.m_currentStep.isCompleted()) {
                this.m_currentStep.setOutcome(result);
            }
            Outcome outcome = this.m_currentStep.getOutcome();
            if (!outcome.isCompletion()) {
                this.waitstate();
                break;
            }
            Step nextStep = this.m_currentStep.getSuccessor(outcome);
            if (nextStep == null) {
                this.complete();
                break;
            }
            this.m_history.add(nextStep);
            this.m_currentStep = nextStep;
        }
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WorkflowEvent(this, type));
        }
    }
}

