/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.workflow.Fact;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.SimpleDecision;
import org.apache.wiki.workflow.SimpleNotification;
import org.apache.wiki.workflow.Step;
import org.apache.wiki.workflow.Workflow;
import org.apache.wiki.workflow.WorkflowManager;

public final class WorkflowBuilder {
    private static final Map<WikiEngine, WorkflowBuilder> BUILDERS = new ConcurrentHashMap<WikiEngine, WorkflowBuilder>();
    private final WikiEngine m_engine;

    private WorkflowBuilder(WikiEngine engine) {
        this.m_engine = engine;
    }

    public static WorkflowBuilder getBuilder(WikiEngine engine) {
        WorkflowBuilder builder = BUILDERS.get(engine);
        if (builder == null) {
            builder = new WorkflowBuilder(engine);
            BUILDERS.put(engine, builder);
        }
        return builder;
    }

    public Workflow buildApprovalWorkflow(Principal submitter, String workflowApproverKey, Step prepTask, String decisionKey, Fact[] facts, Step completionTask, String rejectedMessageKey) throws WikiException {
        WorkflowManager mgr = this.m_engine.getWorkflowManager();
        Workflow workflow = new Workflow(workflowApproverKey, submitter);
        boolean decisionRequired = mgr.requiresApproval(workflowApproverKey);
        if (decisionRequired) {
            Principal approverPrincipal = mgr.getApprover(workflowApproverKey);
            SimpleDecision decision = new SimpleDecision(workflow, decisionKey, approverPrincipal);
            if (facts != null) {
                for (Fact fact : facts) {
                    decision.addFact(fact);
                }
                if (facts.length > 0) {
                    workflow.addMessageArgument(facts[0].getValue());
                }
            }
            if (rejectedMessageKey != null) {
                SimpleNotification rejectNotification = new SimpleNotification(workflow, rejectedMessageKey, submitter);
                decision.addSuccessor(Outcome.DECISION_DENY, rejectNotification);
            }
            decision.addSuccessor(Outcome.DECISION_APPROVE, completionTask);
            if (prepTask == null) {
                workflow.setFirstStep(decision);
            } else {
                workflow.setFirstStep(prepTask);
                prepTask.addSuccessor(Outcome.STEP_COMPLETE, decision);
            }
        } else if (prepTask == null) {
            workflow.setFirstStep(completionTask);
        } else {
            workflow.setFirstStep(prepTask);
            prepTask.addSuccessor(Outcome.STEP_COMPLETE, completionTask);
        }
        if (prepTask != null) {
            prepTask.setWorkflow(workflow);
        }
        completionTask.setWorkflow(workflow);
        return workflow;
    }
}

