/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.auth.acl.UnresolvedPrincipal;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WorkflowEvent;
import org.apache.wiki.workflow.DecisionQueue;
import org.apache.wiki.workflow.Workflow;

public class WorkflowManager
implements WikiEventListener {
    public static final String WF_WP_SAVE_ATTR_PRESAVE_WIKI_CONTEXT = "wikiContext";
    public static final String WF_WP_SAVE_APPROVER = "workflow.saveWikiPage";
    public static final String WF_WP_SAVE_DECISION_MESSAGE_KEY = "decision.saveWikiPage";
    public static final String WF_WP_SAVE_REJECT_MESSAGE_KEY = "notification.saveWikiPage.reject";
    public static final String WF_WP_SAVE_FACT_PAGE_NAME = "fact.pageName";
    public static final String WF_WP_SAVE_FACT_DIFF_TEXT = "fact.diffText";
    public static final String WF_WP_SAVE_FACT_CURRENT_TEXT = "fact.currentText";
    public static final String WF_WP_SAVE_FACT_PROPOSED_TEXT = "fact.proposedText";
    public static final String WF_WP_SAVE_FACT_IS_AUTHENTICATED = "fact.isAuthenticated";
    public static final String WF_UP_CREATE_SAVE_ATTR_SAVED_PROFILE = "userProfile";
    public static final String WF_UP_CREATE_SAVE_APPROVER = "workflow.createUserProfile";
    public static final String WF_UP_CREATE_SAVE_DECISION_MESSAGE_KEY = "decision.createUserProfile";
    public static final String WF_UP_CREATE_SAVE_FACT_SUBMITTER = "fact.submitter";
    public static final String WF_UP_CREATE_SAVE_FACT_PREFS_LOGIN_NAME = "prefs.loginname";
    public static final String WF_UP_CREATE_SAVE_FACT_PREFS_FULL_NAME = "prefs.fullname";
    public static final String WF_UP_CREATE_SAVE_FACT_PREFS_EMAIL = "prefs.email";
    private final DecisionQueue m_queue = new DecisionQueue();
    private final Set<Workflow> m_workflows = ConcurrentHashMap.newKeySet();
    private final Map<String, Principal> m_approvers = new ConcurrentHashMap<String, Principal>();
    private final List<Workflow> m_completed = new CopyOnWriteArrayList<Workflow>();
    protected static final String PROPERTY_APPROVER_PREFIX = "jspwiki.approver.";
    private WikiEngine m_engine = null;
    private volatile int m_next = 1;

    public void start(Workflow workflow) throws WikiException {
        this.m_workflows.add(workflow);
        workflow.setWorkflowManager(this);
        workflow.setId(this.nextId());
        workflow.start();
    }

    public Collection<Workflow> getWorkflows() {
        ConcurrentHashMap.KeySetView workflows = ConcurrentHashMap.newKeySet();
        workflows.addAll(this.m_workflows);
        return workflows;
    }

    public List<Workflow> getCompletedWorkflows() {
        return new CopyOnWriteArrayList<Workflow>(this.m_completed);
    }

    public void initialize(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        for (String string : props.keySet()) {
            String approver;
            String key;
            if (!string.startsWith(PROPERTY_APPROVER_PREFIX) || (key = string.substring(PROPERTY_APPROVER_PREFIX.length())) == null || key.length() <= 0 || (approver = props.getProperty(string)) == null || approver.length() <= 0) continue;
            this.m_approvers.put(key, new UnresolvedPrincipal(approver));
        }
    }

    public boolean requiresApproval(String messageKey) {
        return this.m_approvers.containsKey(messageKey);
    }

    public Principal getApprover(String messageKey) throws WikiException {
        Principal approver = this.m_approvers.get(messageKey);
        if (approver == null) {
            throw new WikiException("Workflow '" + messageKey + "' does not require approval.");
        }
        if (approver instanceof UnresolvedPrincipal) {
            String name = approver.getName();
            approver = this.m_engine.getAuthorizationManager().resolvePrincipal(name);
            if (approver instanceof UnresolvedPrincipal) {
                throw new WikiException("Workflow approver '" + name + "' cannot not be resolved.");
            }
            this.m_approvers.put(messageKey, approver);
        }
        return approver;
    }

    protected WikiEngine getEngine() {
        if (this.m_engine == null) {
            throw new IllegalStateException("WikiEngine cannot be null; please initialize WorkflowManager first.");
        }
        return this.m_engine;
    }

    public DecisionQueue getDecisionQueue() {
        return this.m_queue;
    }

    private synchronized int nextId() {
        int current = this.m_next++;
        return current;
    }

    public Collection<Workflow> getOwnerWorkflows(WikiSession session) {
        ArrayList<Workflow> workflows = new ArrayList<Workflow>();
        if (session.isAuthenticated()) {
            Principal[] sessionPrincipals = session.getPrincipals();
            block0: for (Workflow w : this.m_workflows) {
                Principal owner = w.getOwner();
                for (Principal sessionPrincipal : sessionPrincipals) {
                    if (!sessionPrincipal.equals(owner)) continue;
                    workflows.add(w);
                    continue block0;
                }
            }
        }
        return workflows;
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        if (event instanceof WorkflowEvent) {
            Workflow workflow = (Workflow)event.getSrc();
            switch (event.getType()) {
                case 50: {
                    this.remove(workflow);
                    break;
                }
                case 40: {
                    this.remove(workflow);
                    break;
                }
                case 0: {
                    this.add(workflow);
                    break;
                }
            }
        }
    }

    protected void add(Workflow workflow) {
        if (workflow.getWorkflowManager() == null) {
            workflow.setWorkflowManager(this);
        }
        if (workflow.getId() == 0) {
            workflow.setId(this.nextId());
        }
        this.m_workflows.add(workflow);
    }

    protected void remove(Workflow workflow) {
        if (this.m_workflows.contains(workflow)) {
            this.m_workflows.remove(workflow);
            this.m_completed.add(workflow);
        }
    }
}

