/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class TranslationsCheck {
    private static final String[] LANGS = new String[]{"de", "en", "es", "fi", "fr", "it", "nl", "pt_BR", "ru", "zh_CN"};
    private static final String SITE_I18N_ROW = "<tr%s>\n  <td title=\"Available sets of core WikiPages for %s\"><a class=\"external\" href=\"https://search.maven.org/artifact/org.apache.jspwiki.wikipages/jspwiki-wikipages-%s\">%s</a></td>\n  <td>%d%%</td>\n  <td>%d</td>\n  <td>%d</td>\n</tr>\n";
    private final TreeSet<String> allProps = new TreeSet();
    private final TreeSet<String> duplProps = new TreeSet();
    String base = ".";
    String suffix = null;

    public static void main(String[] args) throws IOException {
        TranslationsCheck translations = new TranslationsCheck();
        if (args.length == 0) {
            System.out.println("Usage: java TranslationsCheck <language> [<path>]");
            System.out.println("Example: java TranslationsCheck nl [jspwiki-main/src/main/resources]");
            System.out.println("To output site i18n info use java TranslationsCheck site [<path>]");
            return;
        }
        translations.suffix = args[0];
        if (args.length >= 2) {
            translations.base = args[1];
        }
        if ("site".equals(translations.suffix)) {
            String site = "";
            for (int i = 0; i < LANGS.length; ++i) {
                translations.suffix = LANGS[i];
                site = site + translations.check(i);
            }
            site = site + "</table>\n</div>\n</div>\n</div>";
            Files.write(Paths.get("./i18n-table.txt", new String[0]), site.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        } else {
            translations.check(-1);
        }
    }

    String check(int lang) throws IOException {
        System.out.println("Internationalization property file differences between 'default en' and '" + this.suffix + "' following:\n");
        String fileSuffix = "en".equals(this.suffix) ? "" : "_" + this.suffix;
        Map<String, Integer> coreMetrics = this.checkFile("/CoreResources.properties", "/CoreResources" + fileSuffix + ".properties");
        Map<String, Integer> templateMetrics = this.checkFile("/templates/default.properties", "/templates/default" + fileSuffix + ".properties");
        Map<String, Integer> pluginMetrics = this.checkFile("/plugin/PluginResources.properties", "/plugin/PluginResources" + fileSuffix + ".properties");
        if (lang >= 0) {
            int expected = coreMetrics.get("expected") + templateMetrics.get("expected") + pluginMetrics.get("expected");
            int missing = coreMetrics.get("missing") + templateMetrics.get("missing") + pluginMetrics.get("missing");
            int completed = 100 * (expected - missing) / expected;
            int outdated = coreMetrics.get("outdated") + templateMetrics.get("outdated") + pluginMetrics.get("outdated");
            String odd = lang % 2 == 0 ? " class=\"odd\"" : "";
            return String.format(SITE_I18N_ROW, odd, this.suffix, this.suffix, this.suffix, completed, missing, outdated);
        }
        return "";
    }

    Map<String, Integer> checkFile(String en, String lang) throws IOException {
        HashMap<String, Integer> metrics = new HashMap<String, Integer>();
        try {
            metrics.putAll(this.diff(en, lang));
            metrics.put("duplicates", this.detectDuplicates(lang));
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to locate " + lang);
        }
        System.out.println("Duplicates overall (two or more occurences):");
        System.out.println("--------------------------------------------");
        Iterator<String> iter = this.duplProps.iterator();
        if (this.duplProps.size() == 0) {
            System.out.println("(none)");
        } else {
            while (iter.hasNext()) {
                System.out.println(iter.next());
            }
        }
        System.out.println("");
        return metrics;
    }

    public Map<String, Integer> diff(String source1, String source2) throws IOException {
        String value;
        int missing = 0;
        int outdated = 0;
        Properties p1 = new Properties();
        p1.load(this.getResourceAsStream(source1));
        Properties p2 = new Properties();
        p2.load(this.getResourceAsStream(source2));
        String msg = "Checking " + source2 + "...";
        System.out.println(msg);
        for (String name : this.sortedNames(p1)) {
            value = p1.getProperty(name);
            if (p2.get(name) != null) continue;
            if (++missing == 1) {
                System.out.println("\nMissing:");
                System.out.println("--------");
            }
            System.out.println(name + " = " + value);
        }
        if (missing > 0) {
            System.out.println("");
        }
        for (String name : this.sortedNames(p2)) {
            value = p2.getProperty(name);
            if (p1.get(name) != null) continue;
            if (++outdated == 1) {
                System.out.println("\nOutdated or superfluous:");
                System.out.println("------------------------");
            }
            System.out.println(name + " = " + value);
        }
        if (outdated > 0) {
            System.out.println("");
        }
        HashMap<String, Integer> diff = new HashMap<String, Integer>(2);
        diff.put("expected", p1.size());
        diff.put("missing", missing);
        diff.put("outdated", outdated);
        return diff;
    }

    private List<String> sortedNames(Properties p) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> iter = p.propertyNames();
        while (iter.hasMoreElements()) {
            list.add((String)iter.nextElement());
        }
        Collections.sort(list);
        return list;
    }

    public int detectDuplicates(String source) throws IOException {
        Properties p = new Properties();
        p.load(this.getResourceAsStream(source));
        Enumeration<?> iter = p.propertyNames();
        while (iter.hasMoreElements()) {
            String currentStr = (String)iter.nextElement();
            if (this.allProps.add(currentStr)) continue;
            this.duplProps.add(currentStr);
        }
        return this.duplProps.size();
    }

    InputStream getResourceAsStream(String source) {
        return TranslationsCheck.class.getClassLoader().getResourceAsStream(this.base + source);
    }
}

