/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.attachment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.providers.AttachmentProvider;
import org.apache.wiki.attachment.DynamicAttachment;

public interface AttachmentManager {
    public static final String PROP_PROVIDER = "jspwiki.attachmentProvider";
    public static final String PROP_MAXSIZE = "jspwiki.attachment.maxsize";
    public static final String PROP_ALLOWEDEXTENSIONS = "jspwiki.attachment.allowed";
    public static final String PROP_FORBIDDENEXTENSIONS = "jspwiki.attachment.forbidden";
    public static final String PROP_FORCEDOWNLOAD = "jspwiki.attachment.forceDownload";
    public static final String CACHE_NAME = "jspwiki.dynamicAttachmentCache";
    public static final int DEFAULT_CACHECAPACITY = 1000;

    public boolean attachmentsEnabled();

    default public Attachment getAttachmentInfo(String name) throws ProviderException {
        return this.getAttachmentInfo(name, -1);
    }

    default public Attachment getAttachmentInfo(String name, int version) throws ProviderException {
        if (name == null) {
            return null;
        }
        return this.getAttachmentInfo(null, name, version);
    }

    default public Attachment getAttachmentInfo(Context context, String attachmentname) throws ProviderException {
        return this.getAttachmentInfo(context, attachmentname, -1);
    }

    public Attachment getAttachmentInfo(Context var1, String var2, int var3) throws ProviderException;

    public String getAttachmentInfoName(Context var1, String var2);

    public List<Attachment> listAttachments(Page var1) throws ProviderException;

    default public boolean hasAttachments(Page wikipage) {
        try {
            return this.listAttachments(wikipage).size() > 0;
        }
        catch (Exception e) {
            Logger.getLogger(AttachmentManager.class).info((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean forceDownload(String var1);

    default public InputStream getAttachmentStream(Attachment att) throws IOException, ProviderException {
        return this.getAttachmentStream(null, att);
    }

    public InputStream getAttachmentStream(Context var1, Attachment var2) throws ProviderException, IOException;

    public void storeDynamicAttachment(Context var1, DynamicAttachment var2);

    public DynamicAttachment getDynamicAttachment(String var1);

    default public void storeAttachment(Attachment att, File source) throws IOException, ProviderException {
        try (FileInputStream in = new FileInputStream(source);){
            this.storeAttachment(att, in);
        }
    }

    public void storeAttachment(Attachment var1, InputStream var2) throws IOException, ProviderException;

    public List<Attachment> getVersionHistory(String var1) throws ProviderException;

    public Collection<Attachment> getAllAttachments() throws ProviderException;

    public AttachmentProvider getCurrentProvider();

    public void deleteVersion(Attachment var1) throws ProviderException;

    public void deleteAttachment(Attachment var1) throws ProviderException;

    public static String validateFileName(String filename) throws WikiException {
        if (filename == null || filename.trim().length() == 0) {
            Logger.getLogger(AttachmentManager.class).error((Object)"Empty file name given.");
            throw new WikiException("attach.empty.file");
        }
        String[] splitpath = filename.split("[/\\\\]");
        filename = splitpath[splitpath.length - 1];
        if ((filename = filename.trim()).toLowerCase().endsWith(".jsp") || filename.toLowerCase().endsWith(".jspf")) {
            Logger.getLogger(AttachmentManager.class).info((Object)"Attempt to upload a file with a .jsp/.jspf extension.  In certain cases this can trigger unwanted security side effects, so we're preventing it.");
            throw new WikiException("attach.unwanted.file");
        }
        return StringUtils.replaceChars((String)filename, (String)"#?\"'", (String)"____");
    }
}

