/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.util.HttpUtil;

public class AnonymousLoginModule
extends AbstractLoginModule {
    public static final String PROMPT = "User name";
    protected static final Logger log = Logger.getLogger(AnonymousLoginModule.class);

    @Override
    public boolean login() throws LoginException {
        HttpRequestCallback hcb = new HttpRequestCallback();
        Callback[] callbacks = new Callback[]{hcb};
        try {
            this.m_handler.handle(callbacks);
            HttpServletRequest request = hcb.getRequest();
            WikiPrincipal ipAddr = new WikiPrincipal(HttpUtil.getRemoteAddress((HttpServletRequest)request));
            if (log.isDebugEnabled()) {
                HttpSession session = request.getSession(false);
                String sid = session == null ? "(null)" : session.getId();
                log.debug((Object)("Logged in session ID=" + sid + "; IP=" + ipAddr));
            }
            this.m_principals.add(ipAddr);
            return true;
        }
        catch (IOException e) {
            log.error((Object)("IOException: " + e.getMessage()));
            return false;
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback, disallowing login.";
            log.error((Object)message, (Throwable)e);
            throw new LoginException(message);
        }
    }
}

