/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.pages;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.providers.PageProvider;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.pages.PageLock;
import org.apache.wiki.pages.PageSorter;

public interface PageManager
extends WikiEventListener {
    public static final String PROP_PAGEPROVIDER = "jspwiki.pageProvider";
    public static final String PROP_USECACHE = "jspwiki.usePageCache";
    public static final String PROP_LOCKEXPIRY = "jspwiki.lockExpiryTime";

    public PageProvider getProvider();

    public Collection<Page> getAllPages() throws ProviderException;

    public String getPageText(String var1, int var2) throws ProviderException;

    public String getPureText(String var1, int var2);

    default public String getPureText(Page page) {
        return this.getPureText(page.getName(), page.getVersion());
    }

    public String getText(String var1, int var2);

    default public String getText(String page) {
        return this.getText(page, -1);
    }

    default public String getText(Page page) {
        return this.getText(page.getName(), page.getVersion());
    }

    public void saveText(Context var1, String var2) throws WikiException;

    public void putPageText(Page var1, String var2) throws ProviderException;

    public PageLock lockPage(Page var1, String var2);

    public void unlockPage(PageLock var1);

    public PageLock getCurrentLock(Page var1);

    public List<PageLock> getActiveLocks();

    public Page getPage(String var1);

    public Page getPage(String var1, int var2);

    public Page getPageInfo(String var1, int var2) throws ProviderException;

    public <T extends Page> List<T> getVersionHistory(String var1);

    public String getCurrentProvider();

    public String getProviderDescription();

    public int getTotalPageCount();

    public Set<Page> getRecentChanges();

    public boolean pageExists(String var1) throws ProviderException;

    public boolean pageExists(String var1, int var2) throws ProviderException;

    default public boolean pageExists(Page page) throws ProviderException {
        if (page != null) {
            return this.pageExists(page.getName(), page.getVersion());
        }
        return false;
    }

    public boolean wikiPageExists(String var1);

    public boolean wikiPageExists(String var1, int var2) throws ProviderException;

    default public boolean wikiPageExists(Page page) throws ProviderException {
        if (page != null) {
            return this.wikiPageExists(page.getName(), page.getVersion());
        }
        return false;
    }

    public void deleteVersion(Page var1) throws ProviderException;

    public void deletePage(String var1) throws ProviderException;

    public void deletePage(Page var1) throws ProviderException;

    public PageSorter getPageSorter();
}

