/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.util.TextUtil;

public class ReferredPagesPlugin
implements Plugin {
    private static final Logger log = Logger.getLogger(ReferredPagesPlugin.class);
    private Engine m_engine;
    private int m_depth;
    private HashSet<String> m_exists = new HashSet();
    private StringBuffer m_result = new StringBuffer(1024);
    private PatternMatcher m_matcher = new Perl5Matcher();
    private Pattern m_includePattern;
    private Pattern m_excludePattern;
    private boolean m_formatCompact = true;
    private boolean m_formatSort = false;
    public static final String PARAM_ROOT = "page";
    public static final String PARAM_DEPTH = "depth";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_INCLUDE = "include";
    public static final String PARAM_EXCLUDE = "exclude";
    public static final String PARAM_FORMAT = "format";
    public static final int MIN_DEPTH = 1;
    public static final int MAX_DEPTH = 8;

    public String execute(Context context, Map<String, String> params) throws PluginException {
        String excludePattern;
        String includePattern;
        String format;
        this.m_engine = context.getEngine();
        Page page = context.getPage();
        if (page == null) {
            return "";
        }
        String rootname = params.get(PARAM_ROOT);
        if (rootname == null) {
            rootname = page.getName();
        }
        if ((format = params.get(PARAM_FORMAT)) == null) {
            format = "";
        }
        if (format.contains("full")) {
            this.m_formatCompact = false;
        }
        if (format.contains("sort")) {
            this.m_formatSort = true;
        }
        this.m_depth = TextUtil.parseIntParameter((String)params.get(PARAM_DEPTH), (int)1);
        if (this.m_depth > 8) {
            this.m_depth = 8;
        }
        if ((includePattern = params.get(PARAM_INCLUDE)) == null) {
            includePattern = ".*";
        }
        if ((excludePattern = params.get(PARAM_EXCLUDE)) == null) {
            excludePattern = "^$";
        }
        log.debug((Object)("Fetching referred pages for " + rootname + " with a depth of " + this.m_depth + " with include pattern of " + includePattern + " with exclude pattern of " + excludePattern));
        String href = context.getViewURL(rootname);
        String title = "ReferredPagesPlugin: depth[" + this.m_depth + "] include[" + includePattern + "] exclude[" + excludePattern + "] format[" + (this.m_formatCompact ? "compact" : "full") + (this.m_formatSort ? " sort" : "") + "]";
        this.m_result.append("<div class=\"ReferredPagesPlugin\">\n");
        this.m_result.append("<a class=\"wikipage\" href=\"" + href + "\" title=\"" + TextUtil.replaceEntities((String)title) + "\">" + TextUtil.replaceEntities((String)rootname) + "</a>\n");
        this.m_exists.add(rootname);
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_includePattern = compiler.compile(includePattern);
            this.m_excludePattern = compiler.compile(excludePattern);
        }
        catch (MalformedPatternException e) {
            if (this.m_includePattern == null) {
                throw new PluginException("Illegal include pattern detected.");
            }
            if (this.m_excludePattern == null) {
                throw new PluginException("Illegal exclude pattern detected.");
            }
            throw new PluginException("Illegal internal pattern detected.");
        }
        this.getReferredPages(context, rootname, 0);
        this.m_result.append("</div>\n");
        return this.m_result.toString();
    }

    private void getReferredPages(Context context, String pagename, int depth) {
        if (depth >= this.m_depth) {
            return;
        }
        if (pagename == null) {
            return;
        }
        if (!((PageManager)this.m_engine.getManager(PageManager.class)).wikiPageExists(pagename)) {
            return;
        }
        ReferenceManager mgr = (ReferenceManager)this.m_engine.getManager(ReferenceManager.class);
        Collection<String> allPages = mgr.findRefersTo(pagename);
        this.handleLinks(context, allPages, ++depth, pagename);
    }

    private void handleLinks(Context context, Collection<String> links, int depth, String pagename) {
        boolean isUL = false;
        HashSet<String> localLinkSet = new HashSet<String>();
        localLinkSet.add(pagename);
        ArrayList<String> allLinks = new ArrayList<String>();
        if (links != null) {
            allLinks.addAll(links);
        }
        if (this.m_formatSort) {
            ((PageManager)context.getEngine().getManager(PageManager.class)).getPageSorter().sort(allLinks);
        }
        for (String link : allLinks) {
            if (localLinkSet.contains(link)) continue;
            localLinkSet.add(link);
            if (!((PageManager)this.m_engine.getManager(PageManager.class)).wikiPageExists(link) || this.m_matcher.matches(link, this.m_excludePattern) || !this.m_matcher.matches(link, this.m_includePattern)) continue;
            if (this.m_exists.contains(link)) {
                if (this.m_formatCompact) continue;
                if (!isUL) {
                    isUL = true;
                    this.m_result.append("<ul>\n");
                }
                this.m_result.append("<li> " + TextUtil.replaceEntities((String)link) + "\n");
                this.getReferredPages(context, link, depth);
                this.m_result.append("\n</li>\n");
                continue;
            }
            if (!isUL) {
                isUL = true;
                this.m_result.append("<ul>\n");
            }
            String href = context.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), link);
            this.m_result.append("<li><a class=\"wikipage\" href=\"" + href + "\">" + TextUtil.replaceEntities((String)link) + "</a>\n");
            this.m_exists.add(link);
            this.getReferredPages(context, link, depth);
            this.m_result.append("\n</li>\n");
        }
        if (isUL) {
            this.m_result.append("</ul>\n");
        }
    }
}

