/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.preferences;

import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.PropertyReader;
import org.apache.wiki.util.TextUtil;

public class Preferences
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    public static final String SESSIONPREFS = "prefs";
    private static final Logger log = Logger.getLogger(Preferences.class);

    public static void setupPreferences(PageContext pageContext) {
        Preferences.reloadPreferences(pageContext);
    }

    public static void reloadPreferences(PageContext pageContext) {
        Preferences prefs = new Preferences();
        Properties props = PropertyReader.loadWebAppProps((ServletContext)pageContext.getServletContext());
        Context ctx = Context.findContext((PageContext)pageContext);
        String dateFormat = ((InternationalizationManager)ctx.getEngine().getManager(InternationalizationManager.class)).get("CoreResources", Preferences.getLocale(ctx), "common.datetimeformat");
        prefs.put("SkinName", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.skinname", (String)"PlainVanilla"));
        prefs.put("DateFormat", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.dateformat", (String)dateFormat));
        prefs.put("TimeZone", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.timezone", (String)TimeZone.getDefault().getID()));
        prefs.put("Orientation", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.orientation", (String)"fav-left"));
        prefs.put("Sidebar", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.sidebar", (String)"active"));
        prefs.put("Layout", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.layout", (String)"fluid"));
        prefs.put("Language", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.language", (String)Preferences.getLocale(ctx).toString()));
        prefs.put("SectionEditing", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.sectionediting", (String)"true"));
        prefs.put("Appearance", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.appearance", (String)"true"));
        prefs.put("autosuggest", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.autosuggest", (String)"true"));
        prefs.put("tabcompletion", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.tabcompletion", (String)"true"));
        prefs.put("smartpairs", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.smartpairs", (String)"false"));
        prefs.put("livepreview", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.livepreview", (String)"true"));
        prefs.put("previewcolumn", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.previewcolumn", (String)"true"));
        prefs.put("editor", TextUtil.getStringProperty((Properties)props, (String)"jspwiki.defaultprefs.template.editor", (String)"plain"));
        Preferences.parseJSONPreferences((HttpServletRequest)pageContext.getRequest(), prefs);
        pageContext.getSession().setAttribute(SESSIONPREFS, (Object)prefs);
    }

    private static void parseJSONPreferences(HttpServletRequest request, Preferences prefs) {
        String prefVal = TextUtil.urlDecodeUTF8((String)HttpUtil.retrieveCookieValue((HttpServletRequest)request, (String)"JSPWikiUserPrefs"));
        if (prefVal != null) {
            Map map = (Map)new Gson().fromJson(prefVal, Map.class);
            for (String key : map.keySet()) {
                Object value = map.get(key = TextUtil.replaceEntities((String)key));
                if (value == null) continue;
                prefs.put(key, value.toString());
            }
        }
    }

    public static String getPreference(Context wikiContext, String name) {
        HttpServletRequest request = wikiContext.getHttpRequest();
        if (request == null) {
            return null;
        }
        Preferences prefs = (Preferences)request.getSession().getAttribute(SESSIONPREFS);
        if (prefs != null) {
            return (String)prefs.get(name);
        }
        return null;
    }

    public static String getPreference(PageContext pageContext, String name) {
        Preferences prefs = (Preferences)pageContext.getSession().getAttribute(SESSIONPREFS);
        if (prefs != null) {
            return (String)prefs.get(name);
        }
        return null;
    }

    public static Locale getLocale(Context context) {
        Locale loc = null;
        String langSetting = Preferences.getPreference(context, "Language");
        if (langSetting != null) {
            String language = "";
            String country = "";
            String variant = "";
            String[] res = StringUtils.split((String)langSetting, (String)"-_");
            if (res.length > 2) {
                variant = res[2];
            }
            if (res.length > 1) {
                country = res[1];
            }
            if (res.length > 0) {
                language = res[0];
                loc = new Locale(language, country, variant);
            }
        }
        if (loc == null) {
            String locale = context.getEngine().getWikiProperties().getProperty("jspwiki.preferences.default-locale");
            try {
                loc = LocaleUtils.toLocale((String)locale);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)iae.getMessage());
            }
        }
        if (loc == null) {
            HttpServletRequest request = context.getHttpRequest();
            loc = request != null ? request.getLocale() : Locale.getDefault();
        }
        log.debug((Object)("using locale " + loc.toString()));
        return loc;
    }

    public static ResourceBundle getBundle(Context context, String bundle) throws MissingResourceException {
        Locale loc = Preferences.getLocale(context);
        InternationalizationManager i18n = (InternationalizationManager)context.getEngine().getManager(InternationalizationManager.class);
        return i18n.getBundle(bundle, loc);
    }

    public static SimpleDateFormat getDateFormat(Context context, TimeFormat tf) {
        String prefDateFormat;
        InternationalizationManager imgr = (InternationalizationManager)context.getEngine().getManager(InternationalizationManager.class);
        Locale clientLocale = Preferences.getLocale(context);
        String prefTimeZone = Preferences.getPreference(context, "TimeZone");
        log.debug((Object)"Checking for preferences...");
        switch (tf) {
            case DATETIME: {
                prefDateFormat = Preferences.getPreference(context, "DateFormat");
                log.debug((Object)("Preferences fmt = " + prefDateFormat));
                if (prefDateFormat != null) break;
                prefDateFormat = imgr.get("CoreResources", clientLocale, "common.datetimeformat");
                log.debug((Object)("Using locale-format = " + prefDateFormat));
                break;
            }
            case TIME: {
                prefDateFormat = imgr.get("common.timeformat");
                break;
            }
            case DATE: {
                prefDateFormat = imgr.get("common.dateformat");
                break;
            }
            default: {
                throw new InternalWikiException("Got a TimeFormat for which we have no value!");
            }
        }
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(prefDateFormat, clientLocale);
            if (prefTimeZone != null) {
                TimeZone tz = TimeZone.getTimeZone(prefTimeZone);
                fmt.setTimeZone(tz);
            }
            return fmt;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String renderDate(Context context, Date date, TimeFormat tf) {
        SimpleDateFormat df = Preferences.getDateFormat(context, tf);
        return df.format(date);
    }

    public static enum TimeFormat {
        TIME,
        DATE,
        DATETIME;

    }
}

