/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TreeSet;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.providers.PageProvider;
import org.apache.wiki.api.search.QueryItem;
import org.apache.wiki.api.search.SearchResult;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;

public class CachingProvider
implements PageProvider {
    private static final Logger log = Logger.getLogger(CachingProvider.class);
    private CacheManager m_cacheManager = CacheManager.getInstance();
    private PageProvider m_provider;
    private Engine m_engine;
    private Cache m_cache;
    public static final String CACHE_NAME = "jspwiki.pageCache";
    private Cache m_textCache;
    public static final String TEXTCACHE_NAME = "jspwiki.pageTextCache";
    private Cache m_historyCache;
    public static final String HISTORYCACHE_NAME = "jspwiki.pageHistoryCache";
    private long m_cacheMisses = 0L;
    private long m_cacheHits = 0L;
    private long m_historyCacheMisses = 0L;
    private long m_historyCacheHits = 0L;
    private boolean m_gotall = false;
    public static final int DEFAULT_CACHECAPACITY = 1000;
    public static final int DEFAULT_CACHETIMETOLIVESECONDS = 86400;
    public static final int DEFAULT_CACHETIMETOIDLESECONDS = 86400;

    public void initialize(Engine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        String classname;
        log.debug((Object)"Initing CachingProvider");
        this.m_engine = engine;
        String cacheName = engine.getApplicationName() + "." + CACHE_NAME;
        if (this.m_cacheManager.cacheExists(cacheName)) {
            this.m_cache = this.m_cacheManager.getCache(cacheName);
        } else {
            log.info((Object)("cache with name " + cacheName + " not found in ehcache.xml, creating it with defaults."));
            this.m_cache = new Cache(cacheName, 1000, false, false, 86400L, 86400L);
            this.m_cacheManager.addCache(this.m_cache);
        }
        String textCacheName = engine.getApplicationName() + "." + TEXTCACHE_NAME;
        if (this.m_cacheManager.cacheExists(textCacheName)) {
            this.m_textCache = this.m_cacheManager.getCache(textCacheName);
        } else {
            log.info((Object)("cache with name " + textCacheName + " not found in ehcache.xml, creating it with defaults."));
            this.m_textCache = new Cache(textCacheName, 1000, false, false, 86400L, 86400L);
            this.m_cacheManager.addCache(this.m_textCache);
        }
        String historyCacheName = engine.getApplicationName() + "." + HISTORYCACHE_NAME;
        if (this.m_cacheManager.cacheExists(historyCacheName)) {
            this.m_historyCache = this.m_cacheManager.getCache(historyCacheName);
        } else {
            log.info((Object)("cache with name " + historyCacheName + " not found in ehcache.xml, creating it with defaults."));
            this.m_historyCache = new Cache(historyCacheName, 1000, false, false, 86400L, 86400L);
            this.m_cacheManager.addCache(this.m_historyCache);
        }
        try {
            classname = TextUtil.getRequiredProperty((Properties)properties, (String)"jspwiki.pageProvider");
        }
        catch (NoSuchElementException e) {
            throw new NoRequiredPropertyException(e.getMessage(), "jspwiki.pageProvider");
        }
        try {
            Class providerclass = ClassUtil.findClass((String)"org.apache.wiki.providers", (String)classname);
            this.m_provider = (PageProvider)providerclass.newInstance();
            log.debug((Object)("Initializing real provider class " + this.m_provider));
            this.m_provider.initialize(engine, properties);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to locate provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("no provider class", e);
        }
        catch (InstantiationException e) {
            log.error((Object)("Unable to create provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("faulty provider class", e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal access to provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("illegal provider class", e);
        }
    }

    private Page getPageInfoFromCache(String name) throws ProviderException {
        if (name == null) {
            return null;
        }
        Element cacheElement = this.m_cache.get((Serializable)((Object)name));
        if (cacheElement == null) {
            Page refreshed = this.m_provider.getPageInfo(name, -1);
            if (refreshed != null) {
                this.m_cache.put(new Element((Object)name, (Object)refreshed));
                return refreshed;
            }
            return null;
        }
        return (Page)cacheElement.getObjectValue();
    }

    public boolean pageExists(String pageName, int version) {
        Page p;
        if (pageName == null) {
            return false;
        }
        try {
            p = this.getPageInfoFromCache(pageName);
        }
        catch (ProviderException e) {
            log.info((Object)("Provider failed while trying to check if page exists: " + pageName));
            return false;
        }
        if (p != null) {
            int latestVersion = p.getVersion();
            if (version == latestVersion || version == -1) {
                return true;
            }
            return this.m_provider.pageExists(pageName, version);
        }
        try {
            return this.getPageInfo(pageName, version) != null;
        }
        catch (ProviderException providerException) {
            return false;
        }
    }

    public boolean pageExists(String pageName) {
        Page p;
        if (pageName == null) {
            return false;
        }
        try {
            p = this.getPageInfoFromCache(pageName);
        }
        catch (ProviderException e) {
            log.info((Object)("Provider failed while trying to check if page exists: " + pageName));
            return false;
        }
        if (p != null) {
            return true;
        }
        if (this.m_gotall) {
            return false;
        }
        return this.m_provider.pageExists(pageName);
    }

    public String getPageText(String pageName, int version) throws ProviderException {
        Page p;
        if (pageName == null) {
            return null;
        }
        String result = version == -1 ? this.getTextFromCache(pageName) : ((p = this.getPageInfoFromCache(pageName)) != null && p.getVersion() == version ? this.getTextFromCache(pageName) : this.m_provider.getPageText(pageName, version));
        return result;
    }

    private String getTextFromCache(String pageName) throws ProviderException {
        if (pageName == null) {
            return null;
        }
        Element cacheElement = this.m_textCache.get((Serializable)((Object)pageName));
        if (cacheElement != null) {
            ++this.m_cacheHits;
            return (String)cacheElement.getObjectValue();
        }
        if (this.pageExists(pageName)) {
            String text = this.m_provider.getPageText(pageName, -1);
            this.m_textCache.put(new Element((Serializable)((Object)pageName), (Serializable)((Object)text)));
            ++this.m_cacheMisses;
            return text;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPageText(Page page, String text) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            this.m_provider.putPageText(page, text);
            page.setLastModified(new Date());
            this.m_cache.remove((Serializable)((Object)page.getName()));
            this.m_textCache.remove((Serializable)((Object)page.getName()));
            this.m_historyCache.remove((Serializable)((Object)page.getName()));
            this.getPageInfoFromCache(page.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Page> getAllPages() throws ProviderException {
        TreeSet<Page> all;
        if (!this.m_gotall) {
            all = this.m_provider.getAllPages();
            CachingProvider cachingProvider = this;
            synchronized (cachingProvider) {
                for (Page p : all) {
                    this.m_cache.put(new Element((Object)p.getName(), (Object)p));
                }
                this.m_gotall = true;
            }
        } else {
            List keys = this.m_cache.getKeysWithExpiryCheck();
            all = new TreeSet<Page>();
            for (String key : keys) {
                Element element = this.m_cache.get((Serializable)((Object)key));
                Page cachedPage = (Page)element.getObjectValue();
                if (cachedPage == null) continue;
                all.add(cachedPage);
            }
        }
        if ((long)all.size() >= this.m_cache.getCacheConfiguration().getMaxEntriesLocalHeap()) {
            log.warn((Object)("seems " + this.m_cache.getName() + " can't hold all pages from your page repository, so we're delegating on the underlying provider instead. Please consider increasing your cache sizes on ehcache.xml to avoid this behaviour"));
            return this.m_provider.getAllPages();
        }
        return all;
    }

    public Collection<Page> getAllChangedSince(Date date) {
        return this.m_provider.getAllChangedSince(date);
    }

    public int getPageCount() throws ProviderException {
        return this.m_provider.getPageCount();
    }

    public Collection<SearchResult> findPages(QueryItem[] query) {
        return this.m_provider.findPages(query);
    }

    private void refreshMetadata(Page page) {
        if (page != null && !page.hasMetadata()) {
            RenderingManager mgr = (RenderingManager)this.m_engine.getManager(RenderingManager.class);
            try {
                String data = this.m_provider.getPageText(page.getName(), page.getVersion());
                Context ctx = Wiki.context().create(this.m_engine, page);
                MarkupParser parser = mgr.getParser(ctx, data);
                parser.parse();
            }
            catch (Exception ex) {
                log.debug((Object)("Failed to retrieve variables for wikipage " + page));
            }
        }
    }

    public Page getPageInfo(String pageName, int version) throws ProviderException {
        Page page;
        int latestcached;
        Page cached = this.getPageInfoFromCache(pageName);
        int n = latestcached = cached != null ? cached.getVersion() : Integer.MIN_VALUE;
        if (version == -1 || version == latestcached) {
            if (cached == null) {
                Page data = this.m_provider.getPageInfo(pageName, version);
                if (data != null) {
                    this.m_cache.put(new Element((Object)pageName, (Object)data));
                }
                page = data;
            } else {
                page = cached;
            }
        } else {
            page = this.m_provider.getPageInfo(pageName, version);
        }
        this.refreshMetadata(page);
        return page;
    }

    public List<Page> getVersionHistory(String pageName) throws ProviderException {
        List history;
        if (pageName == null) {
            return null;
        }
        Element element = this.m_historyCache.get((Serializable)((Object)pageName));
        if (element != null) {
            ++this.m_historyCacheHits;
            history = (List)element.getObjectValue();
        } else {
            history = this.m_provider.getVersionHistory(pageName);
            this.m_historyCache.put(new Element((Object)pageName, (Object)history));
            ++this.m_historyCacheMisses;
        }
        return history;
    }

    public synchronized String getProviderInfo() {
        return "Real provider: " + this.m_provider.getClass().getName() + ". Cache misses: " + this.m_cacheMisses + ". Cache hits: " + this.m_cacheHits + ". History cache hits: " + this.m_historyCacheHits + ". History cache misses: " + this.m_historyCacheMisses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVersion(String pageName, int version) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            int latestcached;
            Page cached = this.getPageInfoFromCache(pageName);
            int n = latestcached = cached != null ? cached.getVersion() : Integer.MIN_VALUE;
            if (version == -1 || version == latestcached) {
                this.m_cache.remove((Serializable)((Object)pageName));
                this.m_textCache.remove((Serializable)((Object)pageName));
            }
            this.m_provider.deleteVersion(pageName, version);
            this.m_historyCache.remove((Serializable)((Object)pageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePage(String pageName) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            this.m_cache.put(new Element((Serializable)((Object)pageName), null));
            this.m_textCache.put(new Element((Serializable)((Object)pageName), null));
            this.m_historyCache.put(new Element((Serializable)((Object)pageName), null));
            this.m_provider.deletePage(pageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePage(String from, String to) throws ProviderException {
        this.m_provider.movePage(from, to);
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            this.m_cache.remove((Serializable)((Object)from));
            this.m_textCache.remove((Serializable)((Object)from));
            this.m_historyCache.remove((Serializable)((Object)from));
            log.debug((Object)("Removing to page " + to + " from cache"));
            this.m_cache.remove((Serializable)((Object)to));
            this.m_textCache.remove((Serializable)((Object)to));
            this.m_historyCache.remove((Serializable)((Object)to));
        }
    }

    public PageProvider getRealProvider() {
        return this.m_provider;
    }
}

