/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;
import org.apache.wiki.StringTransmutator;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.FilterException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.parser.JSPWikiMarkupParser;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.render.WikiRenderer;
import org.apache.wiki.render.WysiwygEditingRenderer;
import org.apache.wiki.render.XHTMLRenderer;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.variables.VariableManager;

public class DefaultRenderingManager
implements RenderingManager {
    private static final Logger log = Logger.getLogger(DefaultRenderingManager.class);
    private static final int DEFAULT_CACHESIZE = 1000;
    private static final String VERSION_DELIMITER = "::";
    private static final String DEFAULT_PARSER = JSPWikiMarkupParser.class.getName();
    private static final String DEFAULT_RENDERER = XHTMLRenderer.class.getName();
    private static final String DEFAULT_WYSIWYG_RENDERER = WysiwygEditingRenderer.class.getName();
    private Engine m_engine;
    private boolean m_useCache = true;
    private final CacheManager m_cacheManager = CacheManager.getInstance();
    private final int m_cacheExpiryPeriod = 86400;
    private boolean m_beautifyTitle = false;
    private Cache m_documentCache;
    private Constructor<?> m_rendererConstructor;
    private Constructor<?> m_rendererWysiwygConstructor;
    private String m_markupParserClass = DEFAULT_PARSER;

    public void initialize(Engine engine, Properties properties) throws WikiException {
        this.m_engine = engine;
        this.m_markupParserClass = properties.getProperty("jspwiki.renderingManager.markupParser", DEFAULT_PARSER);
        if (!ClassUtil.assignable((String)this.m_markupParserClass, (String)MarkupParser.class.getName())) {
            log.warn((Object)(this.m_markupParserClass + " does not subclass " + MarkupParser.class.getName() + " reverting to default markup parser."));
            this.m_markupParserClass = DEFAULT_PARSER;
        }
        log.info((Object)("Using " + this.m_markupParserClass + " as markup parser."));
        this.m_beautifyTitle = TextUtil.getBooleanProperty((Properties)properties, (String)"jspwiki.breakTitleWithSpaces", (boolean)this.m_beautifyTitle);
        this.m_useCache = "true".equals(properties.getProperty("jspwiki.usePageCache"));
        if (this.m_useCache) {
            String documentCacheName = engine.getApplicationName() + "." + "jspwiki.renderingCache";
            if (this.m_cacheManager.cacheExists(documentCacheName)) {
                this.m_documentCache = this.m_cacheManager.getCache(documentCacheName);
            } else {
                log.info((Object)("cache with name " + documentCacheName + " not found in ehcache.xml, creating it with defaults."));
                this.m_documentCache = new Cache(documentCacheName, 1000, false, false, 86400L, 86400L);
                this.m_cacheManager.addCache(this.m_documentCache);
            }
        }
        String renderImplName = properties.getProperty("jspwiki.renderingManager.renderer", DEFAULT_RENDERER);
        String renderWysiwygImplName = properties.getProperty("jspwiki.renderingManager.renderer.wysiwyg", DEFAULT_WYSIWYG_RENDERER);
        Class[] rendererParams = new Class[]{Context.class, WikiDocument.class};
        this.m_rendererConstructor = this.initRenderer(renderImplName, rendererParams);
        this.m_rendererWysiwygConstructor = this.initRenderer(renderWysiwygImplName, rendererParams);
        log.info((Object)("Rendering content with " + renderImplName + "."));
        WikiEventManager.getInstance();
        WikiEventManager.addWikiEventListener((Object)this.m_engine.getManager(FilterManager.class), (WikiEventListener)this);
    }

    private Constructor<?> initRenderer(String renderImplName, Class<?>[] rendererParams) throws WikiException {
        Constructor<?> c = null;
        try {
            Class<?> clazz = Class.forName(renderImplName);
            c = clazz.getConstructor(rendererParams);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to find WikiRenderer implementation " + renderImplName));
        }
        catch (SecurityException e) {
            log.error((Object)("Unable to access the WikiRenderer(WikiContext,WikiDocument) constructor for " + renderImplName));
        }
        catch (NoSuchMethodException e) {
            log.error((Object)("Unable to locate the WikiRenderer(WikiContext,WikiDocument) constructor for " + renderImplName));
        }
        if (c == null) {
            throw new WikiException("Failed to get WikiRenderer '" + renderImplName + "'.");
        }
        return c;
    }

    @Override
    public String beautifyTitle(String title) {
        if (this.m_beautifyTitle) {
            try {
                Attachment att = ((AttachmentManager)this.m_engine.getManager(AttachmentManager.class)).getAttachmentInfo(title);
                if (att == null) {
                    return TextUtil.beautifyString((String)title);
                }
                String parent = TextUtil.beautifyString((String)att.getParentName());
                return parent + "/" + att.getFileName();
            }
            catch (ProviderException e) {
                return title;
            }
        }
        return title;
    }

    @Override
    public String beautifyTitleNoBreak(String title) {
        if (this.m_beautifyTitle) {
            return TextUtil.beautifyString((String)title, (String)"&nbsp;");
        }
        return title;
    }

    @Override
    public MarkupParser getParser(Context context, String pagedata) {
        try {
            return (MarkupParser)ClassUtil.getMappedObject((String)this.m_markupParserClass, (Object[])new Object[]{context, new StringReader(pagedata)});
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            log.error((Object)("unable to get an instance of " + this.m_markupParserClass + " (" + e.getMessage() + "), returning default markup parser."), (Throwable)e);
            return new JSPWikiMarkupParser(context, new StringReader(pagedata));
        }
    }

    @Override
    public WikiDocument getRenderedDocument(Context context, String pagedata) {
        WikiDocument doc;
        String pageid = context.getRealPage().getName() + VERSION_DELIMITER + context.getRealPage().getVersion() + VERSION_DELIMITER + context.getVariable("_PluginContent.execute");
        if (this.useCache(context)) {
            Element element = this.m_documentCache.get((Serializable)((Object)pageid));
            if (element != null) {
                doc = (WikiDocument)((Object)element.getObjectValue());
                if (pagedata.equals(doc.getPageData())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using cached HTML for page " + pageid));
                    }
                    return doc;
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Re-rendering and storing " + pageid));
            }
        }
        try {
            MarkupParser parser = this.getParser(context, pagedata);
            doc = parser.parse();
            doc.setPageData(pagedata);
            if (this.useCache(context)) {
                this.m_documentCache.put(new Element((Serializable)((Object)pageid), (Serializable)((Object)doc)));
            }
            return doc;
        }
        catch (IOException ex) {
            log.error((Object)"Unable to parse", (Throwable)ex);
            return null;
        }
    }

    boolean useCache(Context context) {
        return this.m_useCache && ContextEnum.PAGE_VIEW.getRequestContext().equals(context.getRequestContext());
    }

    @Override
    public String getHTML(Context context, WikiDocument doc) throws IOException {
        Boolean wysiwygVariable = (Boolean)context.getVariable("WYSIWYG_EDITOR_MODE");
        boolean wysiwygEditorMode = wysiwygVariable != null ? wysiwygVariable : false;
        WikiRenderer rend = wysiwygEditorMode ? this.getWysiwygRenderer(context, doc) : this.getRenderer(context, doc);
        return rend.getString();
    }

    @Override
    public String getHTML(Context context, Page page) {
        String pagedata = ((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(page.getName(), page.getVersion());
        return this.textToHTML(context, pagedata);
    }

    @Override
    public String getHTML(String pagename, int version) {
        Page page = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pagename, version);
        Context context = Wiki.context().create(this.m_engine, page);
        context.setRequestContext(ContextEnum.PAGE_NONE.getRequestContext());
        return this.getHTML(context, page);
    }

    public String textToHTML(Context context, String pagedata) {
        String result = "";
        boolean runFilters = "true".equals(((VariableManager)this.m_engine.getManager(VariableManager.class)).getValue(context, "jspwiki.runFilters", "true"));
        StopWatch sw = new StopWatch();
        sw.start();
        try {
            if (runFilters) {
                pagedata = ((FilterManager)this.m_engine.getManager(FilterManager.class)).doPreTranslateFiltering(context, pagedata);
            }
            result = this.getHTML(context, pagedata);
            if (runFilters) {
                result = ((FilterManager)this.m_engine.getManager(FilterManager.class)).doPostTranslateFiltering(context, result);
            }
        }
        catch (FilterException e) {
            log.error((Object)"page filter threw exception: ", (Throwable)e);
        }
        sw.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Page " + context.getRealPage().getName() + " rendered, took " + sw));
        }
        return result;
    }

    @Override
    public String textToHTML(Context context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook, StringTransmutator attLinkHook, boolean parseAccessRules, boolean justParse) {
        String result = "";
        if (pagedata == null) {
            log.error((Object)"NULL pagedata to textToHTML()");
            return null;
        }
        boolean runFilters = "true".equals(((VariableManager)this.m_engine.getManager(VariableManager.class)).getValue(context, "jspwiki.runFilters", "true"));
        try {
            StopWatch sw = new StopWatch();
            sw.start();
            if (runFilters && this.m_engine.getManager(FilterManager.class) != null) {
                pagedata = ((FilterManager)this.m_engine.getManager(FilterManager.class)).doPreTranslateFiltering(context, pagedata);
            }
            MarkupParser mp = this.getParser(context, pagedata);
            mp.addLocalLinkHook(localLinkHook);
            mp.addExternalLinkHook(extLinkHook);
            mp.addAttachmentLinkHook(attLinkHook);
            if (!parseAccessRules) {
                mp.disableAccessRules();
            }
            WikiDocument doc = mp.parse();
            if (!justParse) {
                result = this.getHTML(context, doc);
                if (runFilters && this.m_engine.getManager(FilterManager.class) != null) {
                    result = ((FilterManager)this.m_engine.getManager(FilterManager.class)).doPostTranslateFiltering(context, result);
                }
            }
            sw.stop();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Page " + context.getRealPage().getName() + " rendered, took " + sw));
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to scan page data: ", (Throwable)e);
        }
        catch (FilterException e) {
            log.error((Object)"page filter threw exception: ", (Throwable)e);
        }
        return result;
    }

    @Override
    public WikiRenderer getRenderer(Context context, WikiDocument doc) {
        Object[] params = new Object[]{context, doc};
        return this.getRenderer(params, this.m_rendererConstructor);
    }

    @Override
    public WikiRenderer getWysiwygRenderer(Context context, WikiDocument doc) {
        Object[] params = new Object[]{context, doc};
        return this.getRenderer(params, this.m_rendererWysiwygConstructor);
    }

    private <T extends WikiRenderer> T getRenderer(Object[] params, Constructor<?> rendererConstructor) {
        try {
            return (T)((WikiRenderer)rendererConstructor.newInstance(params));
        }
        catch (Exception e) {
            log.error((Object)"Unable to create WikiRenderer", (Throwable)e);
            return null;
        }
    }

    public void actionPerformed(WikiEvent event) {
        log.debug((Object)("event received: " + event.toString()));
        if (this.m_useCache && event instanceof WikiPageEvent && event.getType() == 21 && this.m_documentCache != null) {
            String pageName = ((WikiPageEvent)event).getPageName();
            this.m_documentCache.remove((Serializable)((Object)pageName));
            Set<String> referringPages = ((ReferenceManager)this.m_engine.getManager(ReferenceManager.class)).findReferrers(pageName);
            if (referringPages != null) {
                for (String page : referringPages) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Flushing latest version of " + page));
                    }
                    this.m_documentCache.remove((Serializable)((Object)(page + VERSION_DELIMITER + -1 + VERSION_DELIMITER + Boolean.FALSE)));
                    this.m_documentCache.remove((Serializable)((Object)(page + VERSION_DELIMITER + -1 + VERSION_DELIMITER + Boolean.TRUE)));
                    this.m_documentCache.remove((Serializable)((Object)(page + VERSION_DELIMITER + -1 + VERSION_DELIMITER + null)));
                }
            }
        }
    }
}

