/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.util.TextUtil;

public class AuthorTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    public String m_format = "";

    public void setFormat(String format) {
        this.m_format = format;
    }

    @Override
    public final int doWikiStartTag() throws IOException {
        Engine engine = this.m_wikiContext.getEngine();
        Page page = this.m_wikiContext.getPage();
        String author = page.getAuthor();
        if (author != null && author.length() > 0) {
            author = TextUtil.replaceEntities((String)author);
            if (((PageManager)engine.getManager(PageManager.class)).wikiPageExists(author) && !"plain".equalsIgnoreCase(this.m_format)) {
                RenderingManager mgr = (RenderingManager)engine.getManager(RenderingManager.class);
                MarkupParser p = mgr.getParser(this.m_wikiContext, "[" + author + "|" + author + "]");
                WikiDocument d = p.parse();
                author = mgr.getHTML(this.m_wikiContext, d);
            }
            this.pageContext.getOut().print(author);
        } else {
            this.pageContext.getOut().print(Preferences.getBundle(this.m_wikiContext, "CoreResources").getString("common.unknownauthor"));
        }
        return 0;
    }
}

