/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tasks.pages;

import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Task;

public class SaveWikiPageTask
extends Task {
    private static final long serialVersionUID = 3190559953484411420L;
    final Context context;

    public SaveWikiPageTask(Context context) {
        super("task.saveWikiPage");
        this.context = context;
    }

    @Override
    public Outcome execute() throws WikiException {
        String proposedText = (String)((Object)this.getWorkflowContext().get("fact.proposedText"));
        Engine engine = this.context.getEngine();
        Page page = this.context.getPage();
        ((PageManager)engine.getManager(PageManager.class)).putPageText(page, proposedText);
        ((PageManager)engine.getManager(PageManager.class)).getPage(page.getName());
        ((RenderingManager)engine.getManager(RenderingManager.class)).textToHTML(this.context, proposedText);
        ((FilterManager)engine.getManager(FilterManager.class)).doPostSaveFiltering(this.context, proposedText);
        return Outcome.STEP_COMPLETE;
    }
}

