/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.plugin.AbstractReferralPlugin;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.util.TextUtil;

public class ReferringUndefinedPagesPlugin
extends AbstractReferralPlugin {
    public static final String PARAM_MAX = "max";
    public static final String PARAM_EXTRAS = "extras";

    public String execute(Context context, Map<String, String> params) throws PluginException {
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        ReferenceManager referenceManager = (ReferenceManager)context.getEngine().getManager(ReferenceManager.class);
        int items = TextUtil.parseIntParameter((String)params.get(PARAM_MAX), (int)-1);
        String extras = params.get(PARAM_EXTRAS);
        if (extras == null) {
            extras = rb.getString("referringundefinedpagesplugin.more");
        }
        Collection<String> uncreatedPages = referenceManager.findUncreated();
        super.initialize(context, params);
        Collection<String> result = null;
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        if (uncreatedPages != null) {
            for (String uncreatedPageName : uncreatedPages) {
                Set<String> referrers = referenceManager.findReferrers(uncreatedPageName);
                if (referrers == null) continue;
                for (String referringPage : referrers) {
                    sortedMap.put(referringPage, "");
                }
            }
            result = sortedMap.keySet();
        }
        result = super.filterAndSortCollection(result);
        String wikitext = this.wikitizeCollection(result, this.m_separator, items);
        StringBuilder resultHTML = new StringBuilder();
        resultHTML.append(this.makeHTML(context, wikitext));
        if (items < result.size() && items > 0) {
            Object[] args = new Object[]{"" + (result.size() - items)};
            extras = MessageFormat.format(extras, args);
            resultHTML.append("<br/>" + extras + "<br/>");
        }
        return resultHTML.toString();
    }
}

