/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.ParserStagePlugin;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.api.plugin.PluginElement;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.TextUtil;

public class WeblogPlugin
implements Plugin,
ParserStagePlugin {
    private static final Logger log = Logger.getLogger(WeblogPlugin.class);
    private static final Pattern HEADINGPATTERN = Pattern.compile("(<h[1-4][^>]*>)(.*)(</h[1-4]>)", 2);
    private static final int DEFAULT_DAYS = 7;
    private static final String DEFAULT_PAGEFORMAT = "%p_blogentry_";
    public static final String DEFAULT_DATEFORMAT = "ddMMyy";
    public static final String PARAM_STARTDATE = "startDate";
    public static final String PARAM_ENTRYFORMAT = "entryFormat";
    public static final String PARAM_DAYS = "days";
    public static final String PARAM_ALLOWCOMMENTS = "allowComments";
    public static final String PARAM_MAXENTRIES = "maxEntries";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_PREVIEW = "preview";
    public static final String ATTR_ISWEBLOG = "weblogplugin.isweblog";

    public static String makeEntryPage(String pageName, String date, String entryNum) {
        return TextUtil.replaceString((String)DEFAULT_PAGEFORMAT, (String)"%p", (String)pageName) + date + "_" + entryNum;
    }

    public static String makeEntryPage(String pageName) {
        return TextUtil.replaceString((String)DEFAULT_PAGEFORMAT, (String)"%p", (String)pageName);
    }

    public static String makeEntryPage(String pageName, String date) {
        return TextUtil.replaceString((String)DEFAULT_PAGEFORMAT, (String)"%p", (String)pageName) + date;
    }

    public String execute(Context context, Map<String, String> params) throws PluginException {
        String startDay;
        String days;
        int numDays = 7;
        Engine engine = context.getEngine();
        AuthorizationManager mgr = (AuthorizationManager)engine.getManager(AuthorizationManager.class);
        boolean hasComments = false;
        String weblogName = params.get(PARAM_PAGE);
        if (weblogName == null) {
            weblogName = context.getPage().getName();
        }
        if ((days = context.getHttpParameter("weblog.days")) == null) {
            days = params.get(PARAM_DAYS);
        }
        SimpleDateFormat entryFormat = params.get(PARAM_ENTRYFORMAT) == null ? Preferences.getDateFormat(context, Preferences.TimeFormat.DATETIME) : new SimpleDateFormat(params.get(PARAM_ENTRYFORMAT));
        if (days != null) {
            numDays = days.equalsIgnoreCase("all") ? Integer.MAX_VALUE : TextUtil.parseIntParameter((String)days, (int)7);
        }
        if ((startDay = params.get(PARAM_STARTDATE)) == null) {
            startDay = context.getHttpParameter("weblog.startDate");
        }
        if (TextUtil.isPositive((String)params.get(PARAM_ALLOWCOMMENTS))) {
            hasComments = true;
        }
        int maxEntries = TextUtil.parseIntParameter((String)params.get(PARAM_MAXENTRIES), (int)Integer.MAX_VALUE);
        Calendar startTime = Calendar.getInstance();
        Calendar stopTime = Calendar.getInstance();
        if (startDay != null) {
            SimpleDateFormat fmt = new SimpleDateFormat(DEFAULT_DATEFORMAT);
            try {
                Date d = fmt.parse(startDay);
                startTime.setTime(d);
                stopTime.setTime(d);
            }
            catch (ParseException e) {
                return "Illegal time format: " + startDay;
            }
        }
        context.getPage().setAttribute(ATTR_ISWEBLOG, (Object)"true");
        startTime.add(5, -numDays);
        startTime.set(10, 0);
        startTime.set(12, 0);
        startTime.set(13, 0);
        stopTime.set(10, 23);
        stopTime.set(12, 59);
        stopTime.set(13, 59);
        StringBuilder sb = new StringBuilder();
        List<Page> blogEntries = this.findBlogEntries(engine, weblogName, startTime.getTime(), stopTime.getTime());
        blogEntries.sort(new PageDateComparator());
        sb.append("<div class=\"weblog\">\n");
        Iterator<Page> i = blogEntries.iterator();
        while (i.hasNext() && maxEntries-- > 0) {
            Page p = i.next();
            if (!mgr.checkPermission(context.getWikiSession(), new PagePermission(p, "view"))) continue;
            this.addEntryHTML(context, entryFormat, hasComments, sb, p, params);
        }
        sb.append("</div>\n");
        return sb.toString();
    }

    private void addEntryHTML(Context context, DateFormat entryFormat, boolean hasComments, StringBuilder buffer, Page entry, Map<String, String> params) {
        Engine engine = context.getEngine();
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        buffer.append("<div class=\"weblogentry\">\n");
        buffer.append("<div class=\"weblogentryheading\">\n");
        Date entryDate = entry.getLastModified();
        buffer.append(entryFormat != null ? entryFormat.format(entryDate) : entryDate);
        buffer.append("</div>\n");
        Context entryCtx = context.clone();
        entryCtx.setPage(entry);
        String html = ((RenderingManager)engine.getManager(RenderingManager.class)).getHTML(entryCtx, ((PageManager)engine.getManager(PageManager.class)).getPage(entry.getName()));
        buffer.append("<div class=\"weblogentrytitle\">\n");
        Matcher matcher = HEADINGPATTERN.matcher(html);
        if (matcher.find()) {
            String title = matcher.group(2);
            html = matcher.replaceFirst("");
            buffer.append(title);
        } else {
            buffer.append(entry.getName());
        }
        buffer.append("</div>\n");
        buffer.append("<div class=\"weblogentrybody\">\n");
        int preview = TextUtil.parseIntParameter((String)params.get(PARAM_PREVIEW), (int)0);
        if (preview > 0) {
            int cutoff;
            boolean hasBeenCutOff = false;
            for (cutoff = Math.min(preview, html.length()); cutoff < html.length(); ++cutoff) {
                if (html.charAt(cutoff) != '\r' && html.charAt(cutoff) != '\n') continue;
                hasBeenCutOff = true;
                break;
            }
            buffer.append(html.substring(0, cutoff));
            if (hasBeenCutOff) {
                buffer.append(" <a href=\"" + entryCtx.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), entry.getName()) + "\">" + rb.getString("weblogentryplugin.more") + "</a>\n");
            }
        } else {
            buffer.append(html);
        }
        buffer.append("</div>\n");
        buffer.append("<div class=\"weblogentryfooter\">\n");
        String author = entry.getAuthor();
        if (author != null) {
            if (((PageManager)engine.getManager(PageManager.class)).wikiPageExists(author)) {
                author = "<a href=\"" + entryCtx.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), author) + "\">" + ((RenderingManager)engine.getManager(RenderingManager.class)).beautifyTitle(author) + "</a>";
            }
        } else {
            author = "AnonymousCoward";
        }
        buffer.append(MessageFormat.format(rb.getString("weblogentryplugin.postedby"), author));
        buffer.append("<a href=\"" + entryCtx.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), entry.getName()) + "\">" + rb.getString("weblogentryplugin.permalink") + "</a>");
        String commentPageName = TextUtil.replaceString((String)entry.getName(), (String)"blogentry", (String)"comments");
        if (hasComments) {
            int numComments = this.guessNumberOfComments(engine, commentPageName);
            buffer.append("&nbsp;&nbsp;");
            String addcomment = rb.getString("weblogentryplugin.addcomment");
            buffer.append("<a href=\"" + entryCtx.getURL(ContextEnum.PAGE_COMMENT.getRequestContext(), commentPageName, "nc=" + numComments) + "\">" + MessageFormat.format(addcomment, numComments) + "</a>");
        }
        buffer.append("</div>\n");
        buffer.append("</div>\n");
    }

    private int guessNumberOfComments(Engine engine, String commentpage) {
        String pagedata = ((PageManager)engine.getManager(PageManager.class)).getPureText(commentpage, -1);
        if (pagedata == null || pagedata.trim().length() == 0) {
            return 0;
        }
        return TextUtil.countSections((String)pagedata);
    }

    public List<Page> findBlogEntries(Engine engine, String baseName, Date start, Date end) {
        PageManager mgr = (PageManager)engine.getManager(PageManager.class);
        Set<String> allPages = ((ReferenceManager)engine.getManager(ReferenceManager.class)).findCreated();
        ArrayList<Page> result = new ArrayList<Page>();
        baseName = WeblogPlugin.makeEntryPage(baseName);
        for (String pageName : allPages) {
            if (!pageName.startsWith(baseName)) continue;
            try {
                Page firstVersion = mgr.getPageInfo(pageName, 1);
                Date d = firstVersion.getLastModified();
                if (!d.after(start) || !d.before(end)) continue;
                result.add(firstVersion);
            }
            catch (Exception e) {
                log.debug((Object)("Page name :" + pageName + " was suspected as a blog entry but it isn't because of parsing errors"), (Throwable)e);
            }
        }
        return result;
    }

    public void executeParser(PluginElement element, Context context, Map<String, String> params) {
        context.getPage().setAttribute(ATTR_ISWEBLOG, (Object)"true");
    }

    private static class PageDateComparator
    implements Comparator<Page> {
        private PageDateComparator() {
        }

        @Override
        public int compare(Page page1, Page page2) {
            if (page1 == null || page2 == null) {
                return 0;
            }
            return page2.getLastModified().compareTo(page1.getLastModified());
        }
    }
}

