/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.providers.AttachmentProvider;
import org.apache.wiki.api.search.QueryItem;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;

public class CachingAttachmentProvider
implements AttachmentProvider {
    private static final Logger log = Logger.getLogger(CachingAttachmentProvider.class);
    private AttachmentProvider m_provider;
    private CacheManager m_cacheManager = CacheManager.getInstance();
    public static final int m_capacity = 1000;
    private Cache m_cache;
    public static final String ATTCACHE_NAME = "jspwiki.attachmentsCache";
    public static final String ATTCOLLCACHE_NAME = "jspwiki.attachmentCollectionsCache";
    private Cache m_attCache;
    private long m_cacheMisses = 0L;
    private long m_cacheHits = 0L;
    public static final String DIR_EXTENSION = "-att";
    private boolean m_gotall = false;

    public void initialize(Engine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        String classname;
        log.info((Object)"Initing CachingAttachmentProvider");
        String attCollCacheName = engine.getApplicationName() + "." + ATTCOLLCACHE_NAME;
        if (this.m_cacheManager.cacheExists(attCollCacheName)) {
            this.m_cache = this.m_cacheManager.getCache(attCollCacheName);
        } else {
            this.m_cache = new Cache(attCollCacheName, 1000, false, false, 0L, 0L);
            this.m_cacheManager.addCache(this.m_cache);
        }
        String attCacheName = engine.getApplicationName() + "." + ATTCACHE_NAME;
        if (this.m_cacheManager.cacheExists(attCacheName)) {
            this.m_attCache = this.m_cacheManager.getCache(attCacheName);
        } else {
            this.m_attCache = new Cache(attCacheName, 1000, false, false, 0L, 0L);
            this.m_cacheManager.addCache(this.m_attCache);
        }
        try {
            classname = TextUtil.getRequiredProperty((Properties)properties, (String)"jspwiki.attachmentProvider");
        }
        catch (NoSuchElementException e) {
            throw new NoRequiredPropertyException(e.getMessage(), "jspwiki.attachmentProvider");
        }
        try {
            Class providerclass = ClassUtil.findClass((String)"org.apache.wiki.providers", (String)classname);
            this.m_provider = (AttachmentProvider)providerclass.newInstance();
            log.debug((Object)("Initializing real provider class " + this.m_provider));
            this.m_provider.initialize(engine, properties);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to locate provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("no provider class", e);
        }
        catch (InstantiationException e) {
            log.error((Object)("Unable to create provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("faulty provider class", e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal access to provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("illegal provider class", e);
        }
    }

    public void putAttachmentData(Attachment att, InputStream data) throws ProviderException, IOException {
        this.m_provider.putAttachmentData(att, data);
        this.m_cache.remove((Serializable)((Object)att.getParentName()));
        att.setLastModified(new Date());
        this.m_attCache.put(new Element((Object)att.getName(), (Object)att));
    }

    public InputStream getAttachmentData(Attachment att) throws ProviderException, IOException {
        return this.m_provider.getAttachmentData(att);
    }

    public List<Attachment> listAttachments(Page page) throws ProviderException {
        log.debug((Object)("Listing attachments for " + page));
        Element element = this.m_cache.get((Serializable)((Object)page.getName()));
        if (element != null) {
            List c = (List)element.getObjectValue();
            log.debug((Object)("LIST from cache, " + page.getName() + ", size=" + c.size()));
            return this.cloneCollection(c);
        }
        log.debug((Object)("list NOT in cache, " + page.getName()));
        return this.refresh(page);
    }

    private <T> List<T> cloneCollection(Collection<T> c) {
        return new ArrayList<T>(c);
    }

    public Collection<Attachment> findAttachments(QueryItem[] query) {
        return this.m_provider.findAttachments(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attachment> listAllChanged(Date timestamp) throws ProviderException {
        ArrayList<Attachment> all;
        if (!this.m_gotall) {
            all = this.m_provider.listAllChanged(timestamp);
            CachingAttachmentProvider cachingAttachmentProvider = this;
            synchronized (cachingAttachmentProvider) {
                for (Attachment att : all) {
                    this.m_attCache.put(new Element((Object)att.getName(), (Object)att));
                }
                this.m_gotall = true;
            }
        } else {
            List keys = this.m_attCache.getKeysWithExpiryCheck();
            all = new ArrayList<Attachment>();
            for (String key : keys) {
                Element element = this.m_attCache.get((Serializable)((Object)key));
                Attachment cachedAttachment = (Attachment)element.getObjectValue();
                if (cachedAttachment == null) continue;
                all.add(cachedAttachment);
            }
        }
        return all;
    }

    private Attachment findAttachmentFromCollection(Collection<Attachment> c, String name) {
        for (Attachment att : new ArrayList<Attachment>(c)) {
            if (!name.equals(att.getFileName())) continue;
            return att;
        }
        return null;
    }

    private List<Attachment> refresh(Page page) throws ProviderException {
        List c = this.m_provider.listAttachments(page);
        this.m_cache.put(new Element((Object)page.getName(), (Object)c));
        return c;
    }

    public Attachment getAttachmentInfo(Page page, String name, int version) throws ProviderException {
        Collection<Object> c;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting attachments for " + page + ", name=" + name + ", version=" + version));
        }
        if (version != -1) {
            log.debug((Object)"...we don't cache old versions");
            return this.m_provider.getAttachmentInfo(page, name, version);
        }
        Element element = this.m_cache.get((Serializable)((Object)page.getName()));
        if (element == null) {
            log.debug((Object)(page.getName() + " wasn't in the cache"));
            c = this.refresh(page);
            if (c == null) {
                return null;
            }
        } else {
            log.debug((Object)(page.getName() + " FOUND in the cache"));
            c = (Collection)element.getObjectValue();
        }
        return this.findAttachmentFromCollection(c, name);
    }

    public List<Attachment> getVersionHistory(Attachment att) {
        return this.m_provider.getVersionHistory(att);
    }

    public void deleteVersion(Attachment att) throws ProviderException {
        this.m_cache.remove((Serializable)((Object)att.getParentName()));
        this.m_provider.deleteVersion(att);
    }

    public void deleteAttachment(Attachment att) throws ProviderException {
        this.m_cache.remove((Serializable)((Object)att.getParentName()));
        this.m_attCache.remove((Serializable)((Object)att.getName()));
        this.m_provider.deleteAttachment(att);
    }

    public synchronized String getProviderInfo() {
        return "Real provider: " + this.m_provider.getClass().getName() + ".  Cache misses: " + this.m_cacheMisses + ".  Cache hits: " + this.m_cacheHits;
    }

    public AttachmentProvider getRealProvider() {
        return this.m_provider;
    }

    public void moveAttachmentsForPage(String oldParent, String newParent) throws ProviderException {
        this.m_provider.moveAttachmentsForPage(oldParent, newParent);
        this.m_cache.remove((Serializable)((Object)newParent));
        this.m_cache.remove((Serializable)((Object)oldParent));
        String checkName = oldParent + "/";
        List names = this.m_cache.getKeysWithExpiryCheck();
        for (String name : names) {
            if (!name.startsWith(checkName)) continue;
            this.m_attCache.remove((Serializable)((Object)name));
        }
    }
}

