/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.providers.AbstractFileProvider;
import org.apache.wiki.providers.NoSuchVersionException;
import org.apache.wiki.util.FileUtil;

public class VersioningFileProvider
extends AbstractFileProvider {
    private static final Logger log = Logger.getLogger(VersioningFileProvider.class);
    public static final String PAGEDIR = "OLD";
    public static final String PROPERTYFILE = "page.properties";
    private CachedProperties m_cachedProperties;

    @Override
    public void initialize(Engine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        super.initialize(engine, properties);
        File oldpages = new File(this.getPageDirectory(), PAGEDIR);
        if (!oldpages.exists()) {
            if (!oldpages.mkdirs()) {
                throw new IOException("Failed to create page version directory " + oldpages.getAbsolutePath());
            }
        } else {
            if (!oldpages.isDirectory()) {
                throw new IOException("Page version directory is not a directory: " + oldpages.getAbsolutePath());
            }
            if (!oldpages.canWrite()) {
                throw new IOException("Page version directory is not writable: " + oldpages.getAbsolutePath());
            }
        }
        log.info((Object)("Using directory " + oldpages.getAbsolutePath() + " for storing old versions of pages"));
    }

    private File findOldPageDir(String page) {
        if (page == null) {
            throw new InternalWikiException("Page may NOT be null in the provider!");
        }
        File oldpages = new File(this.getPageDirectory(), PAGEDIR);
        return new File(oldpages, this.mangleName(page));
    }

    private int findLatestVersion(String page) {
        int version = -1;
        try {
            Properties props = this.getPageProperties(page);
            for (Object o : props.keySet()) {
                int cutpoint;
                String key = (String)o;
                if (!key.endsWith(".author") || (cutpoint = key.indexOf(46)) <= 0) continue;
                String pageNum = key.substring(0, cutpoint);
                try {
                    int res = Integer.parseInt(pageNum);
                    if (res <= version) continue;
                    version = res;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (IOException e) {
            log.error((Object)"Unable to figure out latest version - dying...", (Throwable)e);
        }
        return version;
    }

    private Properties getPageProperties(String page) throws IOException {
        File propertyFile = new File(this.findOldPageDir(page), PROPERTYFILE);
        if (propertyFile.exists()) {
            long lastModified = propertyFile.lastModified();
            CachedProperties cp = this.m_cachedProperties;
            if (cp != null && cp.m_page.equals(page) && cp.m_lastModified == lastModified) {
                return cp.m_props;
            }
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(propertyFile));){
                Properties props = new Properties();
                props.load(in);
                this.m_cachedProperties = cp = new CachedProperties(page, props, lastModified);
                Properties properties = props;
                return properties;
            }
        }
        return new Properties();
    }

    private void putPageProperties(String page, Properties properties) throws IOException {
        CachedProperties cp;
        File propertyFile = new File(this.findOldPageDir(page), PROPERTYFILE);
        try (FileOutputStream out = new FileOutputStream(propertyFile);){
            properties.store(out, " JSPWiki page properties for " + page + ". DO NOT MODIFY!");
        }
        this.m_cachedProperties = cp = new CachedProperties(page, properties, propertyFile.lastModified());
    }

    private int realVersion(String page, int requestedVersion) throws NoSuchVersionException {
        if (requestedVersion == -1) {
            return -1;
        }
        int latest = this.findLatestVersion(page);
        if (requestedVersion == latest || requestedVersion == 1 && latest == -1) {
            return -1;
        }
        if (requestedVersion <= 0 || requestedVersion > latest) {
            throw new NoSuchVersionException("Requested version " + requestedVersion + ", but latest is " + latest);
        }
        return requestedVersion;
    }

    @Override
    public synchronized String getPageText(String page, int version) throws ProviderException {
        File dir = this.findOldPageDir(page);
        if ((version = this.realVersion(page, version)) == -1) {
            return super.getPageText(page, -1);
        }
        File pageFile = new File(dir, "" + version + ".txt");
        if (!pageFile.exists()) {
            throw new NoSuchVersionException("Version " + version + "does not exist.");
        }
        return this.readFile(pageFile);
    }

    private String readFile(File pagedata) throws ProviderException {
        String result;
        block16: {
            result = null;
            if (pagedata.exists()) {
                if (pagedata.canRead()) {
                    try (FileInputStream in = new FileInputStream(pagedata);){
                        result = FileUtil.readContents((InputStream)in, (String)this.m_encoding);
                        break block16;
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed to read", (Throwable)e);
                        throw new ProviderException("I/O error: " + e.getMessage());
                    }
                }
                log.warn((Object)("Failed to read page from '" + pagedata.getAbsolutePath() + "', possibly a permissions problem"));
                throw new ProviderException("I cannot read the requested page.");
            }
            log.info((Object)"New page");
        }
        return result;
    }

    @Override
    public synchronized void putPageText(Page page, String text) throws ProviderException {
        int latest = this.findLatestVersion(page.getName());
        File pageDir = this.findOldPageDir(page.getName());
        if (!pageDir.exists()) {
            pageDir.mkdirs();
        }
        try {
            String newAuthor;
            boolean firstUpdate;
            File oldFile = this.findPage(page.getName());
            int versionNumber = latest > 0 ? latest : 1;
            boolean bl = firstUpdate = versionNumber == 1;
            if (oldFile != null && oldFile.exists()) {
                File pageFile = new File(pageDir, versionNumber + ".txt");
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(oldFile));
                     BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pageFile));){
                    FileUtil.copyContents((InputStream)in, (OutputStream)out);
                    pageFile.setLastModified(oldFile.lastModified());
                    ++versionNumber;
                }
            }
            super.putPageText(page, text);
            Properties props = this.getPageProperties(page.getName());
            String authorFirst = null;
            File pagePropFile = new File(this.getPageDirectory() + File.separator + PAGEDIR + File.separator + this.mangleName(page.getName()) + File.separator + "page" + ".properties");
            if (firstUpdate && !pagePropFile.exists()) {
                Properties props2 = this.getHeritagePageProperties(page.getName());
                authorFirst = props2.getProperty("1.author", "unknown");
                props.setProperty("1.author", authorFirst);
            }
            if ((newAuthor = page.getAuthor()) == null) {
                newAuthor = authorFirst != null ? authorFirst : "unknown";
            }
            page.setAuthor(newAuthor);
            props.setProperty(versionNumber + ".author", newAuthor);
            String changeNote = (String)page.getAttribute("changenote");
            if (changeNote != null) {
                props.setProperty(versionNumber + ".changenote", changeNote);
            }
            this.getCustomProperties(page, props);
            this.putPageProperties(page.getName(), props);
        }
        catch (IOException e) {
            log.error((Object)"Saving failed", (Throwable)e);
            throw new ProviderException("Could not save page text: " + e.getMessage());
        }
    }

    @Override
    public Page getPageInfo(String page, int version) throws ProviderException {
        int realVersion;
        int latest = this.findLatestVersion(page);
        Page p = null;
        if (version == -1 || version == latest || version == 1 && latest == -1) {
            realVersion = latest >= 0 ? latest : 1;
            p = super.getPageInfo(page, -1);
            if (p != null) {
                p.setVersion(realVersion);
            }
        } else {
            realVersion = version;
            File dir = this.findOldPageDir(page);
            if (!dir.exists() || !dir.isDirectory()) {
                return null;
            }
            File file = new File(dir, version + ".txt");
            if (file.exists()) {
                p = Wiki.contents().page(this.m_engine, page);
                p.setLastModified(new Date(file.lastModified()));
                p.setVersion(version);
            }
        }
        if (p != null) {
            try {
                String changenote;
                Properties props = this.getPageProperties(page);
                String author = props.getProperty(realVersion + ".author");
                if (author == null) {
                    Properties props2 = this.getHeritagePageProperties(page);
                    author = props2.getProperty("author");
                }
                if (author != null) {
                    p.setAuthor(author);
                }
                if ((changenote = props.getProperty(realVersion + ".changenote")) != null) {
                    p.setAttribute("changenote", (Object)changenote);
                }
                this.setCustomProperties(p, props);
            }
            catch (IOException e) {
                log.error((Object)("Cannot get author for page" + page + ": "), (Throwable)e);
            }
        }
        return p;
    }

    @Override
    public boolean pageExists(String pageName, int version) {
        if (version == -1 || version == this.findLatestVersion(pageName)) {
            return this.pageExists(pageName);
        }
        File dir = this.findOldPageDir(pageName);
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        return new File(dir, version + ".txt").exists();
    }

    @Override
    public List<Page> getVersionHistory(String page) throws ProviderException {
        int latest;
        ArrayList<Page> list = new ArrayList<Page>();
        for (int i = latest = this.findLatestVersion(page); i > 0; --i) {
            Page info = this.getPageInfo(page, i);
            if (info == null) continue;
            list.add(info);
        }
        return list;
    }

    private Properties getHeritagePageProperties(String page) throws IOException {
        File propertyFile = new File(this.getPageDirectory(), this.mangleName(page) + ".properties");
        if (propertyFile.exists()) {
            long lastModified = propertyFile.lastModified();
            CachedProperties cp = this.m_cachedProperties;
            if (cp != null && cp.m_page.equals(page) && cp.m_lastModified == lastModified) {
                return cp.m_props;
            }
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(propertyFile));){
                Properties props = new Properties();
                props.load(in);
                String originalAuthor = props.getProperty("author");
                if (originalAuthor.length() > 0) {
                    props.setProperty("1.author", originalAuthor);
                    this.m_cachedProperties = cp = new CachedProperties(page, props, propertyFile.lastModified());
                }
                Properties properties = props;
                return properties;
            }
        }
        return new Properties();
    }

    @Override
    public void deletePage(String page) throws ProviderException {
        super.deletePage(page);
        File dir = this.findOldPageDir(page);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles(new AbstractFileProvider.WikiFileFilter());
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
            File propfile = new File(dir, PROPERTYFILE);
            if (propfile.exists()) {
                propfile.delete();
            }
            dir.delete();
        }
    }

    @Override
    public void deleteVersion(String page, int version) throws ProviderException {
        File dir = this.findOldPageDir(page);
        int latest = this.findLatestVersion(page);
        if (version == -1 || version == latest || version == 1 && latest == -1) {
            try {
                Properties props = this.getPageProperties(page);
                props.remove((latest > 0 ? latest : 1) + ".author");
                this.putPageProperties(page, props);
            }
            catch (IOException e) {
                log.error((Object)"Unable to modify page properties", (Throwable)e);
                throw new ProviderException("Could not modify page properties: " + e.getMessage());
            }
            super.deleteVersion(page, -1);
            latest = this.findLatestVersion(page);
            File pageDir = this.findOldPageDir(page);
            File previousFile = new File(pageDir, latest + ".txt");
            File pageFile = this.findPage(page);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(previousFile));
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pageFile));){
                if (previousFile.exists()) {
                    FileUtil.copyContents((InputStream)in, (OutputStream)out);
                    pageFile.setLastModified(previousFile.lastModified());
                }
            }
            catch (IOException e) {
                log.fatal((Object)"Something wrong with the page directory - you may have just lost data!", (Throwable)e);
            }
            return;
        }
        File pageFile = new File(dir, "" + version + ".txt");
        if (pageFile.exists()) {
            if (!pageFile.delete()) {
                log.error((Object)("Unable to delete page." + pageFile.getPath()));
            }
        } else {
            throw new NoSuchVersionException("Page " + page + ", version=" + version);
        }
    }

    @Override
    public Collection<Page> getAllPages() throws ProviderException {
        Collection<Page> pages = super.getAllPages();
        ArrayList<Page> returnedPages = new ArrayList<Page>();
        for (Page page : pages) {
            Page info = this.getPageInfo(page.getName(), -1);
            returnedPages.add(info);
        }
        return returnedPages;
    }

    @Override
    public String getProviderInfo() {
        return "";
    }

    public void movePage(String from, String to) {
        File fromFile = this.findPage(from);
        File toFile = this.findPage(to);
        fromFile.renameTo(toFile);
        File fromOldDir = this.findOldPageDir(from);
        File toOldDir = this.findOldPageDir(to);
        fromOldDir.renameTo(toOldDir);
    }

    private static class CachedProperties {
        String m_page;
        Properties m_props;
        long m_lastModified;

        public CachedProperties(String pageName, Properties props, long lastModified) {
            if (pageName == null) {
                throw new NullPointerException("pageName must not be null!");
            }
            this.m_page = pageName;
            if (props == null) {
                throw new NullPointerException("properties must not be null!");
            }
            this.m_props = props;
            this.m_lastModified = lastModified;
        }
    }
}

