/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.wiki.StringTransmutator;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.engine.Initializable;
import org.apache.wiki.api.engine.RenderApi;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.modules.InternalModule;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.render.WikiRenderer;

public interface RenderingManager
extends RenderApi,
WikiEventListener,
InternalModule,
Initializable {
    public static final String PROP_PARSER = "jspwiki.renderingManager.markupParser";
    public static final String PROP_RENDERER = "jspwiki.renderingManager.renderer";
    public static final String PROP_WYSIWYG_RENDERER = "jspwiki.renderingManager.renderer.wysiwyg";
    public static final String PROP_BEAUTIFYTITLE = "jspwiki.breakTitleWithSpaces";
    public static final String DOCUMENTCACHE_NAME = "jspwiki.renderingCache";

    public String beautifyTitle(String var1);

    public String beautifyTitleNoBreak(String var1);

    public MarkupParser getParser(Context var1, String var2);

    public WikiDocument getRenderedDocument(Context var1, String var2);

    public WikiRenderer getRenderer(Context var1, WikiDocument var2);

    public WikiRenderer getWysiwygRenderer(Context var1, WikiDocument var2);

    public String getHTML(Context var1, WikiDocument var2) throws IOException;

    public String getHTML(Context var1, Page var2);

    public String getHTML(String var1, int var2);

    default public String getHTML(Context context, String pagedata) {
        try {
            WikiDocument doc = this.getRenderedDocument(context, pagedata);
            return this.getHTML(context, doc);
        }
        catch (IOException e) {
            Logger.getLogger(RenderingManager.class).error((Object)"Unable to parse", (Throwable)e);
            return null;
        }
    }

    default public String getHTML(String page) {
        return this.getHTML(page, -1);
    }

    public String textToHTML(Context var1, String var2, StringTransmutator var3, StringTransmutator var4, StringTransmutator var5, boolean var6, boolean var7);

    default public String textToHTML(Context context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook) {
        return this.textToHTML(context, pagedata, localLinkHook, extLinkHook, null, true, false);
    }

    default public String textToHTML(Context context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook, StringTransmutator attLinkHook) {
        return this.textToHTML(context, pagedata, localLinkHook, extLinkHook, attLinkHook, true, false);
    }
}

