/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Command;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.search.SearchResult;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.tags.IteratorTag;
import org.apache.wiki.ui.PageCommand;

public class SearchResultIteratorTag
extends IteratorTag {
    private static final long serialVersionUID = 0L;
    private int m_maxItems;
    private int m_count = 0;
    private int m_start = 0;
    private static final Logger log = Logger.getLogger(SearchResultIteratorTag.class);

    public void release() {
        super.release();
        this.m_count = 0;
        this.m_maxItems = 0;
    }

    public void setMaxItems(int arg) {
        this.m_maxItems = arg;
    }

    public void setStart(int arg) {
        this.m_start = arg;
    }

    @Override
    public final int doStartTag() {
        if (this.m_iterator == null) {
            Collection searchresults = (Collection)this.pageContext.getAttribute("searchresults", 2);
            this.setList(searchresults);
            int skip = 0;
            this.m_iterator = searchresults.iterator();
            while (this.m_iterator.hasNext() && skip++ < this.m_start) {
                this.m_iterator.next();
            }
        }
        this.m_count = 0;
        this.m_wikiContext = (Context)this.pageContext.getAttribute("jspwiki.context", 2);
        return this.nextResult();
    }

    private int nextResult() {
        if (this.m_iterator != null && this.m_iterator.hasNext() && this.m_count++ < this.m_maxItems) {
            SearchResult r = (SearchResult)this.m_iterator.next();
            Engine engine = this.m_wikiContext.getEngine();
            HttpServletRequest request = this.m_wikiContext.getHttpRequest();
            Command command = PageCommand.VIEW.targetedCommand((Object)r.getPage());
            Context context = Wiki.context().create(engine, request, command);
            this.pageContext.setAttribute("jspwiki.context", (Object)context, 2);
            this.pageContext.setAttribute(this.getId(), (Object)r);
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        if (this.bodyContent != null) {
            try {
                JspWriter out = this.getPreviousOut();
                out.print(this.bodyContent.getString());
                this.bodyContent.clearBody();
            }
            catch (IOException e) {
                log.error((Object)"Unable to get inner tag text", (Throwable)e);
            }
        }
        return this.nextResult();
    }

    @Override
    public int doEndTag() {
        this.m_iterator = null;
        return super.doEndTag();
    }
}

