/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.preferences.Preferences;

public final class InputValidator {
    public static final int STANDARD = 0;
    public static final int EMAIL = 1;
    public static final int ID = 2;
    protected static final Pattern ID_PATTERN = Pattern.compile("[\\x00\\r\\n\\x0f\"'<>;&\\xff{}]");
    protected static final Pattern EMAIL_PATTERN = Pattern.compile("^[0-9a-zA-Z-_\\.\\+]+@([0-9a-zA-Z-_]+\\.)+[a-zA-Z]+$");
    protected static final Pattern UNSAFE_PATTERN = Pattern.compile("[\\x00\\r\\n\\x0f\"':<>\\[\\];#&@\\xff{}\\$%\\\\]");
    private final String m_form;
    private final Session m_session;
    private final Context m_context;

    public InputValidator(String form, Context context) {
        this.m_form = form;
        this.m_context = context;
        this.m_session = context.getWikiSession();
    }

    public boolean validateNotNull(String input, String label) {
        return this.validateNotNull(input, label, 0);
    }

    public boolean validateNotNull(String input, String label, int type) {
        if (InputValidator.isBlank(input)) {
            ResourceBundle rb = Preferences.getBundle(this.m_context, "CoreResources");
            this.m_session.addMessage(this.m_form, MessageFormat.format(rb.getString("validate.cantbenull"), label));
            return false;
        }
        return this.validate(input, label, type) && !InputValidator.isBlank(input);
    }

    public boolean validate(String input, String label, int type) {
        if (InputValidator.isBlank(input)) {
            return true;
        }
        ResourceBundle rb = Preferences.getBundle(this.m_context, "CoreResources");
        switch (type) {
            case 0: {
                boolean valid;
                Matcher matcher = UNSAFE_PATTERN.matcher(input);
                boolean bl = valid = !matcher.find();
                if (!valid) {
                    Object[] args = new Object[]{label, "'\"<>;&[]#\\@{}%$"};
                    this.m_session.addMessage(this.m_form, MessageFormat.format(rb.getString("validate.unsafechars"), args));
                }
                return valid;
            }
            case 1: {
                Matcher matcher = EMAIL_PATTERN.matcher(input);
                boolean valid = matcher.matches();
                if (!valid) {
                    Object[] args = new Object[]{label};
                    this.m_session.addMessage(this.m_form, MessageFormat.format(rb.getString("validate.invalidemail"), args));
                }
                return valid;
            }
            case 2: {
                boolean valid;
                Matcher matcher = ID_PATTERN.matcher(input);
                boolean bl = valid = !matcher.find();
                if (!valid) {
                    Object[] args = new Object[]{label, "'\"<>;&{}"};
                    this.m_session.addMessage(this.m_form, MessageFormat.format(rb.getString("validate.unsafechars"), args));
                }
                return valid;
            }
        }
        throw new IllegalArgumentException("Invalid input type.");
    }

    public static boolean isBlank(String input) {
        return input == null || input.trim().length() < 1;
    }
}

