/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.event.WikiEventEmitter;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.Outcome;

public class DecisionQueue
implements Serializable {
    private static final long serialVersionUID = -7172912793410302533L;
    private final LinkedList<Decision> m_queue = new LinkedList();
    private final AtomicInteger next = new AtomicInteger(1000);

    protected synchronized void add(Decision decision) {
        this.m_queue.addLast(decision);
        decision.setId(this.next.getAndIncrement());
    }

    protected Decision[] decisions() {
        return this.m_queue.toArray(new Decision[this.m_queue.size()]);
    }

    protected synchronized void remove(Decision decision) {
        this.m_queue.remove(decision);
    }

    public Collection<Decision> getActorDecisions(Session session) {
        ArrayList<Decision> decisions = new ArrayList<Decision>();
        if (session.isAuthenticated()) {
            Principal[] principals = session.getPrincipals();
            Principal[] rolePrincipals = session.getRoles();
            for (Decision decision : this.m_queue) {
                for (Principal principal : principals) {
                    if (!principal.equals(decision.getActor())) continue;
                    decisions.add(decision);
                }
                for (Principal principal : rolePrincipals) {
                    if (!principal.equals(decision.getActor())) continue;
                    decisions.add(decision);
                }
            }
        }
        return decisions;
    }

    public void decide(Decision decision, Outcome outcome, Context context) throws WikiException {
        decision.decide(outcome, context);
        if (decision.isCompleted()) {
            this.remove(decision);
        }
        WikiEventEmitter.fireWorkflowEvent((Object)decision, (int)80);
    }

    public synchronized void reassign(Decision decision, Principal owner) throws WikiException {
        if (decision.isReassignable()) {
            decision.reassign(owner);
            WikiEventEmitter.fireWorkflowEvent((Object)decision, (int)90);
            return;
        }
        throw new IllegalStateException("Reassignments not allowed for this decision.");
    }
}

