/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.acl.UnresolvedPrincipal;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventEmitter;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WorkflowEvent;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.DecisionQueue;
import org.apache.wiki.workflow.Workflow;
import org.apache.wiki.workflow.WorkflowManager;

public class DefaultWorkflowManager
implements WorkflowManager {
    private static final Logger LOG = Logger.getLogger(DefaultWorkflowManager.class);
    static final String SERIALIZATION_FILE = "wkflmgr.ser";
    private static final long serialVersionUID = 6L;
    DecisionQueue m_queue;
    Set<Workflow> m_workflows = ConcurrentHashMap.newKeySet();
    final Map<String, Principal> m_approvers = new ConcurrentHashMap<String, Principal>();
    Queue<Workflow> m_completed;
    private Engine m_engine = null;
    private int retainCompleted;

    public DefaultWorkflowManager() {
        this.m_queue = new DecisionQueue();
        WikiEventEmitter.attach((WikiEventListener)this);
    }

    @Override
    public Set<Workflow> getWorkflows() {
        ConcurrentHashMap.KeySetView workflows = ConcurrentHashMap.newKeySet();
        workflows.addAll(this.m_workflows);
        return workflows;
    }

    @Override
    public List<Workflow> getCompletedWorkflows() {
        return new CopyOnWriteArrayList<Workflow>(this.m_completed);
    }

    public void initialize(Engine engine, Properties props) {
        this.m_engine = engine;
        this.retainCompleted = TextUtil.getIntegerProperty((Properties)engine.getWikiProperties(), (String)"jspwiki.workflow.completed.retain", (int)2048);
        this.m_completed = new CircularFifoQueue(this.retainCompleted);
        for (Object o : props.keySet()) {
            String approver;
            String key;
            String prop = (String)o;
            if (!prop.startsWith("jspwiki.approver.") || (key = prop.substring("jspwiki.approver.".length())).length() <= 0 || (approver = props.getProperty(prop)) == null || approver.length() <= 0) continue;
            this.m_approvers.put(key, new UnresolvedPrincipal(approver));
        }
        this.unserializeFromDisk(new File(this.m_engine.getWorkDir(), SERIALIZATION_FILE));
    }

    synchronized long unserializeFromDisk(File f) {
        long saved = 0L;
        StopWatch sw = new StopWatch();
        sw.start();
        try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));){
            long ver = in.readLong();
            if (ver != 6L) {
                LOG.warn((Object)"File format has changed; Unable to recover workflows and decision queue from disk.");
            } else {
                saved = in.readLong();
                this.m_workflows = (Set)in.readObject();
                this.m_queue = (DecisionQueue)in.readObject();
                this.m_completed = new CircularFifoQueue(this.retainCompleted);
                this.m_completed.addAll((Collection)in.readObject());
                LOG.debug((Object)("Read serialized data successfully in " + sw));
            }
        }
        catch (IOException | ClassNotFoundException e) {
            LOG.warn((Object)("unable to recover from disk workflows and decision queue: " + e.getMessage()));
        }
        sw.stop();
        return saved;
    }

    synchronized void serializeToDisk(File f) {
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
            StopWatch sw = new StopWatch();
            sw.start();
            out.writeLong(6L);
            out.writeLong(System.currentTimeMillis());
            out.writeObject(this.m_workflows);
            out.writeObject(this.m_queue);
            out.writeObject(this.m_completed);
            sw.stop();
            LOG.debug((Object)("serialization done - took " + sw));
        }
        catch (IOException ioe) {
            LOG.error((Object)"Unable to serialize!", (Throwable)ioe);
        }
    }

    @Override
    public boolean requiresApproval(String messageKey) {
        return this.m_approvers.containsKey(messageKey);
    }

    @Override
    public Principal getApprover(String messageKey) throws WikiException {
        Principal approver = this.m_approvers.get(messageKey);
        if (approver == null) {
            throw new WikiException("Workflow '" + messageKey + "' does not require approval.");
        }
        if (approver instanceof UnresolvedPrincipal) {
            String name = approver.getName();
            approver = ((AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class)).resolvePrincipal(name);
            if (approver instanceof UnresolvedPrincipal) {
                throw new WikiException("Workflow approver '" + name + "' cannot not be resolved.");
            }
            this.m_approvers.put(messageKey, approver);
        }
        return approver;
    }

    protected Engine getEngine() {
        if (this.m_engine == null) {
            throw new IllegalStateException("Engine cannot be null; please initialize WorkflowManager first.");
        }
        return this.m_engine;
    }

    @Override
    public DecisionQueue getDecisionQueue() {
        return this.m_queue;
    }

    @Override
    public List<Workflow> getOwnerWorkflows(Session session) {
        ArrayList<Workflow> workflows = new ArrayList<Workflow>();
        if (session.isAuthenticated()) {
            Principal[] sessionPrincipals = session.getPrincipals();
            block0: for (Workflow w : this.m_workflows) {
                Principal owner = w.getOwner();
                for (Principal sessionPrincipal : sessionPrincipals) {
                    if (!sessionPrincipal.equals(owner)) continue;
                    workflows.add(w);
                    continue block0;
                }
            }
        }
        return workflows;
    }

    public void actionPerformed(WikiEvent event) {
        if (event instanceof WorkflowEvent) {
            if (event.getSrc() instanceof Workflow) {
                Workflow workflow = (Workflow)event.getSrc();
                switch (event.getType()) {
                    case 40: 
                    case 50: {
                        this.remove(workflow);
                        break;
                    }
                    case 0: {
                        this.add(workflow);
                        break;
                    }
                }
            } else if (event.getSrc() instanceof Decision) {
                Decision decision = (Decision)event.getSrc();
                switch (event.getType()) {
                    case 60: {
                        this.addToDecisionQueue(decision);
                        break;
                    }
                    case 70: {
                        this.removeFromDecisionQueue(decision, (Context)event.getArg(0, Context.class));
                        break;
                    }
                }
            }
            this.serializeToDisk(new File(this.m_engine.getWorkDir(), SERIALIZATION_FILE));
        }
    }

    protected void add(Workflow workflow) {
        this.m_workflows.add(workflow);
    }

    protected void remove(Workflow workflow) {
        if (this.m_workflows.contains(workflow)) {
            this.m_workflows.remove(workflow);
            this.m_completed.add(workflow);
        }
    }

    protected void removeFromDecisionQueue(Decision decision, Context context) {
        Workflow w2;
        int workflowId = decision.getWorkflowId();
        Optional<Workflow> optw = this.m_workflows.stream().filter(w -> w.getId() == workflowId).findAny();
        if (optw.isPresent() && (w2 = optw.get()).getCurrentState() == 30 && decision.equals(w2.getCurrentStep())) {
            this.getDecisionQueue().remove(decision);
            try {
                w2.restart(context);
            }
            catch (WikiException e) {
                LOG.error((Object)("restarting workflow #" + w2.getId() + " caused " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void addToDecisionQueue(Decision decision) {
        this.getDecisionQueue().add(decision);
    }
}

