/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import org.apache.wiki.workflow.AbstractStep;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Step;
import org.apache.wiki.workflow.SystemPrincipal;

public abstract class Task
extends AbstractStep {
    private static final long serialVersionUID = 4630293957752430807L;
    private Step m_successor = null;

    public Task(String messageKey) {
        super(messageKey);
        super.addSuccessor(Outcome.STEP_COMPLETE, null);
        super.addSuccessor(Outcome.STEP_ABORT, null);
    }

    public Task(int workflowId, Map<String, Serializable> workflowContext, String messageKey) {
        this(messageKey);
        this.setWorkflow(workflowId, workflowContext);
    }

    @Override
    public final Principal getActor() {
        return SystemPrincipal.SYSTEM_USER;
    }

    public final synchronized void setSuccessor(Step step) {
        this.m_successor = step;
    }

    public final synchronized Step getSuccessor() {
        return this.m_successor;
    }
}

