/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.workflow;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.event.WikiEventEmitter;
import org.apache.wiki.workflow.Decision;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Step;

public class Workflow
implements Serializable {
    private static final long serialVersionUID = 5228149040690660032L;
    private static final AtomicInteger idsCounter = new AtomicInteger(1);
    public static final int ID_NOT_SET = 0;
    public static final int COMPLETED = 50;
    public static final int ABORTED = 40;
    public static final int WAITING = 30;
    public static final int RUNNING = -1;
    public static final int CREATED = -2;
    private Map<String, Serializable> m_attributes = new ConcurrentHashMap<String, Serializable>();
    private Step m_firstStep;
    private boolean m_started;
    private final LinkedList<Step> m_history = new LinkedList();
    private int m_id = idsCounter.getAndIncrement();
    private final String m_key;
    private final Principal m_owner;
    private final List<Serializable> m_messageArgs;
    private int m_state;
    private Step m_currentStep = null;

    public Workflow(String messageKey, Principal owner) {
        this.m_key = messageKey;
        this.m_messageArgs = new ArrayList<Serializable>();
        this.m_owner = owner;
        this.m_started = false;
        this.m_state = -2;
        WikiEventEmitter.fireWorkflowEvent((Object)this, (int)0);
    }

    public final synchronized void abort(Context context) {
        if (this.m_state == 40) {
            throw new IllegalStateException("The workflow has already been aborted.");
        }
        if (this.m_state == 50) {
            throw new IllegalStateException("The workflow has already completed.");
        }
        if (this.m_currentStep != null) {
            if (this.m_currentStep instanceof Decision) {
                WikiEventEmitter.fireWorkflowEvent((Object)this.m_currentStep, (int)70, (Object[])new Object[]{context});
            }
            this.m_currentStep.setOutcome(Outcome.STEP_ABORT);
            this.m_history.addLast(this.m_currentStep);
        }
        this.m_state = 40;
        WikiEventEmitter.fireWorkflowEvent((Object)this, (int)50);
        this.cleanup();
    }

    public final void addMessageArgument(Serializable obj) {
        if (obj instanceof String || obj instanceof Date || obj instanceof Number) {
            this.m_messageArgs.add(obj);
            return;
        }
        throw new IllegalArgumentException("Message arguments must be of type String, Date or Number.");
    }

    public final synchronized Principal getCurrentActor() {
        if (this.m_currentStep == null) {
            return null;
        }
        return this.m_currentStep.getActor();
    }

    public final int getCurrentState() {
        return this.m_state;
    }

    public final Step getCurrentStep() {
        return this.m_currentStep;
    }

    public final Object getAttribute(String attr) {
        return this.m_attributes.get(attr);
    }

    public final Map<String, Serializable> getAttributes() {
        return this.m_attributes;
    }

    public final Date getEndTime() {
        Step last;
        if (this.isCompleted() && (last = this.m_history.getLast()) != null) {
            return last.getEndTime();
        }
        return Step.TIME_NOT_SET;
    }

    public final synchronized int getId() {
        return this.m_id;
    }

    public final Serializable[] getMessageArguments() {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.m_owner.getName());
        Principal actor = this.getCurrentActor();
        args.add(actor == null ? "-" : actor.getName());
        args.addAll(this.m_messageArgs);
        return args.toArray(new Serializable[args.size()]);
    }

    public final String getMessageKey() {
        return this.m_key;
    }

    public final Principal getOwner() {
        return this.m_owner;
    }

    public final Date getStartTime() {
        return this.isStarted() ? this.m_firstStep.getStartTime() : Step.TIME_NOT_SET;
    }

    public final List<Step> getHistory() {
        return Collections.unmodifiableList(this.m_history);
    }

    public final boolean isAborted() {
        return this.m_state == 40;
    }

    public final synchronized boolean isCompleted() {
        return this.m_started && this.m_state == 50;
    }

    public final boolean isStarted() {
        return this.m_started;
    }

    public final Step getPreviousStep() {
        return this.previousStep(this.m_currentStep);
    }

    public final synchronized void restart(Context context) throws WikiException {
        if (this.m_state != 30) {
            throw new IllegalStateException("Workflow is not paused; cannot restart.");
        }
        WikiEventEmitter.fireWorkflowEvent((Object)this, (int)10);
        this.m_state = -1;
        WikiEventEmitter.fireWorkflowEvent((Object)this, (int)20);
        try {
            this.processCurrentStep(context);
        }
        catch (WikiException e) {
            this.abort(context);
            throw e;
        }
    }

    public final void setAttribute(String attr, Serializable obj) {
        this.m_attributes.put(attr, obj);
    }

    public final synchronized void setFirstStep(Step step) {
        this.m_firstStep = step;
    }

    public final synchronized void setId(int id) {
        this.m_id = id;
    }

    public final synchronized void start(Context context) throws WikiException {
        if (this.m_state == 40) {
            throw new IllegalStateException("Workflow cannot be started; it has already been aborted.");
        }
        if (this.m_started) {
            throw new IllegalStateException("Workflow has already started.");
        }
        WikiEventEmitter.fireWorkflowEvent((Object)this, (int)10);
        this.m_started = true;
        this.m_state = -1;
        WikiEventEmitter.fireWorkflowEvent((Object)this, (int)20);
        this.m_currentStep = this.m_firstStep;
        this.m_history.add(this.m_currentStep);
        try {
            this.processCurrentStep(context);
        }
        catch (WikiException e) {
            this.abort(context);
            throw e;
        }
    }

    public final synchronized void waitstate() {
        if (this.m_state != -1) {
            throw new IllegalStateException("Workflow is not running; cannot pause.");
        }
        this.m_state = 30;
        WikiEventEmitter.fireWorkflowEvent((Object)this, (int)30);
    }

    protected void cleanup() {
        this.m_currentStep = null;
        this.m_attributes = null;
    }

    protected final synchronized void complete() {
        if (!this.isCompleted()) {
            this.m_state = 50;
            WikiEventEmitter.fireWorkflowEvent((Object)this, (int)40);
            this.cleanup();
        }
    }

    protected final Step previousStep(Step step) {
        int index = this.m_history.indexOf(step);
        return index < 1 ? null : this.m_history.get(index - 1);
    }

    protected final void processCurrentStep(Context context) throws WikiException {
        while (this.m_currentStep != null) {
            Outcome outcome;
            Outcome result;
            if (!this.m_currentStep.isStarted()) {
                this.m_currentStep.start();
            }
            if (Outcome.STEP_ABORT.equals(result = this.m_currentStep.execute(context))) {
                this.abort(context);
                break;
            }
            if (!this.m_currentStep.isCompleted()) {
                this.m_currentStep.setOutcome(result);
            }
            if (!(outcome = this.m_currentStep.getOutcome()).isCompletion()) {
                this.waitstate();
                break;
            }
            Step nextStep = this.m_currentStep.getSuccessor(outcome);
            if (nextStep == null) {
                this.complete();
                break;
            }
            this.m_history.add(nextStep);
            this.m_currentStep = nextStep;
        }
    }
}

