/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.security.Permission;
import java.security.Principal;
import java.util.HashMap;
import java.util.Properties;
import java.util.PropertyPermission;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.core.Command;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.ui.CommandResolver;
import org.apache.wiki.ui.PageCommand;
import org.apache.wiki.ui.WikiCommand;
import org.apache.wiki.util.TextUtil;

public class WikiContext
implements Context,
Command {
    private Command m_command;
    private WikiPage m_page;
    private WikiPage m_realPage;
    private Engine m_engine;
    private String m_template = "default";
    private HashMap<String, Object> m_variableMap = new HashMap();
    protected HttpServletRequest m_request;
    private Session m_session;
    public static final String ADMIN = ContextEnum.WIKI_ADMIN.getRequestContext();
    public static final String ATTACH = ContextEnum.PAGE_ATTACH.getRequestContext();
    public static final String COMMENT = ContextEnum.PAGE_COMMENT.getRequestContext();
    public static final String CONFLICT = ContextEnum.PAGE_CONFLICT.getRequestContext();
    public static final String CREATE_GROUP = ContextEnum.WIKI_CREATE_GROUP.getRequestContext();
    public static final String DELETE = ContextEnum.PAGE_DELETE.getRequestContext();
    public static final String DELETE_GROUP = ContextEnum.GROUP_DELETE.getRequestContext();
    public static final String DIFF = ContextEnum.PAGE_DIFF.getRequestContext();
    public static final String EDIT = ContextEnum.PAGE_EDIT.getRequestContext();
    public static final String EDIT_GROUP = ContextEnum.GROUP_EDIT.getRequestContext();
    public static final String ERROR = ContextEnum.WIKI_ERROR.getRequestContext();
    public static final String FIND = ContextEnum.WIKI_FIND.getRequestContext();
    public static final String INFO = ContextEnum.PAGE_INFO.getRequestContext();
    public static final String INSTALL = ContextEnum.WIKI_INSTALL.getRequestContext();
    public static final String LOGIN = ContextEnum.WIKI_LOGIN.getRequestContext();
    public static final String LOGOUT = ContextEnum.WIKI_LOGOUT.getRequestContext();
    public static final String MESSAGE = ContextEnum.WIKI_MESSAGE.getRequestContext();
    public static final String NONE = ContextEnum.PAGE_NONE.getRequestContext();
    public static final String OTHER = ContextEnum.PAGE_NONE.getRequestContext();
    public static final String PREFS = ContextEnum.WIKI_PREFS.getRequestContext();
    public static final String PREVIEW = ContextEnum.PAGE_PREVIEW.getRequestContext();
    public static final String RENAME = ContextEnum.PAGE_RENAME.getRequestContext();
    public static final String RSS = ContextEnum.PAGE_RSS.getRequestContext();
    public static final String UPLOAD = ContextEnum.PAGE_UPLOAD.getRequestContext();
    public static final String VIEW = ContextEnum.PAGE_VIEW.getRequestContext();
    public static final String VIEW_GROUP = ContextEnum.GROUP_VIEW.getRequestContext();
    public static final String WORKFLOW = ContextEnum.WIKI_WORKFLOW.getRequestContext();
    private static final Logger log = LogManager.getLogger(WikiContext.class);
    private static final Permission DUMMY_PERMISSION = new PropertyPermission("os.name", "read");

    public WikiContext(Engine engine, Page page) {
        this(engine, null, WikiContext.findCommand(engine, null, page));
    }

    public WikiContext(Engine engine, HttpServletRequest request, Command command) throws IllegalArgumentException {
        if (engine == null || command == null) {
            throw new IllegalArgumentException("Parameter engine and command must not be null.");
        }
        this.m_engine = engine;
        this.m_request = request;
        this.m_session = Wiki.session().find(engine, request);
        this.m_command = command;
        if (command instanceof PageCommand) {
            this.m_page = (WikiPage)command.getTarget();
        }
        if (this.m_page == null) {
            this.m_page = (WikiPage)((PageManager)this.m_engine.getManager(PageManager.class)).getPage(this.m_engine.getFrontPage());
            if (this.m_page == null) {
                this.m_page = (WikiPage)Wiki.contents().page(this.m_engine, this.m_engine.getFrontPage());
            }
        }
        this.m_realPage = this.m_page;
        if (PageCommand.VIEW.equals(command) && command.getTarget() == null) {
            this.m_command = command.targetedCommand((Object)this.m_page);
        }
        HttpSession session = request == null ? null : request.getSession(false);
        String sid = session == null ? "(null)" : session.getId();
        log.debug("Creating WikiContext for session ID={}; target={}", (Object)sid, (Object)this.getName());
        this.setDefaultTemplate(request);
    }

    public WikiContext(Engine engine, HttpServletRequest request, Page page) {
        this(engine, request, WikiContext.findCommand(engine, request, page));
    }

    public WikiContext(Engine engine, HttpServletRequest request, String requestContext) {
        this(engine, request, ((CommandResolver)engine.getManager(CommandResolver.class)).findCommand(request, requestContext));
        if (!engine.isConfigured()) {
            throw new InternalWikiException("Engine has not been properly started.  It is likely that the configuration is faulty.  Please check all logs for the possible reason.");
        }
    }

    public String getContentTemplate() {
        return this.m_command.getContentTemplate();
    }

    public String getJSP() {
        return this.m_command.getContentTemplate();
    }

    public WikiPage setRealPage(Page page) {
        WikiPage old = this.m_realPage;
        this.m_realPage = (WikiPage)page;
        this.updateCommand(this.m_command.getRequestContext());
        return old;
    }

    public WikiPage getRealPage() {
        return this.m_realPage;
    }

    public String getRedirectURL() {
        String pagename = this.m_page.getName();
        String redirURL = ((CommandResolver)this.m_engine.getManager(CommandResolver.class)).getSpecialPageReference(pagename);
        if (redirURL == null) {
            String alias = (String)this.m_page.getAttribute("alias");
            redirURL = alias != null ? this.getViewURL(alias) : (String)this.m_page.getAttribute("redirect");
        }
        return redirURL;
    }

    public WikiEngine getEngine() {
        return (WikiEngine)this.m_engine;
    }

    public WikiPage getPage() {
        return this.m_page;
    }

    public void setPage(Page page) {
        this.m_page = (WikiPage)page;
        this.updateCommand(this.m_command.getRequestContext());
    }

    public String getRequestContext() {
        return this.m_command.getRequestContext();
    }

    public void setRequestContext(String arg) {
        this.updateCommand(arg);
    }

    public Object getTarget() {
        return this.m_command.getTarget();
    }

    public String getURLPattern() {
        return this.m_command.getURLPattern();
    }

    public <T> T getVariable(String key) {
        return (T)this.m_variableMap.get(key);
    }

    public void setVariable(String key, Object data) {
        this.m_variableMap.put(key, data);
        this.updateCommand(this.m_command.getRequestContext());
    }

    public boolean getBooleanWikiProperty(String key, boolean defValue) {
        String bool = (String)this.getVariable(key);
        if (bool != null) {
            return TextUtil.isPositive((String)bool);
        }
        return TextUtil.getBooleanProperty((Properties)this.getEngine().getWikiProperties(), (String)key, (boolean)defValue);
    }

    public String getHttpParameter(String paramName) {
        String result = null;
        if (this.m_request != null) {
            result = this.m_request.getParameter(paramName);
        }
        return result;
    }

    public HttpServletRequest getHttpRequest() {
        return this.m_request;
    }

    public void setTemplate(String dir) {
        this.m_template = dir;
    }

    public String getName() {
        if (this.m_command instanceof PageCommand) {
            return this.m_page != null ? this.m_page.getName() : "<no page>";
        }
        return this.m_command.getName();
    }

    public String getTemplate() {
        return this.m_template;
    }

    public Principal getCurrentUser() {
        if (this.m_session == null) {
            return WikiPrincipal.GUEST;
        }
        return this.m_session.getUserPrincipal();
    }

    public String getViewURL(String page) {
        return this.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), page, null);
    }

    public String getURL(String context, String page) {
        return this.getURL(context, page, null);
    }

    public String getURL(String context, String page, String params) {
        return this.m_engine.getURL(context, page, params);
    }

    public Command getCommand() {
        return this.m_command;
    }

    public WikiContext clone() {
        try {
            WikiContext copy = (WikiContext)super.clone();
            copy.m_engine = this.m_engine;
            copy.m_command = this.m_command;
            copy.m_template = this.m_template;
            copy.m_variableMap = this.m_variableMap;
            copy.m_request = this.m_request;
            copy.m_session = this.m_session;
            copy.m_page = this.m_page;
            copy.m_realPage = this.m_realPage;
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public WikiContext deepClone() {
        try {
            WikiContext copy = (WikiContext)super.clone();
            copy.m_engine = this.m_engine;
            copy.m_command = this.m_command;
            copy.m_template = this.m_template;
            copy.m_variableMap = (HashMap)this.m_variableMap.clone();
            copy.m_request = this.m_request;
            copy.m_session = this.m_session;
            copy.m_page = this.m_page.clone();
            copy.m_realPage = this.m_realPage.clone();
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public WikiSession getWikiSession() {
        return (WikiSession)this.m_session;
    }

    @Deprecated
    public static WikiContext findContext(PageContext pageContext) {
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        return (WikiContext)request.getAttribute("jspwiki.context");
    }

    public Permission requiredPermission() {
        if (WikiCommand.INSTALL.equals(this.m_command)) {
            try {
                UserManager userMgr = (UserManager)this.m_engine.getManager(UserManager.class);
                UserDatabase userDb = userMgr.getUserDatabase();
                userDb.findByLoginName("admin");
            }
            catch (NoSuchPrincipalException e) {
                return DUMMY_PERMISSION;
            }
            return new AllPermission(this.m_engine.getApplicationName());
        }
        if (this.m_command.requiredPermission() == null) {
            return DUMMY_PERMISSION;
        }
        return this.m_command.requiredPermission();
    }

    public Command targetedCommand(Object target) {
        if (this.m_command.getTarget() == null) {
            return this.m_command.targetedCommand(target);
        }
        return this.m_command;
    }

    public boolean hasAdminPermissions() {
        return ((AuthorizationManager)this.m_engine.getManager(AuthorizationManager.class)).checkPermission(this.getWikiSession(), new AllPermission(this.m_engine.getApplicationName()));
    }

    protected void setDefaultTemplate(HttpServletRequest request) {
        WikiPage page;
        String skin;
        String defaultTemplate = this.m_engine.getTemplateDir();
        String template = null;
        if (request != null && (skin = request.getParameter("skin")) != null) {
            template = skin.replaceAll("\\p{Punct}", "");
        }
        if (template == null && (page = this.getPage()) != null) {
            template = (String)page.getAttribute("jspwiki.templateDir");
        }
        if (template != null) {
            this.setTemplate(template);
        } else {
            this.setTemplate(defaultTemplate);
        }
    }

    protected static Command findCommand(Engine engine, HttpServletRequest request, Page page) {
        String defaultContext = ContextEnum.PAGE_VIEW.getRequestContext();
        Command command = ((CommandResolver)engine.getManager(CommandResolver.class)).findCommand(request, defaultContext);
        if (command instanceof PageCommand && page != null) {
            command = command.targetedCommand((Object)page);
        }
        return command;
    }

    protected void updateCommand(String requestContext) {
        if (requestContext == null) {
            this.m_command = PageCommand.NONE;
        } else {
            CommandResolver resolver = (CommandResolver)this.m_engine.getManager(CommandResolver.class);
            this.m_command = resolver.findCommand(this.m_request, requestContext);
        }
        if (this.m_command instanceof PageCommand && this.m_page != null) {
            this.m_command = this.m_command.targetedCommand((Object)this.m_page);
        }
    }
}

