/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ajax;

import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.ajax.AjaxUtil;
import org.apache.wiki.ajax.WikiAjaxServlet;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.util.TextUtil;

public class WikiAjaxDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Map<String, AjaxServletContainer> ajaxServlets = new ConcurrentHashMap<String, AjaxServletContainer>();
    private static final Logger log = LogManager.getLogger((String)WikiAjaxDispatcherServlet.class.getName());
    private String PATH_AJAX = "/ajax/";
    private Engine m_engine;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_engine = Wiki.engine().find(config);
        this.PATH_AJAX = "/" + TextUtil.getStringProperty((Properties)this.m_engine.getWikiProperties(), (String)"jspwiki.ajax.url.prefix", (String)"ajax") + "/";
        log.info("WikiAjaxDispatcherServlet initialized.");
    }

    public static void registerServlet(WikiAjaxServlet servlet) {
        WikiAjaxDispatcherServlet.registerServlet(servlet.getServletMapping(), servlet);
    }

    public static void registerServlet(String alias, WikiAjaxServlet servlet) {
        WikiAjaxDispatcherServlet.registerServlet(alias, servlet, PagePermission.VIEW);
    }

    public static void registerServlet(String alias, WikiAjaxServlet servlet, Permission perm) {
        log.info("WikiAjaxDispatcherServlet registering " + alias + "=" + servlet + " perm=" + perm);
        ajaxServlets.put(alias, new AjaxServletContainer(alias, servlet, perm));
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.performAction(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.performAction(req, res);
    }

    private void performAction(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String path = req.getRequestURI();
        String servletName = this.getServletName(path);
        if (servletName != null) {
            AjaxServletContainer container = this.findServletContainer(servletName);
            if (container != null) {
                WikiAjaxServlet servlet = container.servlet;
                if (this.validatePermission(req, container)) {
                    req.setCharacterEncoding(this.m_engine.getContentEncoding().displayName());
                    res.setCharacterEncoding(this.m_engine.getContentEncoding().displayName());
                    String actionName = AjaxUtil.getNextPathPart(req.getRequestURI(), servlet.getServletMapping());
                    log.debug("actionName=" + actionName);
                    String params = req.getParameter("params");
                    log.debug("params=" + params);
                    List<String> paramValues = new ArrayList<String>();
                    if (params != null && StringUtils.isNotBlank((CharSequence)params)) {
                        paramValues = Arrays.asList(params.trim().split(","));
                    }
                    servlet.service(req, res, actionName, paramValues);
                } else {
                    log.warn("Servlet container " + container + " not authorised. Permission required.");
                }
            } else {
                log.error("No registered class for servletName=" + servletName + " in path=" + path);
                throw new ServletException("No registered class for servletName=" + servletName);
            }
        }
    }

    private boolean validatePermission(HttpServletRequest req, AjaxServletContainer container) {
        Engine e = Wiki.engine().find(req.getSession().getServletContext(), null);
        boolean valid = false;
        if (container != null) {
            valid = ((AuthorizationManager)e.getManager(AuthorizationManager.class)).checkPermission(Wiki.session().find(e, req), container.permission);
        }
        return valid;
    }

    public String getServletName(String path) throws ServletException {
        return AjaxUtil.getNextPathPart(path, this.PATH_AJAX);
    }

    private AjaxServletContainer findServletContainer(String servletAlias) {
        return ajaxServlets.get(servletAlias);
    }

    public WikiAjaxServlet findServletByName(String servletAlias) {
        AjaxServletContainer container = ajaxServlets.get(servletAlias);
        if (container != null) {
            return container.servlet;
        }
        return null;
    }

    private static class AjaxServletContainer {
        final String alias;
        final WikiAjaxServlet servlet;
        final Permission permission;

        public AjaxServletContainer(String alias, WikiAjaxServlet servlet, Permission permission) {
            this.alias = alias;
            this.servlet = servlet;
            this.permission = permission;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.alias + "=" + this.servlet.getClass().getSimpleName() + " permission=" + this.permission;
        }
    }
}

