/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.acl;

import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Acl;
import org.apache.wiki.api.core.AclEntry;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.AclManager;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.pages.PageLock;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.comparators.PrincipalComparator;

public class DefaultAclManager
implements AclManager {
    private static final Logger log = LogManager.getLogger(DefaultAclManager.class);
    private AuthorizationManager m_auth;
    private Engine m_engine;
    private static final String PERM_REGEX = "(comment|delete|edit|modify|rename|upload|view)";
    private static final String ACL_REGEX = "\\[\\{\\s*ALLOW\\s+(comment|delete|edit|modify|rename|upload|view)\\s*(.*?)\\s*\\}\\]";
    public static final Pattern ACL_PATTERN = Pattern.compile("\\[\\{\\s*ALLOW\\s+(comment|delete|edit|modify|rename|upload|view)\\s*(.*?)\\s*\\}\\]");

    public void initialize(Engine engine, Properties props) {
        this.m_auth = (AuthorizationManager)engine.getManager(AuthorizationManager.class);
        this.m_engine = engine;
    }

    @Override
    public Acl parseAcl(Page page, String ruleLine) throws WikiSecurityException {
        Acl acl = page.getAcl();
        if (acl == null) {
            acl = Wiki.acls().acl();
        }
        try {
            StringTokenizer fieldToks = new StringTokenizer(ruleLine);
            fieldToks.nextToken();
            String actions = fieldToks.nextToken();
            while (fieldToks.hasMoreTokens()) {
                String principalName = fieldToks.nextToken(",").trim();
                Principal principal = this.m_auth.resolvePrincipal(principalName);
                AclEntry oldEntry = acl.getAclEntry(principal);
                if (oldEntry != null) {
                    log.debug("Adding to old acl list: " + principal + ", " + actions);
                    oldEntry.addPermission((Permission)PermissionFactory.getPagePermission(page, actions));
                    continue;
                }
                log.debug("Adding new acl entry for " + actions);
                AclEntry entry = Wiki.acls().entry();
                entry.setPrincipal(principal);
                entry.addPermission((Permission)PermissionFactory.getPagePermission(page, actions));
                acl.addEntry(entry);
            }
            page.setAcl(acl);
            log.debug(acl.toString());
        }
        catch (NoSuchElementException nsee) {
            log.warn("Invalid access rule: " + ruleLine + " - defaults will be used.");
            throw new WikiSecurityException("Invalid access rule: " + ruleLine, nsee);
        }
        catch (IllegalArgumentException iae) {
            throw new WikiSecurityException("Invalid permission type: " + ruleLine, iae);
        }
        return acl;
    }

    @Override
    public Acl getPermissions(Page page) {
        Acl acl = page.getAcl();
        log.debug("page=" + page.getName() + "\n" + acl);
        if (acl == null) {
            if (page instanceof Attachment) {
                Page parent = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(((Attachment)page).getParentName());
                acl = this.getPermissions(parent);
            } else {
                Context ctx = Wiki.context().create(this.m_engine, page);
                ctx.setVariable("_PluginContent.execute", (Object)Boolean.FALSE);
                ((RenderingManager)this.m_engine.getManager(RenderingManager.class)).getHTML(ctx, page);
                if (page.getAcl() == null) {
                    page.setAcl(Wiki.acls().acl());
                }
                acl = page.getAcl();
            }
        }
        return acl;
    }

    @Override
    public void setPermissions(Page page, Acl acl) throws WikiSecurityException {
        PageManager pageManager = (PageManager)this.m_engine.getManager(PageManager.class);
        PageLock lock = pageManager.getCurrentLock(page);
        if (lock != null) {
            pageManager.unlockPage(lock);
        }
        String pageText = ((PageManager)this.m_engine.getManager(PageManager.class)).getPureText(page);
        Matcher matcher = ACL_PATTERN.matcher(pageText);
        String cleansedText = matcher.replaceAll("");
        String newText = DefaultAclManager.printAcl(page.getAcl()) + cleansedText;
        try {
            pageManager.putPageText(page, newText);
        }
        catch (ProviderException e) {
            throw new WikiSecurityException("Could not set Acl. Reason: ProviderExcpetion " + e.getMessage(), e);
        }
    }

    protected static String printAcl(Acl acl) {
        ArrayList<Principal> principals;
        TreeMap<String, ArrayList<Principal>> permissionPrincipals = new TreeMap<String, ArrayList<Principal>>();
        Enumeration entries = acl.aclEntries();
        while (entries.hasMoreElements()) {
            AclEntry entry = (AclEntry)entries.nextElement();
            Principal principal = entry.getPrincipal();
            Enumeration permissions = entry.permissions();
            while (permissions.hasMoreElements()) {
                Permission permission = (Permission)permissions.nextElement();
                principals = (ArrayList<Principal>)permissionPrincipals.get(permission.getActions());
                if (principals == null) {
                    principals = new ArrayList<Principal>();
                    String action = permission.getActions();
                    if (action.indexOf(44) != -1) {
                        throw new IllegalStateException("AclEntry permission cannot have multiple targets.");
                    }
                    permissionPrincipals.put(action, principals);
                }
                principals.add(principal);
            }
        }
        StringBuilder s = new StringBuilder();
        for (Map.Entry entry : permissionPrincipals.entrySet()) {
            String action = (String)entry.getKey();
            principals = (List)entry.getValue();
            principals.sort((Comparator<Principal>)new PrincipalComparator());
            s.append("[{ALLOW ").append(action).append(" ");
            for (int i = 0; i < principals.size(); ++i) {
                Principal principal = (Principal)principals.get(i);
                s.append(principal.getName());
                if (i >= principals.size() - 1) continue;
                s.append(",");
            }
            s.append("}]\n");
        }
        return s.toString();
    }
}

