/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.diff;

import java.io.IOException;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.diff.DiffProvider;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.TextUtil;
import org.suigeneris.jrcs.diff.Diff;
import org.suigeneris.jrcs.diff.DiffAlgorithm;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.Revision;
import org.suigeneris.jrcs.diff.RevisionVisitor;
import org.suigeneris.jrcs.diff.delta.AddDelta;
import org.suigeneris.jrcs.diff.delta.ChangeDelta;
import org.suigeneris.jrcs.diff.delta.Chunk;
import org.suigeneris.jrcs.diff.delta.DeleteDelta;
import org.suigeneris.jrcs.diff.myers.MyersDiff;

public class TraditionalDiffProvider
implements DiffProvider {
    private static final Logger log = LogManager.getLogger(TraditionalDiffProvider.class);
    private static final String CSS_DIFF_ADDED = "<tr><td class=\"diffadd\">";
    private static final String CSS_DIFF_REMOVED = "<tr><td class=\"diffrem\">";
    private static final String CSS_DIFF_UNCHANGED = "<tr><td class=\"diff\">";
    private static final String CSS_DIFF_CLOSE = "</td></tr>" + Diff.NL;

    public String getProviderInfo() {
        return "TraditionalDiffProvider";
    }

    public void initialize(Engine engine, Properties properties) throws NoRequiredPropertyException, IOException {
    }

    @Override
    public String makeDiffHtml(Context ctx, String p1, String p2) {
        try {
            Object[] first = Diff.stringToArray((String)TextUtil.replaceEntities((String)p1));
            Object[] second = Diff.stringToArray((String)TextUtil.replaceEntities((String)p2));
            Revision rev = Diff.diff((Object[])first, (Object[])second, (DiffAlgorithm)new MyersDiff());
            if (rev == null || rev.size() == 0) {
                return "";
            }
            StringBuffer ret = new StringBuffer(rev.size() * 20);
            ret.append("<table class=\"diff\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
            rev.accept((RevisionVisitor)new RevisionPrint(ctx, ret));
            ret.append("</table>\n");
            return ret.toString();
        }
        catch (DifferentiationFailedException e) {
            String diffResult = "makeDiff failed with DifferentiationFailedException";
            log.error(diffResult, (Throwable)e);
            return diffResult;
        }
    }

    private static final class RevisionPrint
    implements RevisionVisitor {
        private final StringBuffer m_result;
        private final Context m_context;
        private final ResourceBundle m_rb;

        private RevisionPrint(Context ctx, StringBuffer sb) {
            this.m_result = sb;
            this.m_context = ctx;
            this.m_rb = Preferences.getBundle(ctx, "CoreResources");
        }

        public void visit(Revision rev) {
        }

        public void visit(AddDelta delta) {
            Chunk changed = delta.getRevised();
            this.print(changed, this.m_rb.getString("diff.traditional.added"));
            changed.toString(this.m_result, TraditionalDiffProvider.CSS_DIFF_ADDED, CSS_DIFF_CLOSE);
        }

        public void visit(ChangeDelta delta) {
            Chunk changed = delta.getOriginal();
            this.print(changed, this.m_rb.getString("diff.traditional.changed"));
            changed.toString(this.m_result, TraditionalDiffProvider.CSS_DIFF_REMOVED, CSS_DIFF_CLOSE);
            delta.getRevised().toString(this.m_result, TraditionalDiffProvider.CSS_DIFF_ADDED, CSS_DIFF_CLOSE);
        }

        public void visit(DeleteDelta delta) {
            Chunk changed = delta.getOriginal();
            this.print(changed, this.m_rb.getString("diff.traditional.removed"));
            changed.toString(this.m_result, TraditionalDiffProvider.CSS_DIFF_REMOVED, CSS_DIFF_CLOSE);
        }

        private void print(Chunk changed, String type) {
            this.m_result.append(TraditionalDiffProvider.CSS_DIFF_UNCHANGED);
            String[] choiceString = new String[]{this.m_rb.getString("diff.traditional.oneline"), this.m_rb.getString("diff.traditional.lines")};
            double[] choiceLimits = new double[]{1.0, 2.0};
            MessageFormat fmt = new MessageFormat("");
            fmt.setLocale(Preferences.getLocale(this.m_context));
            ChoiceFormat cfmt = new ChoiceFormat(choiceLimits, choiceString);
            fmt.applyPattern(type);
            Format[] formats = new Format[]{NumberFormat.getInstance(), cfmt, NumberFormat.getInstance()};
            fmt.setFormats(formats);
            Object[] params = new Object[]{changed.first() + 1, changed.size(), changed.size()};
            this.m_result.append(fmt.format(params));
            this.m_result.append(CSS_DIFF_CLOSE);
        }
    }
}

