/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki.syntax.jspwiki;

import java.io.PrintWriter;
import java.util.Stack;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.apache.wiki.htmltowiki.syntax.jspwiki.PlainTextCssSpecialDecorator;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

class PlainTextMonospaceDecorator {
    final PrintWriter out;
    final Stack<String> preStack;
    final XHtmlElementToWikiTranslator chain;
    final PlainTextCssSpecialDecorator ptcsd;

    PlainTextMonospaceDecorator(PrintWriter out, Stack<String> preStack, XHtmlElementToWikiTranslator chain) {
        this.out = out;
        this.preStack = preStack;
        this.chain = chain;
        this.ptcsd = new PlainTextCssSpecialDecorator(out, preStack, chain);
    }

    void decorate(XHtmlElementToWikiTranslator.ElementDecoratorData dto) throws JDOMException {
        if (dto.monospace) {
            this.out.print("{{{");
            this.preStack.push("{{{");
        }
        this.ptcsd.decorate(dto);
        if (dto.monospace) {
            this.preStack.pop();
            this.out.print("}}}");
        }
    }

    void decorate(Element e) throws JDOMException {
        this.out.print("\n{{{");
        this.preStack.push("\n{{{");
        this.chain.translate((Content)e);
        this.preStack.pop();
        this.out.print("}}}\n");
    }
}

