/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.plugin.AbstractReferralPlugin;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.XHTML;
import org.apache.wiki.util.XhtmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.Format;

public class RecentChangesPlugin
extends AbstractReferralPlugin
implements Plugin {
    private static final Logger log = LogManager.getLogger(RecentChangesPlugin.class);
    public static final String PARAM_FORMAT = "format";
    public static final String PARAM_TIME_FORMAT = "timeFormat";
    public static final String PARAM_DATE_FORMAT = "dateFormat";
    private static final int DEFAULT_DAYS = 36500;
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "dd.MM.yyyy";

    public String execute(Context context, Map<String, String> params) throws PluginException {
        int since = TextUtil.parseIntParameter((String)params.get("since"), (int)36500);
        String spacing = "4";
        boolean showAuthor = true;
        boolean showChangenote = true;
        String tablewidth = "4";
        Engine engine = context.getEngine();
        if ("compact".equals(params.get(PARAM_FORMAT))) {
            spacing = "0";
            showAuthor = false;
            showChangenote = false;
            tablewidth = "2";
        }
        GregorianCalendar sincedate = new GregorianCalendar();
        ((Calendar)sincedate).add(5, -since);
        log.debug("Calculating recent changes from " + sincedate.getTime());
        Collection<Page> changes = ((PageManager)engine.getManager(PageManager.class)).getRecentChanges();
        super.initialize(context, params);
        changes = this.filterWikiPageCollection(changes);
        if (changes != null) {
            Page pageref;
            Date lastmod;
            Date olddate = new Date(0L);
            DateFormat fmt = this.getDateFormat(context, params);
            DateFormat tfmt = this.getTimeFormat(context, params);
            Element rt = XhtmlUtil.element((XHTML)XHTML.table);
            rt.setAttribute("class", "recentchanges");
            rt.setAttribute("cellpadding", spacing);
            Iterator<Page> iterator = changes.iterator();
            while (iterator.hasNext() && !(lastmod = (pageref = iterator.next()).getLastModified()).before(sincedate.getTime())) {
                if (!this.isSameDay(lastmod, olddate)) {
                    Element row = XhtmlUtil.element((XHTML)XHTML.tr);
                    Element col = XhtmlUtil.element((XHTML)XHTML.td);
                    col.setAttribute("colspan", tablewidth);
                    col.setAttribute("class", "date");
                    col.addContent((Content)XhtmlUtil.element((XHTML)XHTML.b, (String)fmt.format(lastmod)));
                    rt.addContent((Content)row);
                    row.addContent((Content)col);
                    olddate = lastmod;
                }
                String href = context.getURL(pageref instanceof Attachment ? ContextEnum.PAGE_ATTACH.getRequestContext() : ContextEnum.PAGE_VIEW.getRequestContext(), pageref.getName());
                Element link = XhtmlUtil.link((String)href, (String)((RenderingManager)engine.getManager(RenderingManager.class)).beautifyTitle(pageref.getName()));
                Element row = XhtmlUtil.element((XHTML)XHTML.tr);
                Element col = XhtmlUtil.element((XHTML)XHTML.td);
                col.setAttribute("width", "30%");
                col.addContent((Content)link);
                if (pageref instanceof Attachment) {
                    link = XhtmlUtil.link((String)context.getURL(WikiContext.INFO, pageref.getName()), null);
                    link.setAttribute("class", "infolink");
                    Element img = XhtmlUtil.img((String)context.getURL(WikiContext.NONE, "images/attachment_small.png"), null);
                    link.addContent((Content)img);
                    col.addContent((Content)link);
                }
                row.addContent((Content)col);
                rt.addContent((Content)row);
                if (pageref instanceof Attachment) {
                    Element td = XhtmlUtil.element((XHTML)XHTML.td, (String)tfmt.format(lastmod));
                    td.setAttribute("class", "lastchange");
                    row.addContent((Content)td);
                } else {
                    Element infocol = XhtmlUtil.element((XHTML)XHTML.td);
                    infocol.setAttribute("class", "lastchange");
                    infocol.addContent((Content)XhtmlUtil.link((String)context.getURL(WikiContext.DIFF, pageref.getName(), "r1=-1"), (String)tfmt.format(lastmod)));
                    row.addContent((Content)infocol);
                }
                if (showAuthor) {
                    String author = pageref.getAuthor();
                    Element authorinfo = XhtmlUtil.element((XHTML)XHTML.td);
                    authorinfo.setAttribute("class", "author");
                    if (author != null) {
                        if (((PageManager)engine.getManager(PageManager.class)).wikiPageExists(author)) {
                            authorinfo.addContent((Content)XhtmlUtil.link((String)context.getURL(WikiContext.VIEW, author), (String)author));
                        } else {
                            authorinfo.addContent(author);
                        }
                    } else {
                        authorinfo.addContent(Preferences.getBundle(context, "CoreResources").getString("common.unknownauthor"));
                    }
                    row.addContent((Content)authorinfo);
                }
                if (!showChangenote) continue;
                String changenote = (String)pageref.getAttribute("changenote");
                Element td_changenote = XhtmlUtil.element((XHTML)XHTML.td, (String)changenote);
                td_changenote.setAttribute("class", "changenote");
                row.addContent((Content)td_changenote);
            }
            return XhtmlUtil.serialize((Element)rt, (Format)XhtmlUtil.EXPAND_EMPTY_NODES);
        }
        return "";
    }

    private boolean isSameDay(Date a, Date b) {
        Calendar aa = Calendar.getInstance();
        aa.setTime(a);
        Calendar bb = Calendar.getInstance();
        bb.setTime(b);
        return aa.get(1) == bb.get(1) && aa.get(6) == bb.get(6);
    }

    private DateFormat getTimeFormat(Context context, Map<String, String> params) {
        String formatString = this.get(params, DEFAULT_TIME_FORMAT, PARAM_TIME_FORMAT);
        if (StringUtils.isBlank((CharSequence)formatString)) {
            return Preferences.getDateFormat(context, Preferences.TimeFormat.TIME);
        }
        return new SimpleDateFormat(formatString);
    }

    private DateFormat getDateFormat(Context context, Map<String, String> params) {
        String formatString = this.get(params, DEFAULT_DATE_FORMAT, PARAM_DATE_FORMAT);
        if (StringUtils.isBlank((CharSequence)formatString)) {
            return Preferences.getDateFormat(context, Preferences.TimeFormat.DATE);
        }
        return new SimpleDateFormat(formatString);
    }

    private String get(Map<String, String> params, String defaultValue, String paramName) {
        String value = params.get(paramName);
        return value == null ? defaultValue : value;
    }
}

