/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.providers.AttachmentProvider;
import org.apache.wiki.api.search.QueryItem;
import org.apache.wiki.cache.CacheInfo;
import org.apache.wiki.cache.CachingManager;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;

public class CachingAttachmentProvider
implements AttachmentProvider {
    private static final Logger LOG = LogManager.getLogger(CachingAttachmentProvider.class);
    private AttachmentProvider m_provider;
    private CachingManager cachingManager;
    private boolean m_gotall;

    public void initialize(Engine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        String classname;
        LOG.info("Initing CachingAttachmentProvider");
        this.cachingManager = (CachingManager)engine.getManager(CachingManager.class);
        try {
            classname = TextUtil.getRequiredProperty((Properties)properties, (String)"jspwiki.attachment.provider", (String)"jspwiki.attachmentProvider");
        }
        catch (NoSuchElementException e) {
            throw new NoRequiredPropertyException(e.getMessage(), "jspwiki.attachment.provider");
        }
        try {
            this.m_provider = (AttachmentProvider)ClassUtil.buildInstance((String)"org.apache.wiki.providers", (String)classname);
            LOG.debug("Initializing real provider class {}", (Object)this.m_provider);
            this.m_provider.initialize(engine, properties);
        }
        catch (ReflectiveOperationException e) {
            LOG.error("Unable to instantiate provider class {}", (Object)classname, (Object)e);
            throw new IllegalArgumentException("illegal provider class", e);
        }
    }

    public void putAttachmentData(Attachment att, InputStream data) throws ProviderException, IOException {
        this.m_provider.putAttachmentData(att, data);
        this.cachingManager.remove("jspwiki.attachmentCollectionsCache", (Serializable)((Object)att.getParentName()));
        att.setLastModified(new Date());
        this.cachingManager.put("jspwiki.attachmentsCache", (Serializable)((Object)att.getName()), (Object)att);
    }

    public InputStream getAttachmentData(Attachment att) throws ProviderException, IOException {
        return this.m_provider.getAttachmentData(att);
    }

    public List<Attachment> listAttachments(Page page) throws ProviderException {
        LOG.debug("Listing attachments for {}", (Object)page);
        List atts = (List)this.cachingManager.get("jspwiki.attachmentCollectionsCache", (Serializable)((Object)page.getName()), () -> this.m_provider.listAttachments(page));
        return this.cloneCollection(atts);
    }

    private <T> List<T> cloneCollection(Collection<T> c) {
        return c != null ? new ArrayList<T>(c) : Collections.emptyList();
    }

    public Collection<Attachment> findAttachments(QueryItem[] query) {
        return this.m_provider.findAttachments(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attachment> listAllChanged(Date timestamp) throws ProviderException {
        ArrayList<Attachment> all;
        if (!this.m_gotall) {
            all = this.m_provider.listAllChanged(timestamp);
            CachingAttachmentProvider cachingAttachmentProvider = this;
            synchronized (cachingAttachmentProvider) {
                for (Attachment att : all) {
                    this.cachingManager.put("jspwiki.attachmentsCache", (Serializable)((Object)att.getName()), (Object)att);
                }
                this.m_gotall = true;
            }
        } else {
            List keys = this.cachingManager.keys("jspwiki.attachmentsCache");
            all = new ArrayList<Attachment>();
            for (String key : keys) {
                Attachment cachedAttachment = (Attachment)this.cachingManager.get("jspwiki.attachmentsCache", (Serializable)((Object)key), () -> null);
                if (cachedAttachment == null) continue;
                all.add(cachedAttachment);
            }
        }
        if (this.cachingManager.enabled("jspwiki.attachmentsCache") && (long)all.size() >= this.cachingManager.info("jspwiki.attachmentsCache").getMaxElementsAllowed()) {
            LOG.warn("seems {} can't hold all attachments from your page repository, so we're delegating on the underlying provider instead. Please consider increasing your cache sizes on the ehcache configuration file to avoid this behaviour", (Object)"jspwiki.attachmentsCache");
            return this.m_provider.listAllChanged(timestamp);
        }
        return all;
    }

    private Attachment findAttachmentFromCollection(Collection<Attachment> c, String name) {
        if (c != null) {
            for (Attachment att : c) {
                if (!name.equals(att.getFileName())) continue;
                return att;
            }
        }
        return null;
    }

    public Attachment getAttachmentInfo(Page page, String name, int version) throws ProviderException {
        LOG.debug("Getting attachments for {}, name={}, version={}", (Object)page, (Object)name, (Object)version);
        if (version != -1) {
            LOG.debug("...we don't cache old versions");
            return this.m_provider.getAttachmentInfo(page, name, version);
        }
        Collection c = (Collection)this.cachingManager.get("jspwiki.attachmentCollectionsCache", (Serializable)((Object)page.getName()), () -> this.m_provider.listAttachments(page));
        return this.findAttachmentFromCollection(c, name);
    }

    public List<Attachment> getVersionHistory(Attachment att) {
        return this.m_provider.getVersionHistory(att);
    }

    public void deleteVersion(Attachment att) throws ProviderException {
        this.cachingManager.remove("jspwiki.attachmentCollectionsCache", (Serializable)((Object)att.getParentName()));
        this.m_provider.deleteVersion(att);
    }

    public void deleteAttachment(Attachment att) throws ProviderException {
        this.cachingManager.remove("jspwiki.attachmentCollectionsCache", (Serializable)((Object)att.getParentName()));
        this.cachingManager.remove("jspwiki.attachmentsCache", (Serializable)((Object)att.getName()));
        this.m_provider.deleteAttachment(att);
    }

    public synchronized String getProviderInfo() {
        CacheInfo attCacheInfo = this.cachingManager.info("jspwiki.attachmentsCache");
        CacheInfo attColCacheInfo = this.cachingManager.info("jspwiki.attachmentCollectionsCache");
        return "Real provider: " + this.m_provider.getClass().getName() + ". Attachment cache hits: " + attCacheInfo.getHits() + ". Attachment cache misses: " + attCacheInfo.getMisses() + ". Attachment collection cache hits: " + attColCacheInfo.getHits() + ". Attachment collection cache misses: " + attColCacheInfo.getMisses();
    }

    public AttachmentProvider getRealProvider() {
        return this.m_provider;
    }

    public void moveAttachmentsForPage(String oldParent, String newParent) throws ProviderException {
        this.m_provider.moveAttachmentsForPage(oldParent, newParent);
        this.cachingManager.remove("jspwiki.attachmentCollectionsCache", (Serializable)((Object)newParent));
        this.cachingManager.remove("jspwiki.attachmentCollectionsCache", (Serializable)((Object)oldParent));
        String checkName = oldParent + "/";
        List names = this.cachingManager.keys("jspwiki.attachmentCollectionsCache");
        for (String name : names) {
            if (!name.startsWith(checkName)) continue;
            this.cachingManager.remove("jspwiki.attachmentsCache", (Serializable)((Object)name));
        }
    }
}

