/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.ui.TemplateManager;

public class ContentTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger log = LogManager.getLogger(ContentTag.class);
    private final Map<String, String> m_mappings = new HashMap<String, String>();

    public void setView(String s) {
        this.m_mappings.put(ContextEnum.PAGE_VIEW.getRequestContext(), s);
    }

    public void setDiff(String s) {
        this.m_mappings.put(ContextEnum.PAGE_DIFF.getRequestContext(), s);
    }

    public void setInfo(String s) {
        this.m_mappings.put(ContextEnum.PAGE_INFO.getRequestContext(), s);
    }

    public void setPreview(String s) {
        this.m_mappings.put(ContextEnum.PAGE_PREVIEW.getRequestContext(), s);
    }

    public void setConflict(String s) {
        this.m_mappings.put(ContextEnum.PAGE_CONFLICT.getRequestContext(), s);
    }

    public void setFind(String s) {
        this.m_mappings.put(ContextEnum.WIKI_FIND.getRequestContext(), s);
    }

    public void setPrefs(String s) {
        this.m_mappings.put(ContextEnum.WIKI_PREFS.getRequestContext(), s);
    }

    public void setError(String s) {
        this.m_mappings.put(ContextEnum.WIKI_ERROR.getRequestContext(), s);
    }

    public void setEdit(String s) {
        this.m_mappings.put(ContextEnum.PAGE_EDIT.getRequestContext(), s);
    }

    public void setComment(String s) {
        this.m_mappings.put(ContextEnum.PAGE_COMMENT.getRequestContext(), s);
    }

    @Override
    public final int doWikiStartTag() throws IOException, ProviderException {
        return 0;
    }

    @Override
    public final int doEndTag() throws JspException {
        try {
            String requestContext = this.m_wikiContext.getRequestContext();
            String contentTemplate = this.m_mappings.get(requestContext);
            if (contentTemplate == null) {
                contentTemplate = this.m_wikiContext.getContentTemplate();
            }
            if (contentTemplate == null) {
                throw new JspException("This template uses <wiki:Content/> in an unsupported context: " + requestContext);
            }
            String page = ((TemplateManager)this.m_wikiContext.getEngine().getManager(TemplateManager.class)).findJSP(this.pageContext, this.m_wikiContext.getTemplate(), contentTemplate);
            this.pageContext.include(page);
        }
        catch (ServletException e) {
            log.warn("Including failed, got a servlet exception from sub-page. Rethrowing the exception to the JSP engine.", (Throwable)e);
            throw new JspException(e.getMessage());
        }
        catch (IOException e) {
            log.warn("I/O exception - probably the connection was broken. Rethrowing the exception to the JSP engine.", (Throwable)e);
            throw new JspException(e.getMessage());
        }
        return 6;
    }
}

