/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.api.core.Command;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.auth.GroupPrincipal;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.ui.AllCommands;
import org.apache.wiki.ui.CommandResolver;
import org.apache.wiki.ui.GroupCommand;
import org.apache.wiki.ui.PageCommand;
import org.apache.wiki.ui.RedirectCommand;
import org.apache.wiki.ui.WikiCommand;
import org.apache.wiki.url.URLConstructor;
import org.apache.wiki.util.TextUtil;

public class DefaultCommandResolver
implements CommandResolver {
    private static final Map<String, Command> CONTEXTS;
    private static final Map<String, Command> JSPS;
    private static final Logger LOG;
    private final Engine m_engine;
    private final boolean m_matchEnglishPlurals;
    private final Map<String, Command> m_specialPages;

    public DefaultCommandResolver(Engine engine, Properties properties) {
        this.m_engine = engine;
        this.m_specialPages = new HashMap<String, Command>();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("jspwiki.specialPage.")) continue;
            String specialPage = key.substring("jspwiki.specialPage.".length());
            String jsp = properties.getProperty(key);
            if (jsp == null) continue;
            specialPage = specialPage.trim();
            Command command = JSPS.get(jsp = jsp.trim());
            if (command == null) {
                Command redirect = RedirectCommand.REDIRECT;
                command = redirect.targetedCommand((Object)jsp);
            }
            this.m_specialPages.put(specialPage, command);
        }
        this.m_matchEnglishPlurals = TextUtil.getBooleanProperty((Properties)properties, (String)"jspwiki.translatorReader.matchEnglishPlurals", (boolean)true);
    }

    @Override
    public Command findCommand(HttpServletRequest request, String defaultContext) {
        if (request == null) {
            return CommandResolver.findCommand(defaultContext);
        }
        Command command = null;
        String pageName = this.extractPageFromParameter(defaultContext, request);
        if (pageName != null) {
            command = this.m_specialPages.get(pageName);
        }
        if (command == null && (command = this.extractCommandFromPath(request)) == null && (command = CONTEXTS.get(defaultContext)) == null) {
            throw new IllegalArgumentException("Wiki context " + defaultContext + " is illegal.");
        }
        if (PageCommand.VIEW.equals(command) && pageName == null) {
            pageName = this.m_engine.getFrontPage();
        }
        if (command instanceof PageCommand && pageName != null) {
            Page page = this.resolvePage(request, pageName);
            return command.targetedCommand((Object)page);
        }
        String wiki = this.m_engine.getApplicationName();
        if (WikiCommand.CREATE_GROUP.equals(command)) {
            return WikiCommand.CREATE_GROUP.targetedCommand((Object)wiki);
        }
        if (command instanceof GroupCommand) {
            String groupName = request.getParameter("group");
            if ((groupName = TextUtil.replaceEntities((String)groupName)) != null && !groupName.isEmpty()) {
                GroupPrincipal group = new GroupPrincipal(groupName);
                return command.targetedCommand((Object)group);
            }
        }
        return command;
    }

    @Override
    public String getFinalPageName(String page) throws ProviderException {
        boolean isThere = this.simplePageExists(page);
        String finalName = page;
        if (!isThere && this.m_matchEnglishPlurals) {
            finalName = page.endsWith("s") ? page.substring(0, page.length() - 1) : finalName + "s";
            isThere = this.simplePageExists(finalName);
        }
        if (!isThere && !(isThere = this.simplePageExists(finalName = MarkupParser.wikifyLink(page))) && this.m_matchEnglishPlurals) {
            finalName = finalName.endsWith("s") ? finalName.substring(0, finalName.length() - 1) : finalName + "s";
            isThere = this.simplePageExists(finalName);
        }
        return isThere ? finalName : null;
    }

    @Override
    public String getSpecialPageReference(String page) {
        Command command = this.m_specialPages.get(page);
        if (command != null) {
            return ((URLConstructor)this.m_engine.getManager(URLConstructor.class)).makeURL(command.getRequestContext(), command.getURLPattern(), null);
        }
        return null;
    }

    protected Command extractCommandFromPath(HttpServletRequest request) {
        int questionMark;
        String jsp = request.getServletPath();
        int hashMark = jsp.indexOf(35);
        if (hashMark != -1) {
            jsp = jsp.substring(0, hashMark);
        }
        if ((questionMark = jsp.indexOf(63)) != -1) {
            jsp = jsp.substring(0, questionMark);
        }
        if (jsp.startsWith("/")) {
            jsp = jsp.substring(1);
        }
        for (Map.Entry<String, Command> entry : this.m_specialPages.entrySet()) {
            Command specialCommand = entry.getValue();
            if (!specialCommand.getJSP().equals(jsp)) continue;
            return specialCommand;
        }
        if (!jsp.isEmpty() && JSPS.containsKey(jsp)) {
            return JSPS.get(jsp);
        }
        return null;
    }

    @Override
    public String extractPageFromParameter(String requestContext, HttpServletRequest request) {
        block5: {
            try {
                String page = ((URLConstructor)this.m_engine.getManager(URLConstructor.class)).parsePage(requestContext, request, this.m_engine.getContentEncoding());
                if (page == null) break block5;
                try {
                    String finalPage = this.getFinalPageName(page);
                    if (finalPage != null) {
                        page = finalPage;
                    }
                }
                catch (ProviderException providerException) {
                    // empty catch block
                }
                return page;
            }
            catch (IOException e) {
                LOG.error("Unable to create context", (Throwable)e);
                throw new InternalWikiException("Big internal booboo, please check logs.", e);
            }
        }
        return null;
    }

    @Override
    public Page resolvePage(HttpServletRequest request, String page) {
        Page wikipage;
        int version = -1;
        String rev = request.getParameter("version");
        if (rev != null) {
            try {
                version = Integer.parseInt(rev);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((wikipage = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(page, version)) == null) {
            page = MarkupParser.cleanLink(page);
            wikipage = Wiki.contents().page(this.m_engine, page);
        }
        return wikipage;
    }

    protected boolean simplePageExists(String page) throws ProviderException {
        if (this.m_specialPages.containsKey(page)) {
            return true;
        }
        return ((PageManager)this.m_engine.getManager(PageManager.class)).pageExists(page);
    }

    static {
        Command[] commands;
        CONTEXTS = new HashMap<String, Command>();
        JSPS = new HashMap<String, Command>();
        for (Command command : commands = AllCommands.get()) {
            JSPS.put(command.getJSP(), command);
            CONTEXTS.put(command.getRequestContext(), command);
        }
        LOG = LogManager.getLogger(DefaultCommandResolver.class);
    }
}

