/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.xmlrpc.WikiRPCHandler;
import org.apache.xmlrpc.ContextXmlRpcHandler;
import org.apache.xmlrpc.Invoker;
import org.apache.xmlrpc.XmlRpcContext;
import org.apache.xmlrpc.XmlRpcHandlerMapping;
import org.apache.xmlrpc.XmlRpcServer;

public class RPCServlet
extends HttpServlet {
    private static final long serialVersionUID = 3976735878410416180L;
    public static final String XMLRPC_PREFIX = "wiki";
    private Engine m_engine;
    private final XmlRpcServer m_xmlrpcServer = new XmlRpcServer();
    private static final Logger log = LogManager.getLogger(RPCServlet.class);

    public void initHandler(String prefix, String handlerName) throws ClassNotFoundException {
        Class handlerClass = ClassUtil.findClass((String)"", (String)handlerName);
        this.m_xmlrpcServer.addHandler(prefix, (Object)new LocalHandler(handlerClass));
    }

    public void init(ServletConfig config) throws ServletException {
        this.m_engine = Wiki.engine().find(config);
        String handlerName = config.getInitParameter("handler");
        String prefix = config.getInitParameter("prefix");
        if (handlerName == null) {
            handlerName = "org.apache.wiki.xmlrpc.RPCHandler";
        }
        if (prefix == null) {
            prefix = XMLRPC_PREFIX;
        }
        try {
            this.initHandler(prefix, handlerName);
            this.initHandler("metaWeblog", "org.apache.wiki.xmlrpc.MetaWeblogHandler");
        }
        catch (Exception e) {
            log.fatal("Unable to start RPC interface: ", (Throwable)e);
            throw new ServletException("No RPC interface", (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug("Received POST to RPCServlet");
        try {
            Context ctx = Wiki.context().create(this.m_engine, request, ContextEnum.PAGE_NONE.getRequestContext());
            WikiXmlRpcContext xmlrpcContext = new WikiXmlRpcContext(this.m_xmlrpcServer.getHandlerMapping(), ctx);
            byte[] result = this.m_xmlrpcServer.execute((InputStream)request.getInputStream(), (XmlRpcContext)xmlrpcContext);
            response.setContentType("text/xml; charset=utf-8");
            response.setContentLength(result.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(result);
            out.flush();
        }
        catch (IOException e) {
            throw new ServletException("Failed to build RPC result", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug("Received HTTP GET to RPCServlet");
        try {
            String msg = "We do not support HTTP GET here.  Sorry.";
            response.setContentType("text/plain");
            response.setContentLength("We do not support HTTP GET here.  Sorry.".length());
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
            writer.println("We do not support HTTP GET here.  Sorry.");
            writer.flush();
        }
        catch (IOException e) {
            throw new ServletException("Failed to build RPC result", (Throwable)e);
        }
    }

    private static class WikiXmlRpcContext
    implements XmlRpcContext {
        private final XmlRpcHandlerMapping m_mapping;
        private final Context m_context;

        public WikiXmlRpcContext(XmlRpcHandlerMapping map, Context ctx) {
            this.m_mapping = map;
            this.m_context = ctx;
        }

        public XmlRpcHandlerMapping getHandlerMapping() {
            return this.m_mapping;
        }

        public String getPassword() {
            return null;
        }

        public String getUserName() {
            return null;
        }

        public Context getWikiContext() {
            return this.m_context;
        }
    }

    private static class LocalHandler
    implements ContextXmlRpcHandler {
        private final Class<WikiRPCHandler> m_clazz;

        public LocalHandler(Class<WikiRPCHandler> clazz) {
            this.m_clazz = clazz;
        }

        public Object execute(String method, Vector params, XmlRpcContext context) throws Exception {
            WikiRPCHandler rpchandler = (WikiRPCHandler)ClassUtil.buildInstance(this.m_clazz);
            rpchandler.initialize(((WikiXmlRpcContext)context).getWikiContext());
            Invoker invoker = new Invoker((Object)rpchandler);
            return invoker.execute(method, params);
        }
    }
}

