/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.authorize;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.authorize.WebAuthorizer;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.xpath.XPathFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebContainerAuthorizer
implements WebAuthorizer {
    private static final String J2EE_SCHEMA_25_NAMESPACE = "http://xmlns.jcp.org/xml/ns/javaee";
    private static final Logger LOG = LogManager.getLogger(WebContainerAuthorizer.class);
    protected Engine m_engine;
    protected Role[] m_containerRoles = new Role[0];
    protected boolean m_containerAuthorized;
    private Document m_webxml;

    @Override
    public void initialize(Engine engine, Properties props) {
        this.m_engine = engine;
        this.m_containerAuthorized = false;
        try {
            this.m_webxml = this.getWebXml();
            if (this.m_webxml != null) {
                this.m_webxml.getRootElement().setNamespace(Namespace.getNamespace((String)J2EE_SCHEMA_25_NAMESPACE));
                boolean bl = this.m_containerAuthorized = this.isConstrained("/Delete.jsp", Role.ALL) && this.isConstrained("/Login.jsp", Role.ALL);
            }
            if (this.m_containerAuthorized) {
                this.m_containerRoles = this.getRoles(this.m_webxml);
                LOG.info("JSPWiki is using container-managed authentication.");
            } else {
                LOG.info("JSPWiki is using custom authentication.");
            }
        }
        catch (IOException e) {
            LOG.error("Initialization failed: ", (Throwable)e);
            throw new InternalWikiException(e.getClass().getName() + ": " + e.getMessage(), e);
        }
        catch (JDOMException e) {
            LOG.error("Malformed XML in web.xml", (Throwable)e);
            throw new InternalWikiException(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage(), e);
        }
        if (this.m_containerRoles.length > 0) {
            StringBuilder roles = new StringBuilder();
            for (Role containerRole : this.m_containerRoles) {
                roles.append(containerRole).append(" ");
            }
            LOG.info(" JSPWiki determined the web container manages these roles: " + roles);
        }
        LOG.info("Authorizer WebContainerAuthorizer initialized successfully.");
    }

    @Override
    public boolean isUserInRole(HttpServletRequest request, Principal role) {
        return request.isUserInRole(role.getName());
    }

    @Override
    public boolean isUserInRole(Session session, Principal role) {
        if (session == null || role == null) {
            return false;
        }
        return session.hasPrincipal(role);
    }

    @Override
    public Principal findRole(String role) {
        for (Role containerRole : this.m_containerRoles) {
            if (!containerRole.getName().equals(role)) continue;
            return containerRole;
        }
        return null;
    }

    public boolean isConstrained(String url, Role role) {
        Element root = this.m_webxml.getRootElement();
        Namespace jeeNs = Namespace.getNamespace((String)"j", (String)J2EE_SCHEMA_25_NAMESPACE);
        String constrainsSelector = "//j:web-app/j:security-constraint[j:web-resource-collection/j:url-pattern=\"" + url + "\"]";
        List constraints = XPathFactory.instance().compile(constrainsSelector, Filters.element(), null, new Namespace[]{jeeNs}).evaluate((Object)root);
        String rolesSelector = "//j:web-app/j:security-constraint[j:auth-constraint/j:role-name=\"" + role.getName() + "\"]";
        List roles = XPathFactory.instance().compile(rolesSelector, Filters.element(), null, new Namespace[]{jeeNs}).evaluate((Object)root);
        if (constraints.size() == 0) {
            return false;
        }
        if (role.equals(Role.ALL)) {
            return true;
        }
        if (roles.size() == 0) {
            return false;
        }
        for (Element constraint : constraints) {
            for (Element roleConstraint : roles) {
                if (!constraint.equals((Object)roleConstraint)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContainerAuthorized() {
        return this.m_containerAuthorized;
    }

    @Override
    public Principal[] getRoles() {
        return (Principal[])this.m_containerRoles.clone();
    }

    protected Role[] getRoles(Document webxml) {
        HashSet<Role> roles = new HashSet<Role>();
        Element root = webxml.getRootElement();
        Namespace jeeNs = Namespace.getNamespace((String)"j", (String)J2EE_SCHEMA_25_NAMESPACE);
        String constrainsSelector = "//j:web-app/j:security-constraint/j:auth-constraint/j:role-name";
        List constraints = XPathFactory.instance().compile("//j:web-app/j:security-constraint/j:auth-constraint/j:role-name", Filters.element(), null, new Namespace[]{jeeNs}).evaluate((Object)root);
        for (Element constraint : constraints) {
            String role = constraint.getTextTrim();
            roles.add(new Role(role));
        }
        String rolesSelector = "//j:web-app/j:security-role/j:role-name";
        List nodes = XPathFactory.instance().compile("//j:web-app/j:security-role/j:role-name", Filters.element(), null, new Namespace[]{jeeNs}).evaluate((Object)root);
        for (Element node : nodes) {
            String role = node.getTextTrim();
            roles.add(new Role(role));
        }
        return roles.toArray(new Role[0]);
    }

    protected Document getWebXml() throws JDOMException, IOException {
        URL url;
        SAXBuilder builder = new SAXBuilder();
        builder.setXMLReaderFactory((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        builder.setEntityResolver((EntityResolver)new LocalEntityResolver());
        if (this.m_engine.getServletContext() == null) {
            ClassLoader cl = WebContainerAuthorizer.class.getClassLoader();
            url = cl.getResource("WEB-INF/web.xml");
            if (url != null) {
                LOG.info("Examining {}", (Object)url.toExternalForm());
            }
        } else {
            url = this.m_engine.getServletContext().getResource("/WEB-INF/web.xml");
            if (url != null) {
                LOG.info("Examining " + url.toExternalForm());
            }
        }
        if (url == null) {
            throw new IOException("Unable to find web.xml for processing.");
        }
        LOG.debug("Processing web.xml at {}", (Object)url.toExternalForm());
        Document doc = builder.build(url);
        return doc;
    }

    public class LocalEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            URL url;
            String file = systemId.substring(systemId.lastIndexOf(47) + 1);
            if (WebContainerAuthorizer.this.m_engine.getServletContext() == null) {
                ClassLoader cl = WebContainerAuthorizer.class.getClassLoader();
                url = cl.getResource("WEB-INF/dtd/" + file);
            } else {
                url = WebContainerAuthorizer.this.m_engine.getServletContext().getResource("/WEB-INF/dtd/" + file);
            }
            if (url != null) {
                InputSource is = new InputSource(url.openStream());
                LOG.debug("Resolved systemID={} using local file {}", (Object)systemId, (Object)url);
                return is;
            }
            LOG.info("Please note: There are no local DTD references in /WEB-INF/dtd/{}; falling back to default behaviour. This may mean that the XML parser will attempt to connect to the internet to find the DTD. If you are running JSPWiki locally in an unconnected network, you might want to put the DTD  files in place to avoid nasty UnknownHostExceptions.", (Object)file);
            return null;
        }
    }
}

