/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.permissions;

import java.util.WeakHashMap;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.auth.permissions.PagePermission;

public final class PermissionFactory {
    private static final WeakHashMap<Integer, PagePermission> c_cache = new WeakHashMap();

    private PermissionFactory() {
    }

    public static PagePermission getPagePermission(Page page, String actions) {
        return PermissionFactory.getPagePermission(page.getWiki(), page.getName(), actions);
    }

    public static PagePermission getPagePermission(String page, String actions) {
        return PermissionFactory.getPagePermission("", page, actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PagePermission getPagePermission(String wiki, String page, String actions) {
        PagePermission perm;
        Integer key = wiki.hashCode() ^ page.hashCode() ^ actions.hashCode();
        WeakHashMap<Integer, PagePermission> weakHashMap = c_cache;
        synchronized (weakHashMap) {
            perm = c_cache.get(key);
        }
        if (perm == null) {
            if (!wiki.isEmpty()) {
                page = wiki + ":" + page;
            }
            perm = new PagePermission(page, actions);
            weakHashMap = c_cache;
            synchronized (weakHashMap) {
                c_cache.put(key, perm);
            }
        }
        return perm;
    }
}

