/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.content.PageRenamer;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageRenameEvent;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.search.SearchManager;
import org.apache.wiki.util.TextUtil;

public class DefaultPageRenamer
implements PageRenamer {
    private static final Logger LOG = LogManager.getLogger(DefaultPageRenamer.class);
    private boolean m_camelCase;

    @Override
    public String renamePage(Context context, String renameFrom, String renameTo, boolean changeReferrers) throws WikiException {
        if (renameFrom == null || renameFrom.isEmpty()) {
            throw new WikiException("From name may not be null or empty");
        }
        if (renameTo == null || renameTo.isEmpty()) {
            throw new WikiException("To name may not be null or empty");
        }
        String renameToClean = MarkupParser.cleanLink(renameTo.trim());
        if (renameToClean.equals(renameFrom)) {
            throw new WikiException("You cannot rename the page to itself");
        }
        Engine engine = context.getEngine();
        Page fromPage = ((PageManager)engine.getManager(PageManager.class)).getPage(renameFrom);
        if (fromPage == null) {
            throw new WikiException("No such page " + renameFrom);
        }
        Page toPage = ((PageManager)engine.getManager(PageManager.class)).getPage(renameToClean);
        if (toPage != null) {
            throw new WikiException("Page already exists " + renameToClean);
        }
        Set<String> referrers = this.getReferencesToChange(fromPage, engine);
        List<Attachment> attachmentsOldName = ((AttachmentManager)engine.getManager(AttachmentManager.class)).listAttachments(fromPage);
        for (Attachment att : attachmentsOldName) {
            Page fromAttPage = ((PageManager)engine.getManager(PageManager.class)).getPage(att.getName());
            ((ReferenceManager)engine.getManager(ReferenceManager.class)).pageRemoved(fromAttPage);
        }
        ((PageManager)engine.getManager(PageManager.class)).getProvider().movePage(renameFrom, renameToClean);
        if (((AttachmentManager)engine.getManager(AttachmentManager.class)).attachmentsEnabled()) {
            ((AttachmentManager)engine.getManager(AttachmentManager.class)).getCurrentProvider().moveAttachmentsForPage(renameFrom, renameToClean);
        }
        if ((toPage = ((PageManager)engine.getManager(PageManager.class)).getPage(renameToClean)) == null) {
            throw new ProviderException("Rename seems to have failed for some strange reason - please check logs!");
        }
        toPage.setAttribute("changenote", (Object)(fromPage.getName() + " ==> " + toPage.getName()));
        toPage.setAuthor(context.getCurrentUser().getName());
        ((PageManager)engine.getManager(PageManager.class)).putPageText(toPage, ((PageManager)engine.getManager(PageManager.class)).getPureText(toPage));
        ((ReferenceManager)engine.getManager(ReferenceManager.class)).pageRemoved(fromPage);
        ((ReferenceManager)engine.getManager(ReferenceManager.class)).updateReferences(toPage);
        if (changeReferrers) {
            this.updateReferrers(context, fromPage, toPage, referrers);
        }
        ((SearchManager)engine.getManager(SearchManager.class)).reindexPage(toPage);
        List<Attachment> attachmentsNewName = ((AttachmentManager)engine.getManager(AttachmentManager.class)).listAttachments(toPage);
        for (Attachment att : attachmentsNewName) {
            Page toAttPage = ((PageManager)engine.getManager(PageManager.class)).getPage(att.getName());
            ((ReferenceManager)engine.getManager(ReferenceManager.class)).updateReferences(toAttPage);
            ((SearchManager)engine.getManager(SearchManager.class)).reindexPage((Page)att);
        }
        this.firePageRenameEvent(renameFrom, renameToClean);
        return renameToClean;
    }

    @Override
    public void firePageRenameEvent(String oldName, String newName) {
        if (WikiEventManager.isListening((Object)this)) {
            WikiEventManager.fireEvent((Object)this, (WikiEvent)new WikiPageRenameEvent((Object)this, oldName, newName));
        }
    }

    private void updateReferrers(Context context, Page fromPage, Page toPage, Set<String> referrers) {
        if (referrers.isEmpty()) {
            return;
        }
        Engine engine = context.getEngine();
        for (String pageName : referrers) {
            if (pageName.equals(fromPage.getName())) {
                pageName = toPage.getName();
            }
            Page p = ((PageManager)engine.getManager(PageManager.class)).getPage(pageName);
            String sourceText = ((PageManager)engine.getManager(PageManager.class)).getPureText(p);
            String newText = this.replaceReferrerString(context, sourceText, fromPage.getName(), toPage.getName());
            this.m_camelCase = TextUtil.getBooleanProperty((Properties)engine.getWikiProperties(), (String)"jspwiki.translatorReader.camelCaseLinks", (boolean)this.m_camelCase);
            if (this.m_camelCase) {
                newText = this.replaceCCReferrerString(context, newText, fromPage.getName(), toPage.getName());
            }
            if (sourceText.equals(newText)) continue;
            p.setAttribute("changenote", (Object)(fromPage.getName() + " ==> " + toPage.getName()));
            p.setAuthor(context.getCurrentUser().getName());
            try {
                ((PageManager)engine.getManager(PageManager.class)).putPageText(p, newText);
                ((ReferenceManager)engine.getManager(ReferenceManager.class)).updateReferences(p);
            }
            catch (ProviderException e) {
                LOG.error("Unable to perform rename.", (Throwable)e);
            }
        }
    }

    private Set<String> getReferencesToChange(Page fromPage, Engine engine) {
        TreeSet<String> referrers = new TreeSet<String>();
        Set<String> r = ((ReferenceManager)engine.getManager(ReferenceManager.class)).findReferrers(fromPage.getName());
        if (r != null) {
            referrers.addAll(r);
        }
        try {
            List<Attachment> attachments = ((AttachmentManager)engine.getManager(AttachmentManager.class)).listAttachments(fromPage);
            for (Attachment att : attachments) {
                Set<String> c = ((ReferenceManager)engine.getManager(ReferenceManager.class)).findReferrers(att.getName());
                if (c == null) continue;
                referrers.addAll(c);
            }
        }
        catch (ProviderException e) {
            LOG.error("Provider error while fetching attachments for rename", (Throwable)e);
        }
        return referrers;
    }

    private String replaceCCReferrerString(Context context, String sourceText, String from, String to) {
        StringBuilder sb = new StringBuilder(sourceText.length() + 32);
        Pattern linkPattern = Pattern.compile("\\p{Lu}+\\p{Ll}+\\p{Lu}+[\\p{L}\\p{Digit}]*");
        Matcher matcher = linkPattern.matcher(sourceText);
        int start = 0;
        while (matcher.find(start)) {
            String match = matcher.group();
            sb.append(sourceText, start, matcher.start());
            int lastOpenBrace = sourceText.lastIndexOf(91, matcher.start());
            int lastCloseBrace = sourceText.lastIndexOf(93, matcher.start());
            if (match.equals(from) && lastCloseBrace >= lastOpenBrace) {
                sb.append(to);
            } else {
                sb.append(match);
            }
            start = matcher.end();
        }
        sb.append(sourceText.substring(start));
        return sb.toString();
    }

    private String replaceReferrerString(Context context, String sourceText, String from, String to) {
        StringBuilder sb = new StringBuilder(sourceText.length() + 32);
        Pattern linkPattern = Pattern.compile("([\\[~]?)\\[([^|\\]]*)(\\|)?([^|\\]]*)(\\|)?([^|\\]]*)]");
        Matcher matcher = linkPattern.matcher(sourceText);
        int start = 0;
        while (matcher.find(start)) {
            int charBefore = 65535;
            if (matcher.start() > 0) {
                charBefore = sourceText.charAt(matcher.start() - 1);
            }
            if (!matcher.group(1).isEmpty() || charBefore == 126 || charBefore == 91) {
                sb.append(sourceText, start, matcher.end());
                start = matcher.end();
                continue;
            }
            String text = matcher.group(2);
            String link = matcher.group(4);
            String attr = matcher.group(6);
            if (link.isEmpty()) {
                text = this.replaceSingleLink(context, text, from, to);
            } else {
                link = this.replaceSingleLink(context, link, from, to);
                text = TextUtil.replaceString((String)text, (String)from, (String)to);
            }
            sb.append(sourceText, start, matcher.start());
            sb.append("[").append(text);
            if (!link.isEmpty()) {
                sb.append("|").append(link);
            }
            if (!attr.isEmpty()) {
                sb.append("|").append(attr);
            }
            sb.append("]");
            start = matcher.end();
        }
        sb.append(sourceText.substring(start));
        return sb.toString();
    }

    private String replaceSingleLink(Context context, String original, String from, String newlink) {
        int hash = original.indexOf(35);
        int slash = original.indexOf(47);
        String realLink = original;
        if (hash != -1) {
            realLink = original.substring(0, hash);
        }
        if (slash != -1) {
            realLink = original.substring(0, slash);
        }
        realLink = MarkupParser.cleanLink(realLink);
        String oldStyleRealLink = MarkupParser.wikifyLink(realLink);
        if (realLink.equals(from) || original.equals(from) || oldStyleRealLink.equals(from)) {
            int blank = realLink.indexOf(" ");
            if (blank != -1) {
                return original + "|" + newlink;
            }
            return newlink + (hash > 0 ? original.substring(hash) : "") + (slash > 0 ? original.substring(slash) : "");
        }
        return original;
    }
}

