/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.diff.DiffProvider;
import org.apache.wiki.util.TextUtil;
import org.suigeneris.jrcs.diff.Diff;
import org.suigeneris.jrcs.diff.DiffAlgorithm;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.Revision;
import org.suigeneris.jrcs.diff.RevisionVisitor;
import org.suigeneris.jrcs.diff.delta.AddDelta;
import org.suigeneris.jrcs.diff.delta.ChangeDelta;
import org.suigeneris.jrcs.diff.delta.Chunk;
import org.suigeneris.jrcs.diff.delta.DeleteDelta;
import org.suigeneris.jrcs.diff.delta.Delta;
import org.suigeneris.jrcs.diff.myers.MyersDiff;

public class ContextualDiffProvider
implements DiffProvider {
    private static final Logger LOG = LogManager.getLogger(ContextualDiffProvider.class);
    public static final String PROP_UNCHANGED_CONTEXT_LIMIT = "jspwiki.contextualDiffProvider.unchangedContextLimit";
    public boolean m_emitChangeNextPreviousHyperlinks = true;
    public static String CHANGE_START_HTML = "";
    public static String CHANGE_END_HTML = "";
    public static String DIFF_START = "<div class=\"diff-wikitext\">";
    public static String DIFF_END = "</div>";
    public static String INSERTION_START_HTML = "<font color=\"#8000FF\"><span class=\"diff-insertion\">";
    public static String INSERTION_END_HTML = "</span></font>";
    public static String DELETION_START_HTML = "<strike><font color=\"red\"><span class=\"diff-deletion\">";
    public static String DELETION_END_HTML = "</span></font></strike>";
    private static final String ANCHOR_PRE_INDEX = "<a name=\"change-";
    private static final String ANCHOR_POST_INDEX = "\" />";
    private static final String BACK_PRE_INDEX = "<a class=\"diff-nextprev\" title=\"Go to previous change\" href=\"#change-";
    private static final String BACK_POST_INDEX = "\">&lt;&lt;</a>";
    private static final String FORWARD_PRE_INDEX = "<a class=\"diff-nextprev\" title=\"Go to next change\" href=\"#change-";
    private static final String FORWARD_POST_INDEX = "\">&gt;&gt;</a>";
    public static String ELIDED_HEAD_INDICATOR_HTML = "<br/><br/><b>...</b>";
    public static String ELIDED_TAIL_INDICATOR_HTML = "<b>...</b><br/><br/>";
    public static String LINE_BREAK_HTML = "<br />";
    public static String ALTERNATING_SPACE_HTML = "&nbsp;";
    private static final int LIMIT_MAX_VALUE = 0x3FFFFFFE;
    private int m_unchangedContextLimit = 0x3FFFFFFE;

    public String getProviderInfo() {
        return "ContextualDiffProvider";
    }

    public void initialize(Engine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        String configuredLimit = properties.getProperty(PROP_UNCHANGED_CONTEXT_LIMIT, Integer.toString(0x3FFFFFFE));
        int limit = 0x3FFFFFFE;
        try {
            limit = Integer.parseInt(configuredLimit);
        }
        catch (NumberFormatException e) {
            LOG.warn("Failed to parseInt jspwiki.contextualDiffProvider.unchangedContextLimit=" + configuredLimit + " Will use a huge number as limit.", (Throwable)e);
        }
        this.m_unchangedContextLimit = limit;
    }

    @Override
    public synchronized String makeDiffHtml(Context ctx, String wikiOld, String wikiNew) {
        Revision rev;
        Object[] alpha = this.sequence(TextUtil.replaceEntities((String)wikiOld));
        Object[] beta = this.sequence(TextUtil.replaceEntities((String)wikiNew));
        try {
            rev = Diff.diff((Object[])alpha, (Object[])beta, (DiffAlgorithm)new MyersDiff());
        }
        catch (DifferentiationFailedException dfe) {
            LOG.error("Diff generation failed", (Throwable)dfe);
            return "Error while creating version diff.";
        }
        int revSize = rev.size();
        StringBuffer sb = new StringBuffer();
        sb.append(DIFF_START);
        ChangeMerger cm = new ChangeMerger(sb, (String[])alpha, revSize);
        rev.accept((RevisionVisitor)cm);
        cm.shutdown();
        sb.append(DIFF_END);
        return sb.toString();
    }

    private String[] sequence(String wikiText) {
        String[] linesArray = Diff.stringToArray((String)wikiText);
        ArrayList<String> list = new ArrayList<String>();
        for (String line : linesArray) {
            String lastToken = null;
            StringTokenizer st = new StringTokenizer(line, " ", true);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (" ".equals(lastToken) && " ".equals(token)) {
                    token = ALTERNATING_SPACE_HTML;
                }
                list.add(token);
                lastToken = token;
            }
            list.add(LINE_BREAK_HTML);
        }
        return list.toArray(new String[0]);
    }

    private final class ChangeMerger
    implements RevisionVisitor {
        private final StringBuffer m_sb;
        private final int m_max;
        private int m_index;
        private int m_firstElem;
        private int m_count = 1;
        private int m_mode = -1;
        private StringBuffer m_origBuf;
        private StringBuffer m_newBuf;
        private final String[] m_origStrings;

        private ChangeMerger(StringBuffer sb, String[] origStrings, int max) {
            this.m_sb = sb;
            this.m_origStrings = origStrings != null ? (String[])origStrings.clone() : null;
            this.m_max = max;
            this.m_origBuf = new StringBuffer();
            this.m_newBuf = new StringBuffer();
        }

        private void updateState(Delta delta) {
            ++this.m_index;
            Chunk orig = delta.getOriginal();
            if (orig.first() > this.m_firstElem) {
                this.flushChanges();
                if (orig.first() - this.m_firstElem > 2 * ContextualDiffProvider.this.m_unchangedContextLimit) {
                    int startIndex;
                    int j;
                    if (this.m_firstElem > 0) {
                        int endIndex = Math.min(this.m_firstElem + ContextualDiffProvider.this.m_unchangedContextLimit, this.m_origStrings.length - 1);
                        for (j = this.m_firstElem; j < endIndex; ++j) {
                            this.m_sb.append(this.m_origStrings[j]);
                        }
                        this.m_sb.append(ELIDED_TAIL_INDICATOR_HTML);
                    }
                    this.m_sb.append(ELIDED_HEAD_INDICATOR_HTML);
                    for (j = startIndex = Math.max(orig.first() - ContextualDiffProvider.this.m_unchangedContextLimit, 0); j < orig.first(); ++j) {
                        this.m_sb.append(this.m_origStrings[j]);
                    }
                } else {
                    for (int j = this.m_firstElem; j < orig.first(); ++j) {
                        this.m_sb.append(this.m_origStrings[j]);
                    }
                }
            }
            this.m_firstElem = orig.last() + 1;
        }

        public void visit(Revision rev) {
        }

        public void visit(AddDelta delta) {
            this.updateState((Delta)delta);
            if (this.m_mode == 1) {
                this.flushChanges();
                this.m_mode = -1;
            }
            if (this.m_mode == -1) {
                this.m_mode = 0;
            }
            if (this.m_mode == 0 || this.m_mode == 2) {
                this.addNew(delta.getRevised());
                this.m_mode = 1;
            }
        }

        public void visit(ChangeDelta delta) {
            this.updateState((Delta)delta);
            if (this.m_mode == -1) {
                this.m_mode = 2;
            }
            this.addOrig(delta.getOriginal());
            this.addNew(delta.getRevised());
        }

        public void visit(DeleteDelta delta) {
            this.updateState((Delta)delta);
            if (this.m_mode == 0) {
                this.flushChanges();
                this.m_mode = -1;
            }
            if (this.m_mode == -1) {
                this.m_mode = 1;
            }
            if (this.m_mode == 1 || this.m_mode == 2) {
                this.addOrig(delta.getOriginal());
                this.m_mode = 1;
            }
        }

        public void shutdown() {
            this.m_index = this.m_max + 1;
            this.flushChanges();
            if (this.m_firstElem < this.m_origStrings.length) {
                if (this.m_origStrings.length - this.m_firstElem > ContextualDiffProvider.this.m_unchangedContextLimit) {
                    int endIndex = Math.min(this.m_firstElem + ContextualDiffProvider.this.m_unchangedContextLimit, this.m_origStrings.length - 1);
                    for (int j = this.m_firstElem; j < endIndex; ++j) {
                        this.m_sb.append(this.m_origStrings[j]);
                    }
                    this.m_sb.append(ELIDED_TAIL_INDICATOR_HTML);
                } else {
                    for (int j = this.m_firstElem; j < this.m_origStrings.length; ++j) {
                        this.m_sb.append(this.m_origStrings[j]);
                    }
                }
            }
        }

        private void addOrig(Chunk chunk) {
            if (chunk != null) {
                chunk.toString(this.m_origBuf);
            }
        }

        private void addNew(Chunk chunk) {
            if (chunk != null) {
                chunk.toString(this.m_newBuf);
            }
        }

        private void flushChanges() {
            if (this.m_newBuf.length() + this.m_origBuf.length() > 0) {
                this.m_sb.append(CHANGE_START_HTML);
                if (ContextualDiffProvider.this.m_emitChangeNextPreviousHyperlinks && this.m_count > 1) {
                    this.m_sb.append(ContextualDiffProvider.BACK_PRE_INDEX);
                    this.m_sb.append(this.m_count - 1);
                    this.m_sb.append(ContextualDiffProvider.BACK_POST_INDEX);
                }
                if (ContextualDiffProvider.this.m_emitChangeNextPreviousHyperlinks) {
                    this.m_sb.append(ContextualDiffProvider.ANCHOR_PRE_INDEX);
                    this.m_sb.append(this.m_count++);
                    this.m_sb.append(ContextualDiffProvider.ANCHOR_POST_INDEX);
                }
                if (this.m_newBuf.length() > 0) {
                    this.m_sb.append(INSERTION_START_HTML);
                    this.m_sb.append(this.m_newBuf);
                    this.m_sb.append(INSERTION_END_HTML);
                }
                if (this.m_origBuf.length() > 0) {
                    this.m_sb.append(DELETION_START_HTML);
                    this.m_sb.append(this.m_origBuf);
                    this.m_sb.append(DELETION_END_HTML);
                }
                if (ContextualDiffProvider.this.m_emitChangeNextPreviousHyperlinks && this.m_index < this.m_max) {
                    this.m_sb.append(ContextualDiffProvider.FORWARD_PRE_INDEX);
                    this.m_sb.append(this.m_count);
                    this.m_sb.append(ContextualDiffProvider.FORWARD_POST_INDEX);
                }
                this.m_sb.append(CHANGE_END_HTML);
                this.m_origBuf = new StringBuffer();
                this.m_newBuf = new StringBuffer();
            }
            this.m_mode = -1;
        }
    }
}

