/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.providers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.providers.AttachmentProvider;
import org.apache.wiki.api.search.QueryItem;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.pages.PageTimeComparator;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.TextUtil;

public class BasicAttachmentProvider
implements AttachmentProvider {
    private Engine m_engine;
    private String m_storageDir;
    private Pattern m_disableCache;
    public static final String PROP_DISABLECACHE = "jspwiki.basicAttachmentProvider.disableCache";
    public static final String PROPERTY_FILE = "attachment.properties";
    public static final String DIR_EXTENSION = "-att";
    public static final String ATTDIR_EXTENSION = "-dir";
    private static final Logger LOG = LogManager.getLogger(BasicAttachmentProvider.class);

    public void initialize(Engine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        File f;
        this.m_engine = engine;
        this.m_storageDir = TextUtil.getCanonicalFilePathProperty((Properties)properties, (String)"jspwiki.basicAttachmentProvider.storageDir", (String)(System.getProperty("user.home") + File.separator + "jspwiki-files"));
        String patternString = engine.getWikiProperties().getProperty(PROP_DISABLECACHE);
        if (patternString != null) {
            this.m_disableCache = Pattern.compile(patternString);
        }
        if (!(f = new File(this.m_storageDir)).exists()) {
            f.mkdirs();
        }
        if (!f.exists()) {
            throw new IOException("Could not find or create attachment storage directory '" + this.m_storageDir + "'");
        }
        if (!f.canWrite()) {
            throw new IOException("Cannot write to the attachment storage directory '" + this.m_storageDir + "'");
        }
        if (!f.isDirectory()) {
            throw new IOException("Your attachment storage points to a file, not a directory: '" + this.m_storageDir + "'");
        }
    }

    private File findPageDir(String wikipage) throws ProviderException {
        File f = new File(this.m_storageDir, (wikipage = BasicAttachmentProvider.mangleName(wikipage)) + DIR_EXTENSION);
        if (f.exists() && !f.isDirectory()) {
            throw new ProviderException("Storage dir '" + f.getAbsolutePath() + "' is not a directory!");
        }
        return f;
    }

    private static String mangleName(String wikiname) {
        return TextUtil.urlEncodeUTF8((String)wikiname);
    }

    private static String unmangleName(String filename) {
        return TextUtil.urlDecodeUTF8((String)filename);
    }

    private File findAttachmentDir(org.apache.wiki.api.core.Attachment att) throws ProviderException {
        File f = new File(this.findPageDir(att.getParentName()), BasicAttachmentProvider.mangleName(att.getFileName() + ATTDIR_EXTENSION));
        if (!f.exists()) {
            File oldf = new File(this.findPageDir(att.getParentName()), BasicAttachmentProvider.mangleName(att.getFileName()));
            if (oldf.exists()) {
                f = oldf;
            } else {
                oldf = new File(this.findPageDir(att.getParentName()), att.getFileName());
                if (oldf.exists()) {
                    f = oldf;
                }
            }
        }
        return f;
    }

    private int findLatestVersion(org.apache.wiki.api.core.Attachment att) throws ProviderException {
        File attDir = this.findAttachmentDir(att);
        String[] pages = attDir.list(new AttachmentVersionFilter());
        if (pages == null) {
            return 0;
        }
        int version = 0;
        for (String page : pages) {
            int cutpoint = page.indexOf(46);
            String pageNum = cutpoint > 0 ? page.substring(0, cutpoint) : page;
            try {
                int res = Integer.parseInt(pageNum);
                if (res <= version) continue;
                version = res;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return version;
    }

    protected static String getFileExtension(String filename) {
        String fileExt = "bin";
        int dot = filename.lastIndexOf(46);
        if (dot >= 0 && dot < filename.length() - 1) {
            fileExt = BasicAttachmentProvider.mangleName(filename.substring(dot + 1));
        }
        return fileExt;
    }

    private void putPageProperties(org.apache.wiki.api.core.Attachment att, Properties properties) throws IOException, ProviderException {
        File attDir = this.findAttachmentDir(att);
        File propertyFile = new File(attDir, PROPERTY_FILE);
        try (OutputStream out = Files.newOutputStream(propertyFile.toPath(), new OpenOption[0]);){
            properties.store(out, " JSPWiki page properties for " + att.getName() + ". DO NOT MODIFY!");
        }
    }

    private Properties getPageProperties(org.apache.wiki.api.core.Attachment att) throws IOException, ProviderException {
        Properties props = new Properties();
        File propertyFile = new File(this.findAttachmentDir(att), PROPERTY_FILE);
        if (propertyFile.exists()) {
            try (InputStream in = Files.newInputStream(propertyFile.toPath(), new OpenOption[0]);){
                props.load(in);
            }
        }
        return props;
    }

    public void putAttachmentData(org.apache.wiki.api.core.Attachment att, InputStream data) throws ProviderException, IOException {
        File attDir = this.findAttachmentDir(att);
        if (!attDir.exists()) {
            attDir.mkdirs();
        }
        int latestVersion = this.findLatestVersion(att);
        int versionNumber = latestVersion + 1;
        File newfile = new File(attDir, versionNumber + "." + BasicAttachmentProvider.getFileExtension(att.getFileName()));
        try (OutputStream out = Files.newOutputStream(newfile.toPath(), new OpenOption[0]);){
            LOG.info("Uploading attachment " + att.getFileName() + " to page " + att.getParentName());
            LOG.info("Saving attachment contents to " + newfile.getAbsolutePath());
            FileUtil.copyContents((InputStream)data, (OutputStream)out);
            Properties props = this.getPageProperties(att);
            String author = att.getAuthor();
            if (author == null) {
                author = "unknown";
            }
            props.setProperty(versionNumber + ".author", author);
            String changeNote = (String)att.getAttribute("changenote");
            if (changeNote != null) {
                props.setProperty(versionNumber + ".changenote", changeNote);
            }
            this.putPageProperties(att, props);
        }
        catch (IOException e) {
            LOG.error("Could not save attachment data: ", (Throwable)e);
            throw (IOException)e.fillInStackTrace();
        }
    }

    public String getProviderInfo() {
        return "";
    }

    private File findFile(File dir, org.apache.wiki.api.core.Attachment att) throws FileNotFoundException, ProviderException {
        int version = att.getVersion();
        if (version == -1) {
            version = this.findLatestVersion(att);
        }
        String ext = BasicAttachmentProvider.getFileExtension(att.getFileName());
        File f = new File(dir, version + "." + ext);
        if (!f.exists()) {
            File fOld;
            if ("bin".equals(ext) && (fOld = new File(dir, version + ".")).exists()) {
                f = fOld;
            }
            if (!f.exists()) {
                throw new FileNotFoundException("No such file: " + f.getAbsolutePath() + " exists.");
            }
        }
        return f;
    }

    public InputStream getAttachmentData(org.apache.wiki.api.core.Attachment att) throws IOException, ProviderException {
        File attDir = this.findAttachmentDir(att);
        try {
            File f = this.findFile(attDir, att);
            return Files.newInputStream(f.toPath(), new OpenOption[0]);
        }
        catch (FileNotFoundException e) {
            LOG.error("File not found: " + e.getMessage());
            throw new ProviderException("No such page was found.");
        }
    }

    public List<org.apache.wiki.api.core.Attachment> listAttachments(Page page) throws ProviderException {
        ArrayList<org.apache.wiki.api.core.Attachment> result = new ArrayList<org.apache.wiki.api.core.Attachment>();
        File dir = this.findPageDir(page.getName());
        String[] attachments = dir.list();
        if (attachments != null) {
            for (String attachment : attachments) {
                File f = new File(dir, attachment);
                if (!f.isDirectory()) continue;
                String attachmentName = BasicAttachmentProvider.unmangleName(attachment);
                if (attachmentName.endsWith(ATTDIR_EXTENSION)) {
                    attachmentName = attachmentName.substring(0, attachmentName.length() - ATTDIR_EXTENSION.length());
                } else {
                    File propFile = new File(f, PROPERTY_FILE);
                    if (!propFile.exists()) continue;
                }
                org.apache.wiki.api.core.Attachment att = this.getAttachmentInfo(page, attachmentName, -1);
                if (att == null) {
                    throw new ProviderException("Attachment disappeared while reading information: if you did not touch the repository, there is a serious bug somewhere. Attachment = " + attachment + ", decoded = " + attachmentName);
                }
                result.add(att);
            }
        }
        return result;
    }

    public Collection<org.apache.wiki.api.core.Attachment> findAttachments(QueryItem[] query) {
        return new ArrayList<org.apache.wiki.api.core.Attachment>();
    }

    public List<org.apache.wiki.api.core.Attachment> listAllChanged(Date timestamp) throws ProviderException {
        File attDir = new File(this.m_storageDir);
        if (!attDir.exists()) {
            throw new ProviderException("Specified attachment directory " + this.m_storageDir + " does not exist!");
        }
        ArrayList<org.apache.wiki.api.core.Attachment> list = new ArrayList<org.apache.wiki.api.core.Attachment>();
        String[] pagesWithAttachments = attDir.list(new AttachmentFilter());
        if (pagesWithAttachments != null) {
            for (String pagesWithAttachment : pagesWithAttachments) {
                String pageId = BasicAttachmentProvider.unmangleName(pagesWithAttachment);
                pageId = pageId.substring(0, pageId.length() - DIR_EXTENSION.length());
                List<org.apache.wiki.api.core.Attachment> c = this.listAttachments(Wiki.contents().page(this.m_engine, pageId));
                for (org.apache.wiki.api.core.Attachment att : c) {
                    if (!att.getLastModified().after(timestamp)) continue;
                    list.add(att);
                }
            }
        }
        list.sort(new PageTimeComparator());
        return list;
    }

    public org.apache.wiki.api.core.Attachment getAttachmentInfo(Page page, String name, int version) throws ProviderException {
        Matcher matcher;
        Attachment att = new Attachment(this.m_engine, page.getName(), name);
        File dir = this.findAttachmentDir(att);
        if (!dir.exists()) {
            return null;
        }
        if (version == -1) {
            version = this.findLatestVersion(att);
        }
        att.setVersion(version);
        if (this.m_disableCache != null && (matcher = this.m_disableCache.matcher(name)).matches()) {
            att.setCacheable(false);
        }
        try {
            Properties props = this.getPageProperties(att);
            att.setAuthor(props.getProperty(version + ".author"));
            String changeNote = props.getProperty(version + ".changenote");
            if (changeNote != null) {
                att.setAttribute("changenote", changeNote);
            }
            File f = this.findFile(dir, att);
            att.setSize(f.length());
            att.setLastModified(new Date(f.lastModified()));
        }
        catch (FileNotFoundException e) {
            LOG.error("Can't get attachment properties for " + att, (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.error("Can't read page properties", (Throwable)e);
            throw new ProviderException("Cannot read page properties: " + e.getMessage());
        }
        return att;
    }

    public List<org.apache.wiki.api.core.Attachment> getVersionHistory(org.apache.wiki.api.core.Attachment att) {
        ArrayList<org.apache.wiki.api.core.Attachment> list = new ArrayList<org.apache.wiki.api.core.Attachment>();
        try {
            int latest;
            for (int i = latest = this.findLatestVersion(att); i >= 1; --i) {
                org.apache.wiki.api.core.Attachment a = this.getAttachmentInfo(Wiki.contents().page(this.m_engine, att.getParentName()), att.getFileName(), i);
                if (a == null) continue;
                list.add(a);
            }
        }
        catch (ProviderException e) {
            LOG.error("Getting version history failed for page: " + att, (Throwable)e);
        }
        return list;
    }

    public void deleteVersion(org.apache.wiki.api.core.Attachment att) throws ProviderException {
    }

    public void deleteAttachment(org.apache.wiki.api.core.Attachment att) throws ProviderException {
        String[] files;
        File dir = this.findAttachmentDir(att);
        for (String s : files = dir.list()) {
            File file = new File(dir.getAbsolutePath() + "/" + s);
            file.delete();
        }
        dir.delete();
    }

    public void moveAttachmentsForPage(String oldParent, String newParent) throws ProviderException {
        File srcDir = this.findPageDir(oldParent);
        File destDir = this.findPageDir(newParent);
        LOG.debug("Trying to move all attachments from " + srcDir + " to " + destDir);
        if (destDir.exists()) {
            LOG.error("Page rename failed because target directory " + destDir + " exists");
        } else {
            srcDir.renameTo(destDir);
        }
    }

    public static class AttachmentVersionFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return !name.equals(BasicAttachmentProvider.PROPERTY_FILE);
        }
    }

    public static class AttachmentFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(BasicAttachmentProvider.DIR_EXTENSION);
        }
    }
}

