/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.parser.LinkParsingOperations;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.tags.ParamHandler;
import org.apache.wiki.tags.WikiLinkTag;
import org.apache.wiki.util.TextUtil;

public class LinkTag
extends WikiLinkTag
implements ParamHandler,
BodyTag {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LogManager.getLogger(LinkTag.class);
    private String m_version;
    private String m_cssClass;
    private String m_style;
    private String m_title;
    private String m_target;
    private String m_compareToVersion;
    private String m_rel;
    private String m_jsp;
    private String m_ref;
    private String m_context = ContextEnum.PAGE_VIEW.getRequestContext();
    private String m_accesskey;
    private String m_tabindex;
    private String m_templatefile;
    private Map<String, String> m_containedParams;
    private BodyContent m_bodyContent;

    @Override
    public void initTag() {
        super.initTag();
        this.m_templatefile = null;
        this.m_accesskey = null;
        this.m_ref = null;
        this.m_jsp = null;
        this.m_rel = null;
        this.m_compareToVersion = null;
        this.m_target = null;
        this.m_title = null;
        this.m_style = null;
        this.m_cssClass = null;
        this.m_version = null;
        this.m_context = ContextEnum.PAGE_VIEW.getRequestContext();
        this.m_containedParams = new HashMap<String, String>();
    }

    public void setTemplatefile(String key) {
        this.m_templatefile = key;
    }

    public void setAccessKey(String key) {
        this.m_accesskey = key;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String arg) {
        this.m_version = arg;
    }

    public void setCssClass(String arg) {
        this.m_cssClass = arg;
    }

    public void setStyle(String style) {
        this.m_style = style;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    public void setTabindex(String tabindex) {
        this.m_tabindex = tabindex;
    }

    public void setCompareToVersion(String ver) {
        this.m_compareToVersion = ver;
    }

    public void setRel(String rel) {
        this.m_rel = rel;
    }

    public void setRef(String ref) {
        this.m_ref = ref;
    }

    public void setJsp(String jsp) {
        this.m_jsp = jsp;
    }

    public void setContext(String context) {
        this.m_context = context;
    }

    @Override
    public void setContainedParameter(String name, String value) {
        if (name != null) {
            if (this.m_containedParams == null) {
                this.m_containedParams = new HashMap<String, String>();
            }
            this.m_containedParams.put(name, value);
        }
    }

    private String figureOutURL() throws ProviderException {
        String params;
        Object page;
        String url = null;
        Engine engine = this.m_wikiContext.getEngine();
        if (this.m_pageName == null && (page = this.m_wikiContext.getPage()) != null) {
            this.m_pageName = page.getName();
        }
        if (this.m_templatefile != null) {
            params = this.addParamsForRecipient(null, this.m_containedParams);
            String template = engine.getTemplateDir();
            url = engine.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "templates/" + template + "/" + this.m_templatefile, params);
        } else if (this.m_jsp != null) {
            params = this.addParamsForRecipient(null, this.m_containedParams);
            url = engine.getURL(ContextEnum.PAGE_NONE.getRequestContext(), this.m_jsp, params);
        } else if (this.m_ref != null) {
            if (new LinkParsingOperations(this.m_wikiContext).isExternalLink(this.m_ref)) {
                url = this.m_ref;
            } else {
                int interwikipoint = this.m_ref.indexOf(":");
                if (interwikipoint != -1) {
                    String extWiki = this.m_ref.substring(0, interwikipoint);
                    String wikiPage = this.m_ref.substring(interwikipoint + 1);
                    url = engine.getInterWikiURL(extWiki);
                    if (url != null) {
                        url = TextUtil.replaceString((String)url, (String)"%s", (String)wikiPage);
                    }
                } else if (!this.m_ref.startsWith("#") && !TextUtil.isNumber((String)this.m_ref)) {
                    String parms = this.m_version != null ? "version=" + this.getVersion() : null;
                    Page p = ((PageManager)engine.getManager(PageManager.class)).getPage(this.m_pageName);
                    if (p instanceof Attachment) {
                        url = this.m_wikiContext.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), this.m_pageName);
                    } else {
                        int hashMark = this.m_ref.indexOf(35);
                        if (hashMark != -1) {
                            String namedSection = this.m_ref.substring(hashMark + 1);
                            String reallink = this.m_ref.substring(0, hashMark);
                            reallink = MarkupParser.cleanLink(reallink);
                            String sectref = "";
                            String matchedLink = engine.getFinalPageName(reallink);
                            if (matchedLink != null) {
                                sectref = "section-" + engine.encodeName(matchedLink) + "-" + namedSection;
                                sectref = "#" + sectref.replace('%', '_');
                            } else {
                                matchedLink = reallink;
                            }
                            url = this.makeBasicURL(this.m_context, matchedLink, parms) + sectref;
                        } else {
                            String reallink = MarkupParser.cleanLink(this.m_ref);
                            url = this.makeBasicURL(this.m_context, reallink, parms);
                        }
                    }
                }
            }
        } else if (this.m_pageName != null && !this.m_pageName.isEmpty()) {
            Page p = ((PageManager)engine.getManager(PageManager.class)).getPage(this.m_pageName);
            String parms = this.m_version != null ? "version=" + this.getVersion() : null;
            parms = this.addParamsForRecipient(parms, this.m_containedParams);
            if (p instanceof Attachment) {
                String ctx = this.m_context;
                if (this.m_context == null || this.m_context.equals(ContextEnum.PAGE_VIEW.getRequestContext())) {
                    ctx = ContextEnum.PAGE_ATTACH.getRequestContext();
                }
                url = engine.getURL(ctx, this.m_pageName, parms);
            } else {
                url = this.makeBasicURL(this.m_context, this.m_pageName, parms);
            }
        } else {
            page = engine.getFrontPage();
            url = this.makeBasicURL(this.m_context, (String)page, null);
        }
        return url;
    }

    private String addParamsForRecipient(String addTo, Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return addTo;
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            String n = e.getKey();
            String v = e.getValue();
            buf.append(n);
            buf.append("=");
            buf.append(v);
            if (!it.hasNext()) continue;
            buf.append("&amp;");
        }
        if (addTo == null) {
            return buf.toString();
        }
        if (!addTo.endsWith("&amp;")) {
            return addTo + "&amp;" + buf;
        }
        return addTo + buf;
    }

    private String makeBasicURL(String context, String page, String parms) {
        Engine engine = this.m_wikiContext.getEngine();
        if (context.equals(ContextEnum.PAGE_DIFF.getRequestContext())) {
            int r2;
            int r1;
            Page latest;
            if ("latest".equals(this.getVersion())) {
                latest = ((PageManager)engine.getManager(PageManager.class)).getPage(page, -1);
                r1 = latest.getVersion();
            } else if ("previous".equals(this.getVersion())) {
                r1 = this.m_wikiContext.getPage().getVersion() - 1;
                r1 = Math.max(r1, 1);
            } else {
                r1 = "current".equals(this.getVersion()) ? this.m_wikiContext.getPage().getVersion() : Integer.parseInt(this.getVersion());
            }
            if ("latest".equals(this.m_compareToVersion)) {
                latest = ((PageManager)engine.getManager(PageManager.class)).getPage(page, -1);
                r2 = latest.getVersion();
            } else if ("previous".equals(this.m_compareToVersion)) {
                r2 = this.m_wikiContext.getPage().getVersion() - 1;
                r2 = Math.max(r2, 1);
            } else {
                r2 = "current".equals(this.m_compareToVersion) ? this.m_wikiContext.getPage().getVersion() : Integer.parseInt(this.m_compareToVersion);
            }
            parms = "r1=" + r1 + "&amp;r2=" + r2;
        }
        return engine.getURL(this.m_context, this.m_pageName, parms);
    }

    @Override
    public int doWikiStartTag() throws Exception {
        return 2;
    }

    @Override
    public int doEndTag() {
        try {
            Engine engine = this.m_wikiContext.getEngine();
            JspWriter out = this.pageContext.getOut();
            String url = this.figureOutURL();
            StringBuilder sb = new StringBuilder(20);
            sb.append(this.m_cssClass != null ? "class=\"" + this.m_cssClass + "\" " : "");
            sb.append(this.m_style != null ? "style=\"" + this.m_style + "\" " : "");
            sb.append(this.m_target != null ? "target=\"" + this.m_target + "\" " : "");
            sb.append(this.m_title != null ? "title=\"" + this.m_title + "\" " : "");
            sb.append(this.m_rel != null ? "rel=\"" + this.m_rel + "\" " : "");
            sb.append(this.m_accesskey != null ? "accesskey=\"" + this.m_accesskey + "\" " : "");
            sb.append(this.m_tabindex != null ? "tabindex=\"" + this.m_tabindex + "\" " : "");
            if (((PageManager)engine.getManager(PageManager.class)).getPage(this.m_pageName) instanceof Attachment) {
                sb.append(((AttachmentManager)engine.getManager(AttachmentManager.class)).forceDownload(this.m_pageName) ? "download " : "");
            }
            switch (this.m_format) {
                case 1: {
                    out.print(url);
                    break;
                }
                default: {
                    out.print("<a " + sb + " href=\"" + url + "\">");
                }
            }
            if (this.m_bodyContent != null) {
                String linktext = this.m_bodyContent.getString().trim();
                out.write(linktext);
            }
            if (this.m_format == 0) {
                out.print("</a>");
            }
        }
        catch (Exception e) {
            LOG.error("Tag failed", (Throwable)e);
        }
        return 6;
    }

    public void setBodyContent(BodyContent bc) {
        this.m_bodyContent = bc;
    }

    public void doInitBody() {
    }
}

