/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.api.Release;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.engine.Initializable;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.acl.AclManager;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.cache.CachingManager;
import org.apache.wiki.content.PageRenamer;
import org.apache.wiki.diff.DifferenceManager;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.plugin.PluginManager;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.rss.RSSGenerator;
import org.apache.wiki.search.SearchManager;
import org.apache.wiki.tasks.TasksManager;
import org.apache.wiki.ui.CommandResolver;
import org.apache.wiki.ui.EditorManager;
import org.apache.wiki.ui.TemplateManager;
import org.apache.wiki.ui.admin.AdminBeanManager;
import org.apache.wiki.ui.progress.ProgressManager;
import org.apache.wiki.url.URLConstructor;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.PropertyReader;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.variables.VariableManager;
import org.apache.wiki.workflow.WorkflowManager;

public class WikiEngine
implements Engine {
    private static final String ATTR_WIKIENGINE = "org.apache.wiki.WikiEngine";
    private static final Logger LOG = LogManager.getLogger(WikiEngine.class);
    private Properties m_properties;
    private boolean m_saveUserInfo = true;
    private boolean m_useUTF8 = true;
    private String m_rootPath = System.getProperty("user.dir");
    private ServletContext m_servletContext;
    private String m_templateDir;
    private String m_frontPage;
    private Date m_startTime;
    private String m_workDir;
    private String m_appid = "";
    private boolean m_isConfigured;
    private final Map<String, Object> m_attributes = new ConcurrentHashMap<String, Object>();
    protected final Map<Class<?>, Object> managers = new ConcurrentHashMap();

    public static synchronized WikiEngine getInstance(ServletConfig config) throws InternalWikiException {
        return WikiEngine.getInstance(config.getServletContext(), null);
    }

    public static synchronized WikiEngine getInstance(ServletConfig config, Properties props) {
        return WikiEngine.getInstance(config.getServletContext(), props);
    }

    public static synchronized WikiEngine getInstance(ServletContext context, Properties props) throws InternalWikiException {
        WikiEngine engine = (WikiEngine)context.getAttribute(ATTR_WIKIENGINE);
        if (engine == null) {
            String appid = Integer.toString(context.hashCode());
            context.log(" Assigning new engine to " + appid);
            try {
                if (props == null) {
                    props = PropertyReader.loadWebAppProps((ServletContext)context);
                }
                engine = new WikiEngine(context, appid);
                try {
                    engine.start(props);
                    LOG.info("Root path for this Wiki is: '{}'", (Object)engine.getRootPath());
                }
                catch (Exception e) {
                    String msg = "JSPWiki: Unable to load and setup properties from jspwiki.properties. " + e.getMessage();
                    context.log(msg);
                    LOG.error(msg, (Throwable)e);
                    throw new WikiException(msg, (Throwable)e);
                }
                context.setAttribute(ATTR_WIKIENGINE, (Object)engine);
            }
            catch (Exception e) {
                context.log("ERROR: Failed to create a Wiki engine: " + e.getMessage());
                LOG.error("ERROR: Failed to create a Wiki engine, stacktrace follows ", (Throwable)e);
                throw new InternalWikiException("No wiki engine, check logs.", e);
            }
        }
        return engine;
    }

    public WikiEngine(Properties properties) throws WikiException {
        this.start(properties);
    }

    protected WikiEngine(ServletContext context, String appid) throws WikiException {
        this.m_servletContext = context;
        this.m_appid = appid;
        if (context != null) {
            context.setAttribute(ATTR_WIKIENGINE, (Object)this);
            this.m_rootPath = context.getRealPath("/");
        }
    }

    public void initialize(Properties props) throws WikiException {
        this.m_startTime = new Date();
        this.m_properties = props;
        LOG.info("*******************************************");
        LOG.info("{} {} starting. Whee!", (Object)"JSPWiki", (Object)Release.getVersionString());
        LOG.debug("Java version: {}", (Object)System.getProperty("java.runtime.version"));
        LOG.debug("Java vendor: {}", (Object)System.getProperty("java.vm.vendor"));
        LOG.debug("OS: {} {} {}", (Object)System.getProperty("os.name"), (Object)System.getProperty("os.version"), (Object)System.getProperty("os.arch"));
        LOG.debug("Default server locale: {}", (Object)Locale.getDefault());
        LOG.debug("Default server timezone: {}", (Object)TimeZone.getDefault().getDisplayName(true, 1));
        if (this.m_servletContext != null) {
            LOG.info("Servlet container: {}", (Object)this.m_servletContext.getServerInfo());
            if (this.m_servletContext.getMajorVersion() < 3 || this.m_servletContext.getMajorVersion() == 3 && this.m_servletContext.getMinorVersion() < 1) {
                throw new InternalWikiException("JSPWiki requires a container which supports at least version 3.1 of Servlet specification");
            }
        }
        this.fireEvent(-1);
        LOG.debug("Configuring WikiEngine...");
        this.createAndFindWorkingDirectory(props);
        this.m_useUTF8 = StandardCharsets.UTF_8.name().equals(TextUtil.getStringProperty((Properties)props, (String)"jspwiki.encoding", (String)StandardCharsets.ISO_8859_1.name()));
        this.m_saveUserInfo = TextUtil.getBooleanProperty((Properties)props, (String)"jspwiki.storeUserName", (boolean)this.m_saveUserInfo);
        this.m_frontPage = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.frontPage", (String)"Main");
        this.m_templateDir = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.templateDir", (String)"default");
        this.enforceValidTemplateDirectory();
        try {
            String aclClassName = this.m_properties.getProperty("jspwiki.aclManager", ClassUtil.getMappedClass((String)AclManager.class.getName()).getName());
            String urlConstructorClassName = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.urlConstructor", (String)"DefaultURLConstructor");
            Class urlclass = ClassUtil.findClass((String)"org.apache.wiki.url", (String)urlConstructorClassName);
            this.initComponent(CommandResolver.class, this, props);
            this.initComponent(urlclass.getName(), URLConstructor.class, new Object[0]);
            this.initComponent(CachingManager.class, this, props);
            this.initComponent(PageManager.class, this, props);
            this.initComponent(PluginManager.class, this, props);
            this.initComponent(DifferenceManager.class, this, props);
            this.initComponent(AttachmentManager.class, this, props);
            this.initComponent(VariableManager.class, props);
            this.initComponent(SearchManager.class, this, props);
            this.initComponent(AuthenticationManager.class, new Object[0]);
            this.initComponent(AuthorizationManager.class, new Object[0]);
            this.initComponent(UserManager.class, new Object[0]);
            this.initComponent(GroupManager.class, new Object[0]);
            this.initComponent(EditorManager.class, this);
            this.initComponent(ProgressManager.class, this);
            this.initComponent(aclClassName, AclManager.class, new Object[0]);
            this.initComponent(WorkflowManager.class, new Object[0]);
            this.initComponent(TasksManager.class, new Object[0]);
            this.initComponent(InternationalizationManager.class, this);
            this.initComponent(TemplateManager.class, this, props);
            this.initComponent(FilterManager.class, this, props);
            this.initComponent(AdminBeanManager.class, this);
            this.initComponent(PageRenamer.class, this, props);
            this.initComponent(RenderingManager.class, new Object[0]);
            this.initReferenceManager();
            this.getManager(FilterManager.class).addPageFilter(this.getManager(ReferenceManager.class), -1001);
            this.getManager(FilterManager.class).addPageFilter(this.getManager(SearchManager.class), -1002);
        }
        catch (RuntimeException e) {
            LOG.fatal("Failed to start managers.", (Throwable)e);
            throw new WikiException("Failed to start managers: " + e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.fatal("JSPWiki could not start, URLConstructor was not found: {}", (Object)e.getMessage(), (Object)e);
            throw new WikiException(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.fatal("JSPWiki could not start, URLConstructor could not be instantiated: {}", (Object)e.getMessage(), (Object)e);
            throw new WikiException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.fatal("JSPWiki could not start, URLConstructor cannot be accessed: {}", (Object)e.getMessage(), (Object)e);
            throw new WikiException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.fatal("JSPWiki could not start, due to an unknown exception when starting.", (Throwable)e);
            throw new WikiException("Failed to start. Caused by: " + e.getMessage() + "; please check log files for better information.", (Throwable)e);
        }
        try {
            if (TextUtil.getBooleanProperty((Properties)props, (String)"jspwiki.rss.generate", (boolean)false)) {
                this.initComponent(RSSGenerator.class, this, props);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to start RSS generator - JSPWiki will still work, but there will be no RSS feed.", (Throwable)e);
        }
        Map extraComponents = ClassUtil.getExtraClassMappings();
        this.initExtraComponents(extraComponents);
        this.fireEvent(0);
        LOG.info("WikiEngine configured.");
        this.m_isConfigured = true;
    }

    void createAndFindWorkingDirectory(Properties props) throws WikiException {
        this.m_workDir = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.workDir", null);
        if (StringUtils.isBlank((CharSequence)this.m_workDir)) {
            this.m_workDir = System.getProperty("java.io.tmpdir", ".") + File.separator + "JSPWiki-" + this.m_appid;
        }
        File f = new File(this.m_workDir);
        try {
            f.mkdirs();
        }
        catch (SecurityException e) {
            LOG.fatal("Unable to find or create the working directory: {}", (Object)this.m_workDir, (Object)e);
            throw new WikiException("Unable to find or create the working dir: " + this.m_workDir, (Throwable)e);
        }
        this.checkWorkingDirectory(!f.exists(), "Work directory does not exist: " + this.m_workDir);
        this.checkWorkingDirectory(!f.canRead(), "No permission to read work directory: " + this.m_workDir);
        this.checkWorkingDirectory(!f.canWrite(), "No permission to write to work directory: " + this.m_workDir);
        this.checkWorkingDirectory(!f.isDirectory(), "jspwiki.workDir does not point to a directory: " + this.m_workDir);
        LOG.info("JSPWiki working directory is '{}'", (Object)this.m_workDir);
    }

    void checkWorkingDirectory(boolean condition, String errMsg) throws WikiException {
        if (condition) {
            throw new WikiException(errMsg);
        }
    }

    void initExtraComponents(Map<String, String> extraComponents) {
        for (Map.Entry<String, String> extraComponent : extraComponents.entrySet()) {
            try {
                LOG.info("Registering on WikiEngine {} as {}", (Object)extraComponent.getKey(), (Object)extraComponent.getValue());
                this.initComponent(extraComponent.getKey(), Class.forName(extraComponent.getValue()), new Object[0]);
            }
            catch (Exception e) {
                LOG.error("Unable to start {}", (Object)extraComponent.getKey(), (Object)e);
            }
        }
    }

    <T> void initComponent(Class<T> componentClass, Object ... initArgs) throws Exception {
        this.initComponent(componentClass.getName(), componentClass, initArgs);
    }

    <T> void initComponent(String componentInitClass, Class<T> componentClass, Object ... initArgs) throws Exception {
        Object component = initArgs == null || initArgs.length == 0 ? ClassUtil.getMappedObject((String)componentInitClass) : ClassUtil.getMappedObject((String)componentInitClass, (Object[])initArgs);
        this.managers.put(componentClass, component);
        if (Initializable.class.isAssignableFrom(component.getClass())) {
            ((Initializable)component).initialize((Engine)this, this.m_properties);
        }
    }

    public <T> T getManager(Class<T> manager) {
        return this.managers.entrySet().stream().filter(e -> manager.isAssignableFrom((Class)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public <T> List<T> getManagers(Class<T> manager) {
        return this.managers.entrySet().stream().filter(e -> manager.isAssignableFrom((Class)e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public boolean isConfigured() {
        return this.m_isConfigured;
    }

    void enforceValidTemplateDirectory() {
        if (this.m_servletContext != null) {
            String viewTemplate = "templates" + File.separator + this.getTemplateDir() + File.separator + "ViewTemplate.jsp";
            boolean exists = new File(this.m_servletContext.getRealPath("/") + viewTemplate).exists();
            if (!exists) {
                try {
                    URL url = this.m_servletContext.getResource(viewTemplate);
                    exists = url != null && StringUtils.isNotEmpty((CharSequence)url.getFile());
                }
                catch (MalformedURLException e) {
                    LOG.warn("template not found with viewTemplate {}", (Object)viewTemplate);
                }
            }
            if (!exists) {
                LOG.warn("{} template not found, updating WikiEngine's default template to {}", (Object)this.getTemplateDir(), (Object)"default");
                this.m_templateDir = "default";
            }
        }
    }

    public void initReferenceManager() throws WikiException {
        try {
            if (this.getManager(ReferenceManager.class) == null) {
                ArrayList<Page> pages = new ArrayList<Page>();
                pages.addAll(this.getManager(PageManager.class).getAllPages());
                pages.addAll(this.getManager(AttachmentManager.class).getAllAttachments());
                String refMgrClassName = this.m_properties.getProperty("jspwiki.refManager", ClassUtil.getMappedClass((String)ReferenceManager.class.getName()).getName());
                this.initComponent(refMgrClassName, ReferenceManager.class, this);
                this.getManager(ReferenceManager.class).initialize(pages);
            }
        }
        catch (ProviderException e) {
            LOG.fatal("PageProvider is unable to list pages: ", (Throwable)e);
        }
        catch (Exception e) {
            throw new WikiException("Could not instantiate ReferenceManager: " + e.getMessage(), (Throwable)e);
        }
    }

    public Properties getWikiProperties() {
        return this.m_properties;
    }

    public String getWorkDir() {
        return this.m_workDir;
    }

    public String getTemplateDir() {
        return this.m_templateDir;
    }

    public Date getStartTime() {
        return (Date)this.m_startTime.clone();
    }

    public String getBaseURL() {
        return this.m_servletContext.getContextPath();
    }

    public String getGlobalRSSURL() {
        RSSGenerator rssGenerator = this.getManager(RSSGenerator.class);
        if (rssGenerator != null && rssGenerator.isEnabled()) {
            return this.getBaseURL() + "/" + rssGenerator.getRssFile();
        }
        return null;
    }

    public String getInterWikiURL(String wikiName) {
        return TextUtil.getStringProperty((Properties)this.m_properties, (String)("jspwiki.interWikiRef." + wikiName), null);
    }

    public String getURL(String context, String pageName, String params) {
        if (pageName == null) {
            pageName = this.getFrontPage();
        }
        URLConstructor urlConstructor = this.getManager(URLConstructor.class);
        return urlConstructor.makeURL(context, pageName, params);
    }

    public String getFrontPage() {
        return this.m_frontPage;
    }

    public ServletContext getServletContext() {
        return this.m_servletContext;
    }

    public Collection<String> getAllInterWikiLinks() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<?> i = this.m_properties.propertyNames();
        while (i.hasMoreElements()) {
            String prop = (String)i.nextElement();
            if (!prop.startsWith("jspwiki.interWikiRef.")) continue;
            list.add(prop.substring(prop.lastIndexOf(".") + 1));
        }
        return list;
    }

    public Collection<String> getAllInlinedImagePatterns() {
        ArrayList<String> ptrnlist = new ArrayList<String>();
        Enumeration<?> e = this.m_properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("jspwiki.translatorReader.inlinePattern")) continue;
            ptrnlist.add(TextUtil.getStringProperty((Properties)this.m_properties, (String)name, null));
        }
        if (ptrnlist.isEmpty()) {
            ptrnlist.add("*.png");
        }
        return ptrnlist;
    }

    public String getSpecialPageReference(String original) {
        return this.getManager(CommandResolver.class).getSpecialPageReference(original);
    }

    public String getApplicationName() {
        String appName = TextUtil.getStringProperty((Properties)this.m_properties, (String)"jspwiki.applicationName", (String)"JSPWiki");
        return TextUtil.cleanString((String)appName, (String)" ()&+,-=._$");
    }

    public String getFinalPageName(String page) throws ProviderException {
        return this.getManager(CommandResolver.class).getFinalPageName(page);
    }

    public String encodeName(String pagename) {
        try {
            return URLEncoder.encode(pagename, this.m_useUTF8 ? StandardCharsets.UTF_8.name() : StandardCharsets.ISO_8859_1.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalWikiException("ISO-8859-1 not a supported encoding!?!  Your platform is borked.", e);
        }
    }

    public String decodeName(String pagerequest) {
        try {
            return URLDecoder.decode(pagerequest, this.m_useUTF8 ? StandardCharsets.UTF_8.name() : StandardCharsets.ISO_8859_1.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalWikiException("ISO-8859-1 not a supported encoding!?!  Your platform is borked.", e);
        }
    }

    public Charset getContentEncoding() {
        if (this.m_useUTF8) {
            return StandardCharsets.UTF_8;
        }
        return StandardCharsets.ISO_8859_1;
    }

    public void shutdown() {
        this.fireEvent(1);
        this.getManager(CachingManager.class).shutdown();
        this.getManager(FilterManager.class).destroy();
        WikiEventManager.shutdown();
    }

    @Deprecated
    public TemplateManager getTemplateManager() {
        return this.getManager(TemplateManager.class);
    }

    @Deprecated
    public WorkflowManager getWorkflowManager() {
        return this.getManager(WorkflowManager.class);
    }

    @Deprecated
    public ReferenceManager getReferenceManager() {
        return this.getManager(ReferenceManager.class);
    }

    @Deprecated
    public RenderingManager getRenderingManager() {
        return this.getManager(RenderingManager.class);
    }

    @Deprecated
    public PluginManager getPluginManager() {
        return this.getManager(PluginManager.class);
    }

    @Deprecated
    public VariableManager getVariableManager() {
        return this.getManager(VariableManager.class);
    }

    @Deprecated
    public PageManager getPageManager() {
        return this.getManager(PageManager.class);
    }

    @Deprecated
    public CommandResolver getCommandResolver() {
        return this.getManager(CommandResolver.class);
    }

    @Deprecated
    public AttachmentManager getAttachmentManager() {
        return this.getManager(AttachmentManager.class);
    }

    @Deprecated
    public AuthorizationManager getAuthorizationManager() {
        return this.getManager(AuthorizationManager.class);
    }

    @Deprecated
    public AuthenticationManager getAuthenticationManager() {
        return this.getManager(AuthenticationManager.class);
    }

    @Deprecated
    public FilterManager getFilterManager() {
        return this.getManager(FilterManager.class);
    }

    @Deprecated
    public SearchManager getSearchManager() {
        return this.getManager(SearchManager.class);
    }

    @Deprecated
    public ProgressManager getProgressManager() {
        return this.getManager(ProgressManager.class);
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    @Deprecated
    public URLConstructor getURLConstructor() {
        return this.getManager(URLConstructor.class);
    }

    @Deprecated
    public RSSGenerator getRSSGenerator() {
        return this.getManager(RSSGenerator.class);
    }

    @Deprecated
    public PageRenamer getPageRenamer() {
        return this.getManager(PageRenamer.class);
    }

    @Deprecated
    public UserManager getUserManager() {
        return this.getManager(UserManager.class);
    }

    @Deprecated
    public TasksManager getTasksManager() {
        return this.getManager(TasksManager.class);
    }

    @Deprecated
    public GroupManager getGroupManager() {
        return this.getManager(GroupManager.class);
    }

    @Deprecated
    public AdminBeanManager getAdminBeanManager() {
        return this.getManager(AdminBeanManager.class);
    }

    @Deprecated
    public AclManager getAclManager() {
        return this.getManager(AclManager.class);
    }

    @Deprecated
    public DifferenceManager getDifferenceManager() {
        return this.getManager(DifferenceManager.class);
    }

    @Deprecated
    public EditorManager getEditorManager() {
        return this.getManager(EditorManager.class);
    }

    @Deprecated
    public InternationalizationManager getInternationalizationManager() {
        return this.getManager(InternationalizationManager.class);
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    protected final void fireEvent(int type) {
        if (WikiEventManager.isListening((Object)this)) {
            WikiEventManager.fireEvent((Object)this, (WikiEvent)new WikiEngineEvent((Object)this, type));
        }
    }

    protected final void firePageEvent(int type, String pageName) {
        if (WikiEventManager.isListening((Object)this)) {
            WikiEventManager.fireEvent((Object)this, (WikiEvent)new WikiPageEvent((Object)this, type, pageName));
        }
    }

    public void setAttribute(String key, Object value) {
        this.m_attributes.put(key, value);
    }

    public <T> T getAttribute(String key) {
        return (T)this.m_attributes.get(key);
    }

    public <T> T removeAttribute(String key) {
        return (T)this.m_attributes.remove(key);
    }
}

